/*
 * E2E technologies Ltd
 * Project:
 * Copyright &#169; 2001-2006 E2E technologies Ltd. All rights reserved.
 * $Id: Strings.java,v 1.2 2008/11/17 09:13:47 tzimber Exp $
 */
package ch.e2e.examples.simple;

/**
 * Shows you how to handle with Strings in the E2E Bridge.<br><br>
 * <B>This class can be used to import.</B><br><br>
 * You can use the methods:<br>
 * <ul>
 * <code><li><a href="#substring(String, int)">public String substringBefore(String s, int index)</a></li></code>
 * <code><li><a href="#substringBefore(String, String)">public String substringBefore(String s, String toFind)</a></li></code>
 * <code><li><a href="#substringAfter(String, String)">public String substringAfter(String s, int index)</a></li></code>
 * <code><li><a href="#substringAfter(String, int)">public String substringAfter(String s, String toFind)</a></li></code>
 * <code><li><a href="#toUpperCase(String)">public String toUpperCase(String)</a></li></code>
 * <code><li><a href="#toLowerCase(String)">public String toLowerCase(String)</a></li></code>
 * </ul>
 * Copyright &#169; 2001-2006 E2E technologies Ltd. All rights reserved.
 * @author tzimber
 * @version $Revision: 1.2 $
 */
public class Strings {
	/**
	 * Returns the String before the given String.
	 * @param s The String
	 * @param toFind The String to find in the given String.
	 * @return the String before the given String.
	 */
	public static String substringBefore(String s, String toFind) {
		String result;
		int index = s.indexOf(toFind);
		if (index == -1) {
			result = s;
		} else if (index == 0) {
			result = "";
		} else {
			result = s.substring(0, index);
		}
		return result;
	}

	/**
	 * Returns the String before the given index.
	 * @param s The String
	 * @param index The postion to cut the String
	 * @return the String before the given index.
	 */
	public static String substring(String s, int index) {
		String result;
		if (index == -1) {
			result = s;
		} else if (index == 0) {
			result = "";
		} else {
			result = s.substring(0, index - 1);
		}
		return result;
	}

	/**
	 * Returns the String after the given String.
	 * @param s The String
	 * @param toFind The String to find in the given String.
	 * @return the String after the given String.
	 */
	public static String substringAfter(String s, String toFind) {
		String result;
		int index = s.indexOf(toFind);
		if (index == -1) {
			result = s;
		} else if ((index + toFind.length() - 1) > s.length()) {
			result = "";
		} else {
			result = s.substring(index + toFind.length());
		}
		return result;
	}

	/**
	 * Returns the String after the given index.
	 * @param s The String
	 * @param index The postion to cut the String
	 * @return the String after the given index.
	 */
	public static String substringAfter(String s, int index) {
		String result;
		if (index == -1) {
			result = s;
		} else {
			result = s.substring(index);
		}
		return result;
	}

	/**
	 * Converts the String into uppercase.
	 * @param s The string to convert.
	 * @return the converted String
	 */
	public static String toUpperCase(String s) {
		return s.toUpperCase();
	}

	/**
	 * Converts the String into lowercase.
	 * @param s The string to convert.
	 * @return the converted String
	 */
	public static String toLowerCase(String s) {
		return s.toLowerCase();
	}
}
