/*
 * e2e technologies Ltd.
 * Project:
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * $Id: Album.java,v 1.1 2008/11/14 20:25:11 tzimber Exp $
 */
package ch.e2e.examples.complex;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * Holds all information of an album.
 * Copyright &#169; 2001-2005 E2E technologies Ltd. All rights reserved.
 * @author tzimber
 * @version $Revision: 1.1 $
 */
public class Album {
	/**
	 * The title of this album.
	 */
	private String title;
	/**
	 * The interpreter of this album.
	 */
	private Interpreter interpreter;
	/**
	 * The label announcing this album.
	 */
	private String label;
	/**
	 * The year this album was recorded.
	 */
	private int year;
	/**
	 * The tracks of this album.
	 */
	private Track[] tracks;

	/**
	 * The default constructor of the object.
	 */
	public Album() {}

	/**
	 * Constructs a new Album object, by parsing the xml element from the DB.
	 * @param albumElement The xml element from the DB of this Track object.
	 */
	public Album(Element albumElement) {
		title = albumElement.getAttribute("title");
		interpreter = new Interpreter(albumElement.getAttribute("interpreter"));
		label = albumElement.getAttribute("label");
		year = Integer.parseInt(albumElement.getAttribute("year"));
		readTracks(albumElement.getElementsByTagName("track"));
	}

	/**
	 * Returns the interpreter of the album.
	 * @return the interpreter of the album.
	 */
	public Interpreter getInterpreter() {
		return interpreter;
	}

	/**
	 * Sets the interpreter of the album.
	 * @param interpreter The interpreter of the album.
	 */
	public void setInterpreter(Interpreter interpreter) {
		this.interpreter = interpreter;
	}

	/**
	 * Returns the label of the album.
	 * @return the label of the album.
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * Sets the label of the album.
	 * @param label The label of the album.
	 */
	public void setLabel(String label) {
		this.label = label;
	}

	/**
	 * Returns the title of the album.
	 * @return the title of the album.
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * Sets the title of the album.
	 * @param title The title of the album.
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * Returns the tracks of the album.
	 * @return the tracks of the album.
	 */
	public Track[] getTracks() {
		return tracks;
	}

	/**
	 * The tracks of the album.
	 * @param tracks The tracks of the album.
	 */
	public void setTracks(Track[] tracks) {
		this.tracks = tracks;
	}

	/**
	 * Returns the year of recording the album.
	 * @return the year of recording the album.
	 */
	public int getYear() {
		return year;
	}

	/**
	 * Sets the year of recording the album.
	 * @param year The year of recording the album.
	 */
	public void setYear(int year) {
		this.year = year;
	}

	/**
	 *
	 * @param songTitle The song title to search for.
	 * @param interpreter The interpreter of the song.
	 * @return <code>true</code> if the song is on this album.
	 */
	public boolean containsSong(String songTitle, String interpreter) {
		boolean result = false;
		for (int i = 0; (i < tracks.length) && !result; i++) {
			if ((interpreter == null) || (interpreter.length() == 0)) {
				result = songTitle.equalsIgnoreCase(tracks[i].getTitle());
			} else {
				Interpreter artist = tracks[i].getInterpreter();
				result = ((artist.getFullname().equalsIgnoreCase(interpreter)
						|| artist.getLastname().equalsIgnoreCase(interpreter)))
						&& (songTitle.equalsIgnoreCase(tracks[i].getTitle()));
			}
		}
		return result;
	}

	/**
	 * Creates the tracks from the xml elements of the DB.
	 * @param trackList The nodelist containing the xml elements.
	 */
	private void readTracks(NodeList trackList) {
		tracks = new Track[trackList.getLength()];
		int length = trackList.getLength();
		for (int i = 0; i < length; i++) {
			Element trackElement = (Element)trackList.item(i);
			tracks[i] = new Track(trackElement);
		}
	}
}
