/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.admin;

import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.admin.AP;
import com.ibm.mq.jms.admin.BAOException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Hashtable;
import javax.jms.JMSException;

public class APTMCAST
extends AP {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/admin/APTMCAST.java, jms, j600, j600-101-060328 1.9.1.1 05/05/25 15:51:55";
    public static final String LONGNAME = "MULTICAST";
    public static final String SHORTNAME = "MCAST";
    public static final String MCAST_DISABLED = "DISABLED";
    public static final String MCAST_ASCF = "ASCF";
    public static final String MCAST_ENABLED = "ENABLED";
    public static final String MCAST_RELIABLE = "RELIABLE";
    public static final String MCAST_NOT_RELIABLE = "NOTR";
    public static final String MCAST_AS_CF = "AS_CF";

    public void setObjectFromProperty(Object object, Hashtable hashtable) throws BAOException, JMSException {
        block13: {
            try {
                Object object2;
                if (Trace.isOn) {
                    Trace.entry(this, "setObjectFromProperty");
                }
                if ((object2 = APTMCAST.getProperty(SHORTNAME, hashtable)) == null) break block13;
                int n = APTMCAST.objToInt(object2);
                if (object instanceof MQTopic) {
                    try {
                        ((MQTopic)object).setMulticast(n);
                        break block13;
                    }
                    catch (JMSException jMSException) {
                        BAOException bAOException = new BAOException(4, SHORTNAME, Integer.toString(n));
                        throw bAOException;
                    }
                }
                String string = "object supplied as an unexpected type " + object.getClass();
                String string2 = "MQJMS1016";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                JMSException jMSException = new JMSException(string3, string2);
                throw jMSException;
            }
            catch (BAOException bAOException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + bAOException);
                }
                throw bAOException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "setObjectFromProperty");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyFromObject(Hashtable hashtable, Object object) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setPropertyFromObject");
            }
            if (!(object instanceof MQTopic)) {
                String string = "object is an unexpected type";
                String string2 = "MQJMS1016";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                JMSException jMSException = new JMSException(string3, string2);
                throw jMSException;
            }
            int n = ((MQTopic)object).getMulticast();
            hashtable.put(LONGNAME, APTMCAST.valToString(n));
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setPropertyFromObject");
            }
        }
    }

    public String longName() {
        return LONGNAME;
    }

    public String shortName() {
        return SHORTNAME;
    }

    public static String valToString(int n) throws JMSException {
        if (n == 0) {
            return MCAST_DISABLED;
        }
        if (n == -1) {
            return MCAST_ASCF;
        }
        if (n == 5) {
            return MCAST_RELIABLE;
        }
        if (n == 3) {
            return MCAST_NOT_RELIABLE;
        }
        if (n == 7) {
            return MCAST_ENABLED;
        }
        String string = "MQJMS1016";
        String string2 = ConfigEnvironment.getErrorMessage(string, "Unexpected value: " + n);
        throw new JMSException(string2, string);
    }

    public static int stringToVal(String string) throws BAOException {
        String string2 = string.toUpperCase();
        if (string2.equals(MCAST_DISABLED)) {
            return 0;
        }
        if (string2.equals(MCAST_ASCF) || string2.equals(MCAST_AS_CF)) {
            return -1;
        }
        if (string2.equals(MCAST_RELIABLE)) {
            return 5;
        }
        if (string2.equals(MCAST_NOT_RELIABLE)) {
            return 3;
        }
        if (string2.equals(MCAST_ENABLED)) {
            return 7;
        }
        throw new BAOException(4, SHORTNAME, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int objToInt(Object object) throws BAOException, JMSException {
        try {
            int n;
            if (Trace.isOn) {
                Trace.entry("APTMCAST", "objToInt");
            }
            if (object instanceof Integer) {
                n = (Integer)object;
            } else if (object instanceof String) {
                String string = (String)object;
                n = APTMCAST.stringToVal(string);
            } else {
                String string = "value supplied as an unexpected object type";
                String string2 = "MQJMS1016";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                JMSException jMSException = new JMSException(string3, string2);
                throw jMSException;
            }
            int n2 = n;
            return n2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit("APTMCAST", "objToInt");
            }
        }
    }
}

