/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQQueue;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQSubscription;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;

abstract class MQSubscriptionEngine {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQSubscriptionEngine.java, jms, j600, j600-101-060328 1.18.1.1 05/05/25 16:03:35";
    private static final String CLASSNAME = "MQSubscriptionEngine";
    static final int NON_DURABLE = 0;
    static final int DURABLE = 1;
    protected MQConnection connection = null;

    public MQSubscriptionEngine(MQConnection mQConnection) {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
        }
        this.connection = mQConnection;
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    public abstract MQSubscription openSubscription(MQSession var1, MQTopic var2, String var3, boolean var4, boolean var5, String var6) throws JMSException;

    public abstract void closeSubscription(MQSubscription var1) throws JMSException;

    public abstract MQSubscription openDurableSubscription(MQSession var1, MQTopic var2, String var3, boolean var4, boolean var5, String var6, String var7) throws JMSException;

    public abstract void closeDurableSubscription(MQSubscription var1) throws JMSException;

    public abstract void durableUnsubscribe(MQSession var1, String var2) throws JMSException;

    public abstract void close();

    public final MQConnection getMQConnection() {
        if (Trace.isOn) {
            Trace.entry(this, "getMQConnection");
            Trace.exit(this, "getMQConnection");
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String validateQueueName(String string, int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "validateQueueName");
            }
            String string2 = null;
            if (string.trim().equals("")) {
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "queueName is blank; reverting to MQJMSv1 approach");
                }
                string2 = n == 0 ? "SYSTEM.JMS.ND.*" : "SYSTEM.JMS.D.*";
            } else {
                if (n == 0 && !string.startsWith("SYSTEM.JMS.ND.") || n == 1 && !string.startsWith("SYSTEM.JMS.D.")) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3021", string);
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
                    }
                    throw jMSException;
                }
                string2 = string;
            }
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "validateQueueName returning '" + string2 + "'");
            }
            String string3 = string2;
            return string3;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "validateQueueName");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MQQueue openSubscriberQueue(MQSession mQSession, String string, boolean bl, boolean bl2, int n) throws JMSException {
        try {
            MQQueue mQQueue = null;
            int n2 = 161;
            if (this.connection.getSparseSubscriptions()) {
                n2 |= 8;
            }
            if (n == 1) {
                n2 |= 0x2000;
            }
            String string2 = bl2 ? "SYSTEM.JMS.D." : "SYSTEM.JMS.ND.";
            if (Trace.isOn) {
                Trace.entry(this, "openSubscriberQueue");
            }
            if (string.trim().equals("") && !bl) {
                string = bl2 ? "SYSTEM.JMS.D.*" : "SYSTEM.JMS.ND.*";
            } else if (!string.startsWith(string2)) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3021", string);
                throw jMSException;
            }
            try {
                if (string.endsWith("*") && !bl) {
                    Trace.trace(this, "opening new non-shared subscriber queue");
                    mQQueue = mQSession.qm.accessQueue("SYSTEM.JMS.MODEL.QUEUE", n2, null, string, null);
                    string = mQQueue.name;
                    if (Trace.isOn) {
                        Trace.trace(this, "Using non-shared queue approach.");
                        Trace.trace(this, "Model:  SYSTEM.JMS.MODEL.QUEUE");
                        Trace.trace(this, "Prefix: " + string2);
                        Trace.trace(this, "QName:  " + string);
                    }
                } else if (bl) {
                    mQQueue = mQSession.qm.accessQueue(string, n2);
                    string = mQQueue.name;
                    if (Trace.isOn) {
                        Trace.trace(this, "Using shared queue approach.");
                        Trace.trace(this, "Prefix: " + string2);
                        Trace.trace(this, "QName:  " + string);
                    }
                } else {
                    Trace.trace(this, "Must be re-opening a non-shared queue for an existing subscription");
                    mQQueue = mQSession.qm.accessQueue(string, n2);
                    string = mQQueue.name;
                    if (Trace.isOn) {
                        Trace.trace(this, "Using non-shared queue approach.");
                        Trace.trace(this, "Prefix: " + string2);
                        Trace.trace(this, "QName:  " + string);
                    }
                }
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2008", string);
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
            MQQueue mQQueue2 = mQQueue;
            return mQQueue2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "openSubscriberQueue");
            }
        }
    }

    static {
        if (Trace.isOn) {
            Trace.trace(CLASSNAME, sccsid);
        }
    }
}

