/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQC;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.BrokerConnectionInfo;
import com.ibm.mq.jms.JMSC;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQSubAdmin;
import com.ibm.mq.jms.MQSubEntry;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.SubscriptionHelper;
import com.ibm.mq.jms.SubscriptionInfo;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Session;

class MQPSStatusMgr {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 2001, 2004 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQPSStatusMgr.java, jms, j600, j600-101-060328 1.24.1.1 05/05/25 16:01:02";
    private final String JVM_MSG_SIGNATURE = "MQJMS_PS_JVM_STATUS_MSG";
    private static Hashtable statusMgrConnections;
    private static Integer statusMgrConnectionsLock;
    private MQQueueManager cleanup_qmgr;
    private String cleanup_controlQName;
    private String cleanup_streamQName;
    private static long monitorDelay;
    private static int messageReadDelay;
    private static int statusMgrConnectionThreadID;

    MQPSStatusMgr() {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    MQPSStatusMgr(MQQueueManager mQQueueManager, String string, String string2) {
        if (Trace.isOn) {
            Trace.entry(this, "constructor(qmgr,conq,streamq)");
            Trace.trace(this, sccsid);
        }
        this.cleanup_qmgr = mQQueueManager;
        this.cleanup_controlQName = string;
        this.cleanup_streamQName = string2;
        MQException.log = null;
        if (Trace.isOn) {
            Trace.exit(this, "constructor(qmgr,conq,streamq)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] addConnection(MQConnection mQConnection) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "addConnection");
            }
            Hashtable hashtable = mQConnection.mqProperties;
            String string = mQConnection.getConnectionID();
            StatusMgrConnection statusMgrConnection = null;
            String string2 = hashtable.get("transport").equals("MQSeries Bindings") ? this.cleanup_qmgr.name.trim() : this.cleanup_qmgr.name.trim() + hashtable.get("hostname") + hashtable.get("channel") + hashtable.get("port");
            Object object = statusMgrConnectionsLock;
            synchronized (object) {
                if (statusMgrConnections == null) {
                    statusMgrConnections = new Hashtable();
                } else {
                    statusMgrConnection = (StatusMgrConnection)statusMgrConnections.get(string2);
                }
                if (statusMgrConnection != null) {
                    statusMgrConnection.addUser(string);
                    try {
                        this.cleanup_qmgr.disconnect();
                        this.cleanup_qmgr = null;
                    }
                    catch (MQException mQException) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS3005", mQException.toString());
                        jMSException.setLinkedException((Exception)mQException);
                        if (Trace.isOn) {
                            Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                        }
                        throw jMSException;
                    }
                } else {
                    statusMgrConnection = new StatusMgrConnection(this.cleanup_qmgr, mQConnection);
                    statusMgrConnections.put(string2, statusMgrConnection);
                    this.cleanup_qmgr = null;
                }
            }
            if (Trace.isOn) {
                Trace.trace(this, "addConnection: JVM reference id = " + statusMgrConnection.jvmReferenceId());
            }
            object = statusMgrConnection.jvmReferenceId();
            return object;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "addConnection");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(String string, Hashtable hashtable, String string2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "removeConnection");
        }
        String string3 = hashtable.get("transport").equals("MQSeries Bindings") ? string : string + hashtable.get("hostname") + hashtable.get("channel") + hashtable.get("port");
        Integer n = statusMgrConnectionsLock;
        synchronized (n) {
            StatusMgrConnection statusMgrConnection = (StatusMgrConnection)statusMgrConnections.get(string3);
            if (statusMgrConnection != null) {
                if (statusMgrConnection.removeUser(string2) == 0 && (statusMgrConnection = (StatusMgrConnection)statusMgrConnections.remove(string3)) == null && Trace.isOn) {
                    Trace.trace(this, "removeConnection error: hashtable remove failed");
                }
            } else if (Trace.isOn) {
                Trace.trace(this, "removeConnection error: connection not found. Called from TC finalizer after initial close?");
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "removeConnection");
        }
    }

    void cleanup(MQQueueManager mQQueueManager) {
        block54: {
            if (Trace.isOn) {
                Trace.entry(this, "cleanup");
            }
            try {
                MQQueue mQQueue;
                MQTopicSession mQTopicSession;
                block53: {
                    mQTopicSession = new MQTopicSession(mQQueueManager, this.cleanup_controlQName, this.cleanup_streamQName);
                    int n = 26;
                    mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", n);
                    int n2 = 0;
                    try {
                        while (true) {
                            block52: {
                                boolean bl = false;
                                MQMessage mQMessage = new MQMessage();
                                mQMessage.correlationId = JMSC.PS_JVM_REFMSG_CORRELID;
                                MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                                mQGetMessageOptions.options = n2 == 0 ? 16 : 32;
                                mQQueue.get(mQMessage, mQGetMessageOptions);
                                boolean bl2 = false;
                                String string = "";
                                if (mQMessage.getMessageLength() > 0) {
                                    string = mQMessage.readLine();
                                }
                                if (string.indexOf("MQJMS_PS_JVM_STATUS_MSG") != 0) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "cleanup: Invalid JVM message signature found within status queue message! Removing.");
                                    }
                                    try {
                                        mQQueue.get(mQMessage);
                                    }
                                    catch (MQException mQException) {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "cleanup: remove of invalid msg failed, ignoring. Exception: " + mQException);
                                        }
                                    }
                                } else if (string.indexOf("backout") != -1) {
                                    if (mQMessage.backoutCount > 0) {
                                        bl2 = true;
                                    } else if (Trace.isOn) {
                                        Trace.trace(this, "cleanup: invalid backout count detected; ignoring message.");
                                    }
                                } else {
                                    bl2 = true;
                                }
                                byte[] byArray = mQMessage.messageId;
                                if (bl2) {
                                    int n3 = 0;
                                    try {
                                        while (true) {
                                            MQMessage mQMessage2;
                                            block49: {
                                                mQMessage2 = new MQMessage();
                                                mQMessage2.correlationId = byArray;
                                                mQGetMessageOptions = new MQGetMessageOptions();
                                                mQGetMessageOptions.options = n3 == 0 ? 16 : 32;
                                                mQQueue.get(mQMessage2, mQGetMessageOptions);
                                                MQSubEntry mQSubEntry = new MQSubEntry(mQMessage2);
                                                try {
                                                    SubscriptionHelper.deleteSubscriber(mQTopicSession.getQM(), mQTopicSession.getBrk(), mQSubEntry);
                                                }
                                                catch (JMSException jMSException) {
                                                    bl = true;
                                                    if (!Trace.isOn) break block49;
                                                    Trace.trace(this, "cleanup: Non durable record search caught unexpected exception: " + (Object)((Object)jMSException));
                                                }
                                            }
                                            if (!bl) {
                                                try {
                                                    mQQueue.get(mQMessage2);
                                                }
                                                catch (MQException mQException) {
                                                    bl = true;
                                                    throw mQException;
                                                }
                                            }
                                            ++n3;
                                        }
                                    }
                                    catch (MQException mQException) {
                                        block51: {
                                            if (mQException.reasonCode == 2033) {
                                                if (Trace.isOn) {
                                                    Trace.trace(this, "cleanup: Finished retrieving all non durable records (caught 2033). Found " + n3 + " records");
                                                }
                                            } else {
                                                bl = true;
                                                if (Trace.isOn) {
                                                    Trace.trace(this, "cleanup: Non durable record search caught unexpected exception: " + mQException);
                                                }
                                            }
                                            int n4 = 0;
                                            boolean bl3 = true;
                                            MQSubAdmin mQSubAdmin = null;
                                            try {
                                                mQSubAdmin = new MQSubAdmin(mQTopicSession.qm);
                                                while (bl3) {
                                                    MQSubEntry mQSubEntry = null;
                                                    mQSubEntry = n4 == 0 ? mQSubAdmin.getResolved(mQTopicSession.getQM(), mQTopicSession.getBrk(), null, byArray, false) : mQSubAdmin.getResolved(mQTopicSession.getQM(), mQTopicSession.getBrk(), null, byArray, true);
                                                    if (mQSubEntry != null) {
                                                        block50: {
                                                            if (mQSubEntry.getSubscriberState() == 'u') {
                                                                try {
                                                                    mQSubEntry.setSubscriberState('i');
                                                                    mQSubEntry.setStatusMgrId(MQC.MQCI_NONE);
                                                                    mQSubAdmin.add(mQSubEntry, false);
                                                                    mQSubAdmin.remove(mQSubEntry);
                                                                }
                                                                catch (JMSException jMSException) {
                                                                    bl = true;
                                                                    if (!Trace.isOn) break block50;
                                                                    Trace.trace(this, "cleanup: Durable record search caught unexpected exception: " + (Object)((Object)jMSException));
                                                                }
                                                            }
                                                        }
                                                        ++n4;
                                                        continue;
                                                    }
                                                    bl3 = false;
                                                }
                                                mQSubAdmin.close();
                                                if (Trace.isOn) {
                                                    Trace.trace(this, "cleanup: Finished retrieving all durable records. Found " + n4 + " records");
                                                }
                                            }
                                            catch (JMSException jMSException) {
                                                if (mQSubAdmin != null) {
                                                    mQSubAdmin.close();
                                                }
                                                bl = true;
                                                if (!Trace.isOn) break block51;
                                                Trace.trace(this, "cleanup: Durable record search caught unexpected exception: " + (Object)((Object)jMSException));
                                            }
                                        }
                                        try {
                                            mQGetMessageOptions.options = 16;
                                            mQQueue.get(mQMessage, mQGetMessageOptions);
                                            if (!bl) {
                                                mQQueue.get(mQMessage);
                                            }
                                        }
                                        catch (MQException mQException2) {
                                            if (!Trace.isOn) break block52;
                                            Trace.trace(this, "cleanup: status queue jvm msg remove failed with exception: " + mQException2);
                                        }
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (MQException mQException) {
                        if (mQException.reasonCode == 2033) {
                            if (Trace.isOn) {
                                Trace.trace(this, "cleanup: Finished retrieving all JVM reference messages (caught 2033). Found " + n2 + " msgs");
                            }
                        } else if (Trace.isOn) {
                            Trace.trace(this, "cleanup: JVM ref. msg search caught unexpected  exception: " + mQException);
                        }
                    }
                    catch (IOException iOException) {
                        if (!Trace.isOn) break block53;
                        Trace.trace(this, "cleanup: JVM ref. msg search caught unexpected IO exception: " + iOException);
                    }
                }
                mQTopicSession.qm = null;
                mQTopicSession.close();
                mQTopicSession = null;
                mQQueue.close();
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block54;
                Trace.trace(this, "cleanup ERROR: Caught unexpected exception: " + exception);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "cleanup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forcedCleanup(MQQueueManager mQQueueManager) {
        try {
            Object object;
            String[] stringArray;
            Object object2;
            Object object3;
            Object object4;
            MQTopicSession mQTopicSession = new MQTopicSession(mQQueueManager, this.cleanup_controlQName, this.cleanup_streamQName);
            BrokerConnectionInfo brokerConnectionInfo = mQTopicSession.getBrk();
            System.out.println("Processing SYSTEM.JMS.PS.STATUS.QUEUE");
            int n = 26;
            MQQueue mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", n);
            MQMessage mQMessage = new MQMessage();
            MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
            mQGetMessageOptions.options = 16;
            mQGetMessageOptions.matchOptions = 0;
            while (true) {
                try {
                    mQQueue.get(mQMessage, mQGetMessageOptions);
                }
                catch (MQException mQException) {
                    break;
                }
                if (Utils.byteArraysEqual(mQMessage.correlationId, JMSC.PS_TERMMSG_CORRELID)) {
                    System.out.println("deleting termination message");
                    mQGetMessageOptions.options = 256;
                    mQQueue.get(mQMessage, mQGetMessageOptions);
                } else if (Utils.byteArraysEqual(mQMessage.correlationId, JMSC.PS_JVM_REFMSG_CORRELID)) {
                    System.out.println("deleting JVM reference message");
                    mQGetMessageOptions.options = 256;
                    mQQueue.get(mQMessage, mQGetMessageOptions);
                } else {
                    String string = "";
                    try {
                        string = mQMessage.readStringOfByteLength("MQJMS_PS_SUBENTRY_v2".length());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string.equals("MQJMS_PS_SUBENTRY_v2") || string.equals("MQJMS_PS_ADMIN_ENTRY")) {
                        try {
                            mQMessage.seek(0);
                            MQSubEntry mQSubEntry = new MQSubEntry(mQMessage);
                            System.out.println("deleting subscription: " + mQSubEntry);
                            SubscriptionHelper.deleteSubscriber(mQQueueManager, brokerConnectionInfo, mQSubEntry);
                            mQGetMessageOptions.options = 256;
                            mQQueue.get(mQMessage, mQGetMessageOptions);
                        }
                        catch (JMSException jMSException) {
                            System.err.println("failed to process non-durable subscription: " + (Object)((Object)jMSException));
                            object4 = jMSException.getLinkedException();
                            if (object4 != null) {
                                System.err.println("linked exception: " + object4);
                            }
                        }
                    } else {
                        System.out.println("ignoring unrecognised message on SYSTEM.JMS.PS.STATUS.QUEUE");
                    }
                }
                mQGetMessageOptions.options = 32;
            }
            mQQueue.close();
            System.out.println("processing SYSTEM.JMS.ADMIN.QUEUE");
            MQSubAdmin mQSubAdmin = null;
            try {
                mQSubAdmin = new MQSubAdmin(mQQueueManager);
                boolean bl = false;
                while (true) {
                    object4 = mQSubAdmin.getResolved(mQQueueManager, brokerConnectionInfo, null, null, bl);
                    bl = true;
                    if (object4 == null) break;
                    System.out.println("examining " + object4);
                    if (((MQSubEntry)object4).getSubscriberState() == 'u') {
                        System.out.println("converting to inactive state");
                        try {
                            ((MQSubEntry)object4).setSubscriberState('i');
                            ((MQSubEntry)object4).setStatusMgrId(MQC.MQCI_NONE);
                            mQSubAdmin.add((MQSubEntry)object4, false);
                            mQSubAdmin.remove((MQSubEntry)object4);
                        }
                        catch (JMSException jMSException) {
                            System.err.println("problem changing durable subscription to inactive state: " + (Object)((Object)jMSException));
                            object3 = jMSException.getLinkedException();
                            if (object3 == null) continue;
                            System.err.println("linked exception: " + object3);
                        }
                        continue;
                    }
                    if (((MQSubEntry)object4).getSubscriberState() != 'i') continue;
                    System.out.println("XXX qmEntries needed");
                }
                mQSubAdmin.close();
                mQSubAdmin = null;
            }
            catch (JMSException jMSException) {
                System.err.println("problem whilst processing SYSTEM.JMS.ADMIN.QUEUE: " + (Object)((Object)jMSException));
                object4 = jMSException.getLinkedException();
                if (object4 != null) {
                    System.err.println("linked exception: " + object4);
                }
            }
            finally {
                if (mQSubAdmin != null) {
                    mQSubAdmin.close();
                }
            }
            try {
                System.out.println("Emptying SYSTEM.JMS.ND.SUBSCRIBER.QUEUE");
                try {
                    Utils.clearQueue(mQQueueManager, "SYSTEM.JMS.ND.SUBSCRIBER.QUEUE");
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                n = 2;
                object2 = mQQueueManager.accessQueue("SYSTEM.JMS.ND.SUBSCRIBER.QUEUE", n);
                mQMessage = new MQMessage();
                mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 64;
                mQGetMessageOptions.matchOptions = 0;
                while (true) {
                    try {
                        while (true) {
                            ((MQQueue)object2).get(mQMessage, mQGetMessageOptions, 1);
                        }
                    }
                    catch (MQException mQException) {
                        if (mQException.completionCode != 2) continue;
                        ((MQQueue)object2).close();
                    }
                    break;
                }
            }
            catch (Exception exception) {
                System.err.println("problem whilst processing SYSTEM.JMS.ND.SUBSCRIBER.QUEUE: " + exception);
            }
            try {
                System.out.println("Emptying SYSTEM.JMS.REPORT.QUEUE");
                try {
                    Utils.clearQueue(mQQueueManager, "SYSTEM.JMS.REPORT.QUEUE");
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                n = 2;
                object2 = mQQueueManager.accessQueue("SYSTEM.JMS.REPORT.QUEUE", n);
                mQMessage = new MQMessage();
                mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 64;
                mQGetMessageOptions.matchOptions = 0;
                while (true) {
                    try {
                        while (true) {
                            ((MQQueue)object2).get(mQMessage, mQGetMessageOptions, 1);
                        }
                    }
                    catch (MQException mQException) {
                        if (mQException.completionCode != 2) continue;
                        ((MQQueue)object2).close();
                    }
                    break;
                }
            }
            catch (Exception exception) {
                System.err.println("problem whilst processing SYSTEM.JMS.REPORT.QUEUE: " + exception);
            }
            object2 = new MQTopicConnectionFactory();
            ((MQConnectionFactory)object2).setBrokerControlQueue(this.cleanup_controlQName);
            ((MQConnectionFactory)object2).setBrokerPubQueue(this.cleanup_streamQName);
            object4 = null;
            try {
                object4 = ((MQTopicConnectionFactory)object2).createTopicConnection();
                stringArray = (String[])object4.createTopicSession(false, 1);
                object3 = stringArray.getQM();
                object4.start();
                object = Utils.inquireString((MQManagedObject)object3, 2015);
                if (object == null) {
                    throw new Exception("Unable to resolve queue manager name. Check current user has INQ access to queue manager. Quitting.");
                }
                Vector vector = SubscriptionHelper.getBrokerSubs((String)object, (Session)stringArray);
                SubscriptionInfo subscriptionInfo = new SubscriptionInfo();
                subscriptionInfo.qName = "SYSTEM.JMS.ND.*";
                subscriptionInfo.qMgrName = object;
                if ((vector = SubscriptionHelper.getMatchingSubs(vector, subscriptionInfo)) != null) {
                    for (int i = 0; i < vector.size(); ++i) {
                        SubscriptionInfo subscriptionInfo2 = (SubscriptionInfo)vector.elementAt(i);
                        boolean bl = subscriptionInfo2.correlId != null;
                        MQSubEntry mQSubEntry = new MQSubEntry(null, subscriptionInfo2.topicName, subscriptionInfo2.qName, null, bl);
                        if (bl) {
                            mQSubEntry.setSubscriberId(this.toByteArray(subscriptionInfo2.correlId));
                        }
                        try {
                            System.out.print("Destroying " + subscriptionInfo2.qName.trim());
                            if (bl) {
                                System.out.print(" [" + subscriptionInfo2.correlId + "]");
                            }
                            System.out.println(" subscription... ");
                            System.out.println(mQSubEntry);
                            SubscriptionHelper.deleteSubscriber((MQQueueManager)object3, brokerConnectionInfo, mQSubEntry);
                            continue;
                        }
                        catch (JMSException jMSException) {
                            System.err.println("FAILED with " + (Object)((Object)jMSException));
                        }
                    }
                }
                System.out.println("force cleanup incomplete - code needed to check broker durable subs");
            }
            finally {
                object4.close();
            }
            System.out.println("Checking for orphaned non-durable queues");
            stringArray = Utils.listMatchingQueues(mQQueueManager, "SYSTEM.JMS.ND.*");
            if (stringArray == null) {
                System.out.println("Unable to get list of queues from queue manager - is the command server running?");
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        System.out.println("checking queue: " + stringArray[i]);
                        n = 32;
                        object = mQQueueManager.accessQueue(stringArray[i], n);
                        if (((MQQueue)object).getDefinitionType() != 2) continue;
                        System.out.println("deleting");
                        ((MQQueue)object).closeOptions = 2;
                        ((MQQueue)object).close();
                        continue;
                    }
                    catch (MQException mQException) {
                        System.out.println("couldn't delete " + stringArray[i] + " because of " + mQException);
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Forced cleanup failed: " + exception);
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.cleanup_qmgr = null;
        Integer n = statusMgrConnectionsLock;
        synchronized (n) {
            if (statusMgrConnections != null && statusMgrConnections.isEmpty()) {
                statusMgrConnections = null;
            }
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        String string = "";
        try {
            Object object;
            System.out.println("IBM Websphere MQ JMS pub/sub status manager utility.");
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i].toUpperCase();
                if (((String)object).equals("-M")) {
                    if (i + 1 == stringArray.length) {
                        MQPSStatusMgr.showUsage();
                        continue;
                    }
                    string = stringArray[++i];
                    continue;
                }
                MQPSStatusMgr.showUsage();
            }
            MQQueueManager mQQueueManager = new MQQueueManager(string);
            object = new MQPSStatusMgr(mQQueueManager, "SYSTEM.BROKER.CONTROL.QUEUE", "SYSTEM.BROKER.DEFAULT.STREAM");
            if (bl) {
                ((MQPSStatusMgr)object).forcedCleanup(mQQueueManager);
                System.exit(0);
            }
            System.out.println("Monitor started.");
            System.out.println("Hit ctrl-c to end monitor at any time.");
            while (true) {
                System.out.print("Attempting cleanup... ");
                ((MQPSStatusMgr)object).cleanup(mQQueueManager);
                System.out.println("cleanup complete.");
                try {
                    Thread.sleep(monitorDelay * 1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception exception) {
            System.out.println("Exception thrown during MQPSStatusMgr init: " + exception);
            return;
        }
    }

    public static void showUsage() {
        System.out.println("Usage: java com.ibm.mq.jms.MQPSStatusMgr [options]");
        System.out.println("Options:");
        System.out.println("-m <qmgrName>\tSpecify the queue manager to connect to");
        System.exit(-1);
    }

    private byte[] toByteArray(String string) {
        byte[] byArray = null;
        if (string != null) {
            int n = string.length();
            byArray = new byte[n / 2];
            for (int i = 0; i < n; i += 2) {
                byte by;
                byArray[i / 2] = by = (byte)Integer.parseInt(string.substring(i, i + 2), 16);
            }
        }
        return byArray;
    }

    static {
        statusMgrConnectionsLock = new Integer(0);
        monitorDelay = 30L;
        statusMgrConnectionThreadID = 0;
    }

    class StatusMgrConnection
    implements Runnable {
        public static final int MAX_SHUTDOWN_TIME = 5000;
        private MQQueueManager qmgr;
        private MQQueue statusQueue;
        private byte[] jvmReferenceId = null;
        private Object longRunningTranLock = new Object();
        private boolean longRunningTranWaiting = false;
        private boolean longRunningTranPosted = false;
        private boolean longRunningTranEnd = false;
        private boolean runFinished = false;
        private int refreshDelay;
        private MQConnection topicConn;
        private Vector usageVector;
        private Thread thread;

        StatusMgrConnection(MQQueueManager mQQueueManager, MQConnection mQConnection) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "constructor");
            }
            this.qmgr = mQQueueManager;
            this.topicConn = mQConnection;
            this.refreshDelay = mQConnection.getStatusRefreshInterval();
            try {
                this.statusQueue = mQQueueManager.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", 18);
                this.putJVMMessage(this.qmgr);
                this.usageVector = new Vector();
                this.addUser(mQConnection.getConnectionID());
                String string = "statusMgrConnection" + statusMgrConnectionThreadID;
                statusMgrConnectionThreadID++;
                this.thread = MQEnvironment.createThread(this, string, true);
                this.thread.start();
            }
            catch (MQException mQException) {
                JMSException jMSException = mQException.reasonCode == 2085 ? ConfigEnvironment.newException("MQJMS3014", "SYSTEM.JMS.PS.STATUS.QUEUE") : ConfigEnvironment.newException("MQJMS3005", mQException.toString());
                jMSException.setLinkedException((Exception)mQException);
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "constructor");
                }
            }
        }

        void addUser(String string) {
            if (Trace.isOn) {
                Trace.entry(this, "addUser");
            }
            if (!this.usageVector.contains(string)) {
                this.usageVector.addElement(string);
            } else if (Trace.isOn) {
                Trace.trace(this, "addUser error: token already exists.");
            }
            if (Trace.isOn) {
                Trace.exit(this, "addUser");
            }
        }

        int removeUser(String string) throws JMSException {
            int n;
            if (Trace.isOn) {
                Trace.entry(this, "removeUser");
            }
            if (!this.usageVector.contains(string)) {
                if (Trace.isOn) {
                    Trace.trace(this, "removeUser error: token not found.");
                }
            } else {
                this.usageVector.removeElement(string);
            }
            if ((n = this.usageVector.size()) == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "removeUser: no users left; closing connection.");
                }
                this.close();
            }
            if (Trace.isOn) {
                Trace.exit(this, "removeUser");
            }
            return n;
        }

        private void putJVMMessage(MQQueueManager mQQueueManager) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "putJVMMessage");
            }
            try {
                MQMessage mQMessage = new MQMessage();
                if (this.jvmReferenceId != null) {
                    mQMessage.messageId = this.jvmReferenceId;
                }
                mQMessage.correlationId = JMSC.PS_JVM_REFMSG_CORRELID;
                mQMessage.writeString("MQJMS_PS_JVM_STATUS_MSG");
                mQMessage.writeString("backout");
                this.statusQueue.put(mQMessage);
                if (this.jvmReferenceId == null) {
                    this.jvmReferenceId = mQMessage.messageId;
                }
                MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 2;
                this.statusQueue.get(mQMessage, mQGetMessageOptions);
                mQMessage.clearMessage();
                mQMessage.writeString("MQJMS_PS_JVM_STATUS_MSG");
                mQMessage.writeString("commit");
                MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
                mQPutMessageOptions.options = 2;
                this.statusQueue.put(mQMessage, mQPutMessageOptions);
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3005", mQException.toString());
                jMSException.setLinkedException((Exception)mQException);
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
            catch (IOException iOException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3005", iOException.toString());
                jMSException.setLinkedException((Exception)iOException);
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "putJVMMessage");
                }
            }
        }

        private void removeJVMMessage(MQQueueManager mQQueueManager) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "removeJVMMessage");
            }
            try {
                MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 2;
                MQMessage mQMessage = new MQMessage();
                mQMessage.messageId = this.jvmReferenceId;
                this.statusQueue.get(mQMessage, mQGetMessageOptions);
                if (mQQueueManager != null) {
                    mQQueueManager.commit();
                } else {
                    Trace.trace(this, "Saved NullPointerException on qm.commit");
                }
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3005", mQException.toString());
                jMSException.setLinkedException((Exception)mQException);
                if (Trace.isOn) {
                    Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                    Trace.trace(this, "Linked Exception " + mQException);
                    Trace.exit(this, "removeJVMMessage");
                }
                throw jMSException;
            }
            if (Trace.isOn) {
                Trace.exit(this, "removeJVMMessage");
            }
        }

        private void refreshJVMMessage(MQQueueManager mQQueueManager) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "refreshJVMMessage");
            }
            try {
                MQMessage mQMessage = new MQMessage();
                mQMessage.messageId = this.jvmReferenceId;
                mQMessage.correlationId = JMSC.PS_JVM_REFMSG_CORRELID;
                mQMessage.writeString("MQJMS_PS_JVM_STATUS_MSG");
                mQMessage.writeString("backout");
                this.statusQueue.put(mQMessage);
                MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 2;
                this.statusQueue.get(mQMessage, mQGetMessageOptions);
                mQQueueManager.commit();
                this.statusQueue.get(mQMessage, mQGetMessageOptions);
                mQMessage.clearMessage();
                mQMessage.writeString("MQJMS_PS_JVM_STATUS_MSG");
                mQMessage.writeString("commit");
                MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
                mQPutMessageOptions.options = 2;
                this.statusQueue.put(mQMessage, mQPutMessageOptions);
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3005", mQException.toString());
                jMSException.setLinkedException((Exception)mQException);
                if (Trace.isOn) {
                    Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Linked Exception " + mQException);
                }
                throw jMSException;
            }
            catch (IOException iOException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3005", iOException.toString());
                jMSException.setLinkedException((Exception)iOException);
                if (Trace.isOn) {
                    Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Linked Exception " + iOException);
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "refreshJVMMessage");
                }
            }
        }

        byte[] jvmReferenceId() {
            return this.jvmReferenceId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() throws JMSException {
            boolean bl = false;
            if (Trace.isOn) {
                Trace.entry(this, "close");
            }
            Object object = this.longRunningTranLock;
            synchronized (object) {
                this.longRunningTranEnd = true;
                if (this.longRunningTranWaiting) {
                    this.longRunningTranPosted = true;
                    bl = true;
                }
            }
            if (Trace.isOn) {
                Trace.trace(this, "close ending run() loop");
            }
            try {
                if (bl) {
                    object = this.topicConn.createQMNonXA();
                    this.topicConn = null;
                    MQQueue mQQueue = ((MQQueueManager)object).accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", 16);
                    MQMessage mQMessage = new MQMessage();
                    mQMessage.messageId = this.jvmReferenceId;
                    mQMessage.correlationId = JMSC.PS_TERMMSG_CORRELID;
                    mQMessage.expiry = 36000;
                    mQMessage.persistence = 0;
                    mQQueue.put(mQMessage);
                    ((MQQueueManager)object).disconnect();
                }
                this.waitForRunFinished();
                this.usageVector = null;
                this.qmgr = null;
                this.jvmReferenceId = null;
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3005", mQException.toString());
                jMSException.setLinkedException((Exception)mQException);
                if (Trace.isOn) {
                    Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Linked Exception " + mQException);
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "close");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void setRunFinished() {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setRunFinished");
                }
                this.runFinished = true;
                this.notifyAll();
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "setRunFinished");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void waitForRunFinished() {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "waitForRunFinished");
                }
                long l = System.currentTimeMillis();
                long l2 = l + 5000L;
                while (!this.runFinished && l < l2) {
                    try {
                        this.wait(l2 - l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    l = System.currentTimeMillis();
                }
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "waitForRunFinished");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block36: {
                boolean bl = false;
                if (Trace.isOn) {
                    Trace.entry(this, "run");
                }
                MQPSStatusMgr.this.cleanup(this.qmgr);
                MQMessage mQMessage = new MQMessage();
                MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                Object object = this.longRunningTranLock;
                synchronized (object) {
                    this.longRunningTranWaiting = !this.longRunningTranEnd;
                }
                while (this.longRunningTranWaiting) {
                    mQMessage.messageId = this.jvmReferenceId;
                    mQMessage.correlationId = JMSC.PS_TERMMSG_CORRELID;
                    mQGetMessageOptions.options = 1;
                    mQGetMessageOptions.waitInterval = this.refreshDelay;
                    try {
                        if (Trace.isOn) {
                            Trace.trace(this, "run() attempting get/wait");
                        }
                        this.statusQueue.get(mQMessage, mQGetMessageOptions);
                        object = this.longRunningTranLock;
                        synchronized (object) {
                            this.longRunningTranWaiting = false;
                        }
                        if (this.longRunningTranEnd || !Trace.isOn) continue;
                        Trace.trace(this, "run() error: invalid message retrieved?");
                    }
                    catch (MQException mQException) {
                        Object object2;
                        if (mQException.reasonCode == 2033) {
                            if (Trace.isOn) {
                                Trace.trace(this, "run() get/wait finished with 2033 - refreshing JVM msg");
                            }
                            this.refreshJVMMessage(this.qmgr);
                            object2 = this.longRunningTranLock;
                            synchronized (object2) {
                                if (this.longRunningTranPosted) {
                                    if (bl) {
                                        this.longRunningTranWaiting = false;
                                    } else {
                                        bl = true;
                                    }
                                }
                                continue;
                            }
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "run() error: caught unexpected  exception attempting get/wait: " + mQException);
                        }
                        object2 = ConfigEnvironment.newException("MQJMS3005", mQException.toString());
                        object2.setLinkedException((Exception)mQException);
                        if (Trace.isOn) {
                            Trace.trace(this, "Create & Throwing " + (Object)object2);
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "Linked Exception " + mQException);
                        }
                        throw object2;
                    }
                }
                this.removeJVMMessage(this.qmgr);
                Object var9_11 = null;
                try {
                    this.qmgr.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.qmgr = null;
                this.setRunFinished();
                if (Trace.isOn) {
                    Trace.exit(this, "run");
                }
                break block36;
                {
                    catch (JMSException jMSException) {
                        if (Trace.isOn) {
                            Trace.exception(this, "run", (Throwable)jMSException);
                        }
                        Object var9_12 = null;
                        try {
                            this.qmgr.disconnect();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.qmgr = null;
                        this.setRunFinished();
                        if (Trace.isOn) {
                            Trace.exit(this, "run");
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    try {
                        this.qmgr.disconnect();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.qmgr = null;
                    this.setRunFinished();
                    if (Trace.isOn) {
                        Trace.exit(this, "run");
                    }
                    throw throwable;
                }
            }
        }
    }
}

