/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQConnectionRequestInfo;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.StoredManagedConnection;
import com.ibm.mqservices.Trace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.resource.spi.ConnectionRequestInfo;

class ManagedConnectionStore {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/ManagedConnectionStore.java, java, j600, j600-101-060328 1.12.1.1 05/05/25 15:39:38";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Hashtable store = new Hashtable();

    ManagedConnectionStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(StoredManagedConnection storedManagedConnection) {
        Vector<StoredManagedConnection> vector;
        if (Trace.isOn) {
            Trace.entry(this, "register");
        }
        Object object = storedManagedConnection.cxReqInf;
        if (storedManagedConnection.cxReqInf instanceof MQConnectionRequestInfo) {
            object = ((MQConnectionRequestInfo)storedManagedConnection.cxReqInf).getKeyObject();
        }
        Tuple tuple = new Tuple(storedManagedConnection.mqMcf, object);
        Hashtable hashtable = this.store;
        synchronized (hashtable) {
            vector = (Vector<StoredManagedConnection>)this.store.get(tuple);
            if (vector == null) {
                vector = new Vector<StoredManagedConnection>();
                this.store.put(tuple, vector);
            }
        }
        vector.insertElementAt(storedManagedConnection, 0);
        if (Trace.isOn) {
            Trace.exit(this, "register");
        }
    }

    void deregister(StoredManagedConnection storedManagedConnection) {
        Tuple tuple;
        Vector vector;
        if (Trace.isOn) {
            Trace.entry(this, "deregister");
        }
        Object object = storedManagedConnection.cxReqInf;
        if (storedManagedConnection.cxReqInf instanceof MQConnectionRequestInfo) {
            object = ((MQConnectionRequestInfo)storedManagedConnection.cxReqInf).getKeyObject();
        }
        if ((vector = (Vector)this.store.get(tuple = new Tuple(storedManagedConnection.mqMcf, object))) != null) {
            vector.removeElement(storedManagedConnection);
        }
        if (Trace.isOn) {
            Trace.exit(this, "deregister");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StoredManagedConnection chooseOne(MQManagedConnectionFactory mQManagedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) {
        if (Trace.isOn) {
            Trace.entry(this, "chooseOne");
        }
        Object object = connectionRequestInfo;
        if (connectionRequestInfo instanceof MQConnectionRequestInfo) {
            object = ((MQConnectionRequestInfo)connectionRequestInfo).getKeyObject();
        }
        Tuple tuple = new Tuple(mQManagedConnectionFactory, object);
        StoredManagedConnection storedManagedConnection = null;
        boolean bl = false;
        Enumeration enumeration = this.store.elements();
        Enumeration enumeration2 = this.store.keys();
        Object var9_9 = null;
        Tuple tuple2 = null;
        Vector vector = null;
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            tuple2 = (Tuple)enumeration2.nextElement();
            var9_9 = enumeration.nextElement();
            if (!((Object)mQManagedConnectionFactory).equals(tuple2.o1) || !object.equals(tuple2.o2)) continue;
            vector = var9_9;
            break;
        }
        if (vector != null) {
            vector = (Vector)vector.clone();
            Enumeration enumeration3 = vector.elements();
            while (!bl && enumeration3.hasMoreElements()) {
                storedManagedConnection = (StoredManagedConnection)enumeration3.nextElement();
                if (storedManagedConnection.mqManCon == null) {
                    return null;
                }
                MQManagedConnectionJ11 mQManagedConnectionJ11 = storedManagedConnection.mqManCon;
                synchronized (mQManagedConnectionJ11) {
                    if (connectionRequestInfo instanceof MQConnectionRequestInfo) {
                        if (((MQConnectionRequestInfo)connectionRequestInfo).variableIsSuitable(storedManagedConnection.mqManCon)) {
                            bl = storedManagedConnection.use();
                        }
                    } else {
                        bl = storedManagedConnection.use();
                    }
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "chooseOne");
        }
        if (bl && storedManagedConnection != null) {
            return storedManagedConnection;
        }
        return null;
    }

    private class Tuple {
        Object o1;
        Object o2;

        Tuple(Object object, Object object2) {
            this.o1 = object;
            this.o2 = object2;
        }

        public boolean equals(Object object) {
            Tuple tuple = (Tuple)object;
            return this.o1.equals(tuple.o1) && this.o2.equals(tuple.o2);
        }

        public int hashCode() {
            return 13 * this.o1.hashCode() + 17 * this.o2.hashCode();
        }
    }
}

