/*
 * Copyright: Scheer E2E AG
 */
package ch.e2e.bridge.server.office;

import java.util.*;

@SuppressWarnings("UnusedDeclaration")
public class Sheet {
    private String sheetName;
    private int numberOfRows;
    private int numberOfColumns;
    private List<Row> rows;

    Sheet(org.apache.poi.ss.usermodel.Sheet poiSheet, Workbook workbook) {
        sheetName = poiSheet.getSheetName();
        rows = new RowList(poiSheet, workbook);
    }

    public Sheet() {
    }

    public List<Row> getRows() {
        return rows;
    }

    public void setRows(List<Row> rows) {
        this.rows = new RowList(rows);
    }

    public String getSheetName() {
        return sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public int getNumberOfRows() {
        return rows.size();
    }

    public void setNumberOfRows(int numberOfRows) {
//		this.numberOfRows = numberOfRows;
    }

    public int getNumberOfColumns() {
        return numberOfColumns;
    }

    public void setNumberOfColumns(int numberOfColumns) {
//		this.numberOfColumns = numberOfColumns;
    }

    private class RowList extends AbstractList<Row> {
        private final int size;
        private final Map<Integer, Row> map;

        RowList(org.apache.poi.ss.usermodel.Sheet poiSheet, Workbook workbook) {
            numberOfColumns = 0;
            if (poiSheet.getPhysicalNumberOfRows() == 0) {
                size = 0;
                map = Collections.emptyMap();
            } else {
                map = new HashMap<Integer, Row>();
                size = poiSheet.getLastRowNum() + 1;
                for (int i = poiSheet.getFirstRowNum(); i < size; i++) {
                    final org.apache.poi.ss.usermodel.Row poiRow = poiSheet.getRow(i);
                    if (poiRow != null) {
                        final Row row = new Row(poiRow, workbook);
                        if (!workbook.getOmitEmptyCells() || row.getPhysicalNumberOfCells() > 0)
                            map.put(poiRow.getRowNum(), row);
                        numberOfColumns = Math.max(numberOfColumns, poiRow.getLastCellNum());
                    }
                }
            }
        }

        RowList(List<Row> list) {
            numberOfColumns = 0;
            if (list == null) {
                size = 0;
                map = Collections.emptyMap();
            } else {
                size = list.size();
                map = new HashMap<Integer, Row>();
                for (int i = 0; i < size; i++) {
                    final Row row = list.get(i);
                    if (row != null) {
                        map.put(i, row);
                        numberOfColumns = Math.max(numberOfColumns, row.getNumberOfCells());
                    }
                }
            }
        }

        @Override
        public Row get(int index) {
            if (index < 0 || index >= size) throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
            return map.get(index);
        }

        @Override
        public int size() {
            return size;
        }
    }
}
