/*
 * E2E Technologies Ltd
 * Project: 
 * Copyright &#169; 2001-2012 E2E Technologies Ltd. All rights reserved.
 * $Id: ExcelGenerator.java,v 1.2 2012/05/08 08:31:51 pmuessig Exp $
 */
package ch.e2e.excelgenerator;

import net.sf.jxls.transformer.XLSTransformer;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Copyright &#169; 2001-2012 E2E Technologies Ltd. All rights reserved.
 *
 * @author pmuessig
 * @version $Revision: 1.2 $
 */
public class ExcelGenerator {

	@SuppressWarnings("UnusedDeclaration")
	public static void generateExcel(String filename, Map<String, ch.e2e.excelgenerator.Data> data, String templateFilename) throws IOException, InvalidFormatException, ParseException {
		new XLSTransformer().transformXLS(templateFilename, createMap(data), filename);
	}

	private static Map<String, Object> createMap(Map<String, ch.e2e.excelgenerator.Data> data) throws ParseException {
		Map<String, Object> map = new HashMap<String, Object>();
		for (Map.Entry<String, ch.e2e.excelgenerator.Data> entry : data.entrySet()) {
			map.put(entry.getKey(), create(entry.getValue()));
		}
		return map;
	}

	private static Data create(ch.e2e.excelgenerator.Data data) throws ParseException {
		final Data _data = new Data(data.getRows().size());
		for (ch.e2e.excelgenerator.Row row : data.getRows()) {
			final List<ch.e2e.excelgenerator.Cell> cells = row.getCells();
			final int nCells = cells.size();
			final Row _row = new Row(nCells);
			for (int i = 0; i < nCells; i++) {
				_row.addCell(new Cell(cells.get(i).getValue(), data.getType(i)));
			}
			_data.addRow(_row);
		}
		return _data;
	}

	public static class Data {
		final List<Row> rows;

		public Data(int nRows) {
			rows = new ArrayList<Row>(nRows);
		}

		public List<Row> getRows() {
			return rows;
		}

		public void addRow(Row row) {
			rows.add(row);
		}
	}

	public static class Row {
		final List<Cell> cells;

		public Row(int nCells) {
			cells = new ArrayList<Cell>(nCells);
		}

		public List<Cell> getCells() {
			return cells;
		}

		public void addCell(Cell cell) {
			cells.add(cell);
		}
	}

	public static class Cell {
		final Object value;

		public Cell(String value, String type) throws ParseException {
			if ("Number".equalsIgnoreCase(type)) {
				this.value = Converter.asNumber(value);
			} else if ("Date".equalsIgnoreCase(type)) {
				this.value = Converter.asDate(value);
			} else {
				this.value = Converter.asText(value);
			}
		}
		public Object getValue() {
			return value;
		}
	}

	private static class Converter {
		private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.S");

		public static float asNumber(String value) {
			return Float.parseFloat(value);
		}

		public static String asText(String value) {
			return value;
		}

		public static Date asDate(String value) throws ParseException {
			return DATE_FORMAT.parse(value);
		}
	}
}
