/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQXAQueueManager;
import com.ibm.mq.MQXAResource;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQQueueConnection;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.MQQueueSession;
import com.ibm.mq.jms.MQXAQueueSession;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.transaction.xa.XAException;

public class MQXAQueueConnection
extends MQQueueConnection
implements XAQueueConnection {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQXAQueueConnection.java, jms, j600, j600-101-060328 1.18.1.1 05/05/25 15:57:42";

    MQXAQueueConnection(MQQueueConnectionFactory mQQueueConnectionFactory) throws JMSException {
        super(mQQueueConnectionFactory);
        if (Trace.isOn) {
            Trace.trace(this, sccsid);
        }
    }

    MQXAQueueConnection(MQQueueConnectionFactory mQQueueConnectionFactory, String string, String string2) throws JMSException {
        super(mQQueueConnectionFactory, string, string2);
        if (Trace.isOn) {
            Trace.trace(this, sccsid);
        }
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        try {
            MQXAQueueSession mQXAQueueSession;
            if (Trace.isOn) {
                Trace.entry(this, "createXAQueueSession");
            }
            MQQueueSession mQQueueSession = (MQQueueSession)super.createQueueSession(true, 0, 1);
            MQQueueManager mQQueueManager = mQQueueSession.getQM();
            MQXAQueueManager mQXAQueueManager = new MQXAQueueManager(mQQueueManager);
            MQXAResource mQXAResource = mQXAQueueManager.getXAResource();
            MQXAQueueSession mQXAQueueSession2 = mQXAQueueSession = new MQXAQueueSession((MQConnection)this, mQQueueSession, mQXAResource);
            return mQXAQueueSession2;
        }
        catch (XAException xAException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1068");
            jMSException.setLinkedException((Exception)xAException);
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Trace.trace(this, "linked exception " + xAException);
                Trace.trace(this, "linked exception reasonCode: " + xAException.errorCode);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createXAQueueSession");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XASession createXASession() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createXASession");
            }
            XAQueueSession xAQueueSession = this.createXAQueueSession();
            return xAQueueSession;
        }
        finally {
            if (Trace.isOn) {
                Trace.entry(this, "createXASession");
            }
        }
    }
}

