/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQQueueConnection;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class MQQueueConnectionFactory
extends MQConnectionFactory
implements QueueConnectionFactory,
Referenceable,
Serializable {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQQueueConnectionFactory.java, jms, j600, j600-101-060328 1.66.1.1 05/05/25 15:56:16";
    static final long serialVersionUID = 3763813191978525893L;
    public static final String KEY_TEMPORARY_MODEL = "TM";
    public static final String KEY_MESSAGE_RETENTION = "MRET";
    public static final String KEY_TEMPQ_PREFIX = "TQPFX";
    private String temporaryModel = "SYSTEM.DEFAULT.MODEL.QUEUE";
    private int messageRetention = 1;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQQueueConnectionFactory;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQQueueConnectionFactoryFactory;

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createQueueConnection(null, null);
    }

    public QueueConnection createQueueConnection(String string, String string2) throws JMSException {
        try {
            MQQueueConnection mQQueueConnection;
            if (Trace.isOn) {
                Trace.entry(this, "createQueueConnection");
                Trace.trace(this, "userName = " + string);
                if (string2 != null) {
                    Trace.trace(this, " password not null");
                }
            }
            if (MQEnvironment.runningInWS() && string != null && string.length() > 12) {
                if (Trace.isOn) {
                    Trace.trace(this, "Running in Websphere with userName longer than 12 chars");
                    Trace.trace(this, "UserName is " + string);
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1092", string);
                throw jMSException;
            }
            int n = this.getTransportType();
            switch (n) {
                case 0: 
                case 3: {
                    if (string == null) {
                        mQQueueConnection = new MQQueueConnection(this);
                        break;
                    }
                    mQQueueConnection = new MQQueueConnection(this, string, string2);
                    break;
                }
                case 1: {
                    if (string == null) {
                        string = System.getProperty("user.name");
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "connecting as user: " + string);
                    }
                    mQQueueConnection = new MQQueueConnection(this, string, string2);
                    break;
                }
                default: {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1008", String.valueOf(n));
                    throw jMSException;
                }
            }
            mQQueueConnection.mapNameStyle = this.mapNameStyle;
            MQQueueConnection mQQueueConnection2 = mQQueueConnection;
            return mQQueueConnection2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Exception exception = jMSException.getLinkedException();
                Trace.trace(this, "Caught & Throwing " + (Object)((Object)jMSException));
                if (exception != null) {
                    Trace.trace(this, "linked exception: " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createQueueConnection");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference getReference() throws NamingException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getReference");
            }
            Reference reference = new Reference((class$com$ibm$mq$jms$MQQueueConnectionFactory == null ? (class$com$ibm$mq$jms$MQQueueConnectionFactory = MQQueueConnectionFactory.class$("com.ibm.mq.jms.MQQueueConnectionFactory")) : class$com$ibm$mq$jms$MQQueueConnectionFactory).getName(), (class$com$ibm$mq$jms$MQQueueConnectionFactoryFactory == null ? (class$com$ibm$mq$jms$MQQueueConnectionFactoryFactory = MQQueueConnectionFactory.class$("com.ibm.mq.jms.MQQueueConnectionFactoryFactory")) : class$com$ibm$mq$jms$MQQueueConnectionFactoryFactory).getName(), null);
            this.populateReference(reference);
            Reference reference2 = reference;
            return reference2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getReference");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        try {
            boolean bl;
            if (Trace.isOn) {
                Trace.entry(this, "equals");
            }
            if (object == null) {
                bl = false;
            } else if (object instanceof MQQueueConnectionFactory) {
                MQQueueConnectionFactory mQQueueConnectionFactory = (MQQueueConnectionFactory)object;
                bl = super.equalsCommon(object) && MQQueueConnectionFactory.twoStringsEqual(this.temporaryModel, mQQueueConnectionFactory.temporaryModel) && MQQueueConnectionFactory.twoStringsEqual(this.tempQPrefix, mQQueueConnectionFactory.tempQPrefix) && this.messageRetention == mQQueueConnectionFactory.messageRetention;
            } else {
                bl = false;
            }
            if (Trace.isOn) {
                Trace.trace(this, "equals - result is " + bl);
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "equals");
            }
        }
    }

    public int hashCode() {
        int n = super.hashCode();
        if (this.temporaryModel != null) {
            n ^= this.temporaryModel.hashCode();
        }
        return n ^= this.messageRetention << 13;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateReference(Reference reference) throws OperationNotSupportedException {
        String string = null;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "populateReference");
            }
            super.updateReference(reference);
            string = this.getTemporaryModel();
            if (string != null) {
                reference.add(new StringRefAddr(KEY_TEMPORARY_MODEL, string));
            }
            if ((string = this.getTempQPrefix()) != null) {
                reference.add(new StringRefAddr(KEY_TEMPQ_PREFIX, string));
            }
            reference.add(new StringRefAddr(KEY_MESSAGE_RETENTION, String.valueOf(this.getMessageRetention())));
        }
        catch (JMSException jMSException) {
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "populateReference");
            }
        }
    }

    void setFromReference(Reference reference) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setFromReference");
            }
            super.setCommonFromReference(reference);
            RefAddr refAddr = reference.get(KEY_TEMPORARY_MODEL);
            if (refAddr != null) {
                this.setTemporaryModel((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_TEMPQ_PREFIX)) != null) {
                this.setTempQPrefix((String)refAddr.getContent());
            }
            if ((refAddr = reference.get(KEY_MESSAGE_RETENTION)) != null) {
                this.setMessageRetention(Integer.parseInt((String)refAddr.getContent()));
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setFromReference");
            }
        }
    }

    public String getBrokerControlQueue() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public String getBrokerQueueManager() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public String getBrokerPubQueue() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public String getBrokerSubQueue() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public String getBrokerCCSubQueue() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public int getBrokerVersion() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public int getMessageSelection() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public int getPubAckInterval() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public int getStatusRefreshInterval() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public int getSubscriptionStore() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public int getCleanupLevel() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public long getCleanupInterval() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public int getCloneSupport() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public boolean getSparseSubscriptions() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public int getMulticast() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public String getProxyHostName() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public int getProxyPort() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public int getDirectAuth() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public int getMaxBufferSize() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public int getReceiveIsolation() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public boolean getOutcomeNotification() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public int getProcessDuration() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public boolean getOptimisticPublication() throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setStatusRefreshInterval(int n) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setSubscriptionStore(int n) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setBrokerControlQueue(String string) throws JMSException {
        String string2 = "MQJMS1112";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
        throw illegalStateException;
    }

    public void setBrokerQueueManager(String string) throws JMSException {
        String string2 = "MQJMS1112";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
        throw illegalStateException;
    }

    public void setBrokerPubQueue(String string) throws JMSException {
        String string2 = "MQJMS1112";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
        throw illegalStateException;
    }

    public void setBrokerSubQueue(String string) throws JMSException {
        String string2 = "MQJMS1112";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
        throw illegalStateException;
    }

    public void setBrokerCCSubQueue(String string) throws JMSException {
        String string2 = "MQJMS1112";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
        throw illegalStateException;
    }

    public void setBrokerVersion(int n) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setBrokerVersionDefault(int n) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setMessageSelection(int n) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setCleanupLevel(int n) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setCleanupInterval(long l) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setCloneSupport(int n) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setSparseSubscriptions(boolean bl) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setMulticast(int n) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setProxyHostName(String string) throws JMSException {
        String string2 = "MQJMS1112";
        String string3 = ConfigEnvironment.getErrorMessage(string2);
        IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
        throw illegalStateException;
    }

    public void setProxyPort(int n) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setPubAckInterval(int n) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setDirectAuth(int n) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setMaxBufferSize(int n) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setReceiveIsolation(int n) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setOutcomeNotification(boolean bl) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setProcessDuration(int n) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setOptimisticPublication(boolean bl) throws JMSException {
        String string = "MQJMS1112";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection createConnection() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createConnection");
            }
            MQQueueConnection mQQueueConnection = (MQQueueConnection)this.createQueueConnection();
            mQQueueConnection.mapNameStyle = this.mapNameStyle;
            MQQueueConnection mQQueueConnection2 = mQQueueConnection;
            return mQQueueConnection2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createConnection");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection createConnection(String string, String string2) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createConnection(userName, password");
            }
            MQQueueConnection mQQueueConnection = (MQQueueConnection)this.createQueueConnection(string, string2);
            mQQueueConnection.mapNameStyle = this.mapNameStyle;
            MQQueueConnection mQQueueConnection2 = mQQueueConnection;
            return mQQueueConnection2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createConnection(userName, password");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

