/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.util.Vector;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;

public class ExceptionDeliveryThread
implements Runnable {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/ExceptionDeliveryThread.java, jms, j600, j600-101-060328 1.6.1.1 05/05/25 16:02:20";
    private static final int waitTime = 60000;
    private Object sync = null;
    private Vector exceptions = null;
    private ExceptionListener eListener = null;
    private MQConnection connection = null;
    private boolean running = true;
    private Thread deliveryThread = null;
    private static int tId = 0;

    public ExceptionDeliveryThread(MQConnection mQConnection, ExceptionListener exceptionListener) {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        this.eListener = exceptionListener;
        this.connection = mQConnection;
        this.sync = new Object();
        this.exceptions = new Vector();
        String string = "exceptionDelivery" + tId;
        ++tId;
        this.deliveryThread = MQEnvironment.createThread(this, string, true);
        this.deliveryThread.start();
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestShutdown() {
        if (Trace.isOn) {
            Trace.entry(this, "requestShutdown");
        }
        Object object = this.sync;
        synchronized (object) {
            this.running = false;
            this.sync.notify();
        }
        if (Trace.isOn) {
            Trace.exit(this, "requestShutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliverException(JMSException jMSException) {
        if (Trace.isOn) {
            Trace.entry(this, "deliverException");
        }
        Object object = this.sync;
        synchronized (object) {
            this.exceptions.add(jMSException);
            this.sync.notify();
        }
        if (Trace.isOn) {
            Trace.exit(this, "deliverException");
        }
    }

    ExceptionListener getExceptionListener() {
        return this.eListener;
    }

    void setExceptionListener(ExceptionListener exceptionListener) {
        this.eListener = exceptionListener;
    }

    private void _deliverException(JMSException jMSException) {
        if (Trace.isOn) {
            Trace.entry(this, "_deliverException");
        }
        if (this.eListener != null) {
            try {
                if (Trace.isOn) {
                    Trace.trace(this, "Delivering Exception");
                }
                this.eListener.onException(jMSException);
                if (Trace.isOn) {
                    Trace.trace(this, "Delivered Exception to listener");
                }
            }
            catch (Throwable throwable) {
                try {
                    if (Trace.isOn) {
                        Trace.trace(this, "deliverException The following exception was thrown in deliverException: " + throwable.toString());
                    }
                    Logger.log(new LogMessage(2, "MQJMS1026", throwable.toString()));
                }
                catch (LogException logException) {
                    System.err.println("failed to log error because of " + logException);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "_deliverException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Trace.isOn) {
            Trace.entry(this, "run");
        }
        while (this.running) {
            Object object;
            try {
                object = this.sync;
                synchronized (object) {
                    this.sync.wait(60000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (this.exceptions.size() > 0) {
                object = (JMSException)((Object)this.exceptions.remove(0));
                this._deliverException((JMSException)((Object)object));
            }
            if (this.connection != null && !this.connection.isClosed()) continue;
            if (Trace.isOn) {
                Trace.trace(this, "Connection has closed, begin shutdown");
            }
            this.running = false;
        }
        if (Trace.isOn) {
            Trace.exit(this, "run");
        }
    }
}

