/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.util.Assert;
import com.ibm.disthub2.spi.AuthException;
import com.ibm.disthub2.spi.AuthResult;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.AuthBase;
import com.ibm.mq.jms.AuthPrincipal;
import com.ibm.mq.jms.DefaultPrincipal;
import com.ibm.mq.jms.ISSL;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.Properties;

public class AuthClient
extends AuthBase {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/AuthClient.java, disthub, j600, j600-101-060328 1.6.1.1 05/05/25 16:01:11";
    protected static DebugObject debug = new DebugObject("AuthClient");

    public AuthClient(Socket socket, AuthPrincipal authPrincipal, Properties properties, short[] sArray, ISSL iSSL) {
        this.sock = socket;
        this.credentials = authPrincipal;
        this.metaData = properties;
        this.cfgProtos = sArray;
        this.xssl = iSSL;
        this.role = false;
    }

    public AuthResult authenticate() throws AuthException {
        try {
            this.setupDataStreams();
            if (debug.debugIt(16)) {
                debug.debug(-153415734321212L, (Object)"runClient", (Object)"Starting client auth protocol...");
                for (int i = 0; i < this.cfgProtos.length; ++i) {
                    debug.debug(-153415734321212L, (Object)"runClient", (Object)("Client proto: " + i + " " + this.cfgProtos[i] + " (" + (char)(this.cfgProtos[i] >> 8) + ")"));
                }
            }
            new AuthBase.Hello(this.cfgProtos).writeMsg(this.ostr);
            AuthBase.MsgBase msgBase = xDummy.readMsg(this.istr);
            short s = msgBase.getType();
            if (s == 88) {
                this.termException((AuthBase.AuthExceptionMsg)msgBase);
            }
            if (debug.debugIt(16)) {
                debug.debug(-153415734321212L, (Object)"runClient", (Object)("Server requests proto (" + msgBase.getClass() + ") : " + s + " (" + (char)(s >> 8) + ")"));
            }
            short s2 = 0;
            if (this.cfgProtos != null) {
                for (int i = 0; i < this.cfgProtos.length; ++i) {
                    if (s != this.cfgProtos[i]) continue;
                    s2 = s;
                    break;
                }
            }
            this.whichProto = s2;
            if (debug.debugIt(16)) {
                debug.debug(-153415734321212L, (Object)"runClient", (Object)("Running client with protocol: " + s2 + " (" + (char)(s2 >> 8) + ")"));
            }
            AuthResult authResult = null;
            switch (s2) {
                case 99: {
                    authResult = this.clntChallengeUP(msgBase);
                    break;
                }
                case 19779: {
                    authResult = this.clntChallengeMPR(msgBase);
                    break;
                }
                case 21315: {
                    authResult = this.clntChallengeSSLUP(msgBase);
                    break;
                }
                case 21059: {
                    authResult = this.clntChallengeSSLPure(msgBase);
                    break;
                }
                case 67: {
                    authResult = this.clntChallengeUP(msgBase);
                    break;
                }
                default: {
                    this.termException(ExceptionBuilder.buildReasonString((int)813349304, (Object[])new Object[]{new Short(s2)}), 1);
                }
            }
            if (debug.debugIt(64)) {
                debug.debug(-142394261359015L, (Object)"runClient", (Object)authResult);
            }
            return authResult;
        }
        catch (AuthException authException) {
            this.termException(authException);
        }
        catch (IOException iOException) {
            throw new AuthException(2, (Exception)iOException, null);
        }
        Assert.condition((boolean)false);
        return null;
    }

    protected AuthResult clntChallengeUP(AuthBase.MsgBase msgBase) throws AuthException, IOException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"clntChallengeUP", (Object)msgBase);
        }
        String string = this.credentials.getName();
        String string2 = this.credentials.getPassword();
        String string3 = AuthClient.transformPropObj(this.metaData);
        new AuthBase.ReplyUP(string, string2, string3).writeMsg(this.ostr);
        this.close_ostr();
        AuthBase.MsgBase msgBase2 = xDummy.readMsg(this.istr);
        if (msgBase2.getType() != 111 && msgBase2.getType() != 79) {
            this.termWrongMsg(msgBase2);
        }
        AuthBase.OkayUP okayUP = (AuthBase.OkayUP)msgBase2;
        AuthResult authResult = new AuthResult();
        authResult.authPrincipal = new DefaultPrincipal(okayUP.serverId, "");
        authResult.authMetaData = AuthClient.transformPropString(okayUP.serverXid);
        authResult.sharedSecret = "NOT A GOOD SECRET!".getBytes();
        this.cleanup();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clntChallengeUP", (Object)authResult);
        }
        return authResult;
    }

    protected AuthResult clntChallengeMPR(AuthBase.MsgBase msgBase) throws AuthException, IOException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"clntChallengeMPR", (Object)msgBase);
        }
        AuthBase.ChallengeMPR challengeMPR = (AuthBase.ChallengeMPR)msgBase;
        String string = challengeMPR.serverId;
        String string2 = challengeMPR.serverXid;
        byte[] byArray = AuthClient.random(20);
        String string3 = this.credentials.getName();
        String string4 = this.credentials.getPassword();
        String string5 = AuthClient.transformPropObj(this.metaData);
        this.mutualPasswordMacs(string4, string, string2, challengeMPR.Rs, string3, string5, byArray);
        new AuthBase.ResponseAndCounter(string3, string5, byArray, this.macClnt).writeMsg(this.ostr);
        this.close_ostr();
        AuthBase.MsgBase msgBase2 = xDummy.readMsg(this.istr);
        if (msgBase2.getType() != 19791) {
            this.termWrongMsg(msgBase2);
        }
        AuthBase.OkayResponse okayResponse = (AuthBase.OkayResponse)msgBase2;
        if (!Arrays.equals(okayResponse.MacS, this.macServ)) {
            this.termException(ExceptionBuilder.buildReasonString((int)1231952836, null), 3);
        }
        AuthResult authResult = new AuthResult();
        authResult.authPrincipal = new DefaultPrincipal(string, "");
        authResult.authMetaData = AuthClient.transformPropString(string2);
        authResult.sharedSecret = this.sessionSecret;
        Assert.condition((this.sessionSecret != null ? 1 : 0) != 0);
        this.cleanup();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clntChallengeMPR", (Object)authResult);
        }
        return authResult;
    }

    protected AuthResult clntChallengeSSLUP(AuthBase.MsgBase msgBase) throws AuthException, IOException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"clntChallengeSSLUP", (Object)msgBase);
        }
        AuthBase.ChallengeSSLUP challengeSSLUP = (AuthBase.ChallengeSSLUP)msgBase;
        this.sslStart(false, (short)21315);
        byte[] byArray = AuthClient.random(20);
        String string = this.credentials.getName();
        String string2 = this.credentials.getPassword();
        String string3 = AuthClient.transformPropObj(this.metaData);
        new AuthBase.ReplySSLUP(string, string2, string3, byArray).writeMsg(this.ostr);
        this.close_ostr();
        AuthBase.MsgBase msgBase2 = xDummy.readMsg(this.istr);
        if (msgBase2.getType() != 21327) {
            this.termWrongMsg(msgBase2);
        }
        AuthBase.OkaySSLUP okaySSLUP = (AuthBase.OkaySSLUP)msgBase2;
        String string4 = this.sslSession.extractUserID();
        if (string4 == null) {
            string4 = okaySSLUP.serverId;
        }
        this.sslDeriveSessionKey(this.sslSession, okaySSLUP.Rs, byArray);
        AuthResult authResult = new AuthResult();
        authResult.authPrincipal = new DefaultPrincipal(string4, "");
        authResult.authMetaData = AuthClient.transformPropString(okaySSLUP.serverXid);
        authResult.sharedSecret = this.sessionSecret;
        Assert.condition((authResult.sharedSecret != null ? 1 : 0) != 0);
        this.cleanup();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clntChallengeSSLUP", (Object)authResult);
        }
        return authResult;
    }

    protected AuthResult clntChallengeSSLPure(AuthBase.MsgBase msgBase) throws AuthException, IOException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"clntChallengeSSLPure", (Object)msgBase);
        }
        AuthBase.ChallengeSSLPure challengeSSLPure = (AuthBase.ChallengeSSLPure)msgBase;
        this.sslStart(false, (short)21059);
        byte[] byArray = AuthClient.random(20);
        String string = this.credentials.getName();
        String string2 = this.credentials.getPassword();
        String string3 = AuthClient.transformPropObj(this.metaData);
        new AuthBase.ReplySSLPure(string, "", string3, byArray).writeMsg(this.ostr);
        this.close_ostr();
        AuthBase.MsgBase msgBase2 = xDummy.readMsg(this.istr);
        if (msgBase2.getType() != 21071) {
            this.termWrongMsg(msgBase2);
        }
        AuthBase.OkaySSLPure okaySSLPure = (AuthBase.OkaySSLPure)msgBase2;
        String string4 = this.sslSession.extractUserID();
        if (string4 == null) {
            string4 = okaySSLPure.serverId;
        }
        this.sslDeriveSessionKey(this.sslSession, okaySSLPure.Rs, byArray);
        AuthResult authResult = new AuthResult();
        authResult.authPrincipal = new DefaultPrincipal(string4, "");
        authResult.authMetaData = AuthClient.transformPropString(okaySSLPure.serverXid);
        authResult.sharedSecret = this.sessionSecret;
        Assert.condition((authResult.sharedSecret != null ? 1 : 0) != 0);
        this.cleanup();
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"clntChallengeSSLPure", (Object)authResult);
        }
        return authResult;
    }
}

