# xUML Library devkit

Module with help functionalities for developing and handling xUML libraries

## Command line

### Create a workspace with a library
`xlib new <workspace-and-library-name>`

### Create a form
Go to ./projects/<library-name> directory and run
`xlib generate form <form-name>`
A new form component is crated under ./src/lib/<form-name>

### Storybook for development
`npm run ng -- run test-libs:storybook`

Define [stories](https://storybook.js.org/docs/writing-stories/typescript) in the *.stories.ts files

### Creating Components, Managing and Defining Forms and Interfaces
**Component Creation**
In Angular, components bundle UI templates, logic, and styles into independent, reusable elements. To create a form component, define a TypeScript class for behavior, an HTML template for structure, and optional CSS/SCSS for styles.

**public-api.ts**
The file centralizes all the exports of your library. By exporting your components and interfaces here, you make them available for use in other projects that consume your library.

**Specifying Forms and Interfaces**
For each form create:
- A component that implements the form’s logic and layout.
- A corresponding TypeScript interface describing the data structure of the form, ensuring type safety and consistency.
- **`@PasForm`** is a **custom decorator** and adds extra metadata to the class, used for specific form integration and handling and the `build`.
  - It defines:
    - `name`: An identifier for the form component.
    - `events`: Which form events are supported.
- Inherits from **`AbstractFormComponent`** to provide **core form logic**, which is important for the integration into the **PAS Designer** app projects

### Build the library
This command is used to create the `xlib` folder and to build your xUML library project. It automates the compilation and packaging process, transforming your TypeScript source code and other assets into optimized, ready-to-use library files.
`xlib build`

**What is created in the `xlib` folder?**
- **`forms`** (subdirectory): Contains JSON files that represent each form defined in your library.
- **`library.descriptor.json`**: Contains details describing the overall library structure and metadata.
- **`[library-name].library.idl.json`**: Contains interface description data for the library.
- **`[library-name].library.xlib`**: The compiled library archive or bundle, ready to be used.
