/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.usermanager;

import javax.sql.DataSource;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.usermanager.Md5PasswordEncryptor;
import org.apache.ftpserver.usermanager.PasswordEncryptor;
import org.apache.ftpserver.usermanager.UserManagerFactory;
import org.apache.ftpserver.usermanager.impl.DbUserManager;

public class DbUserManagerFactory
implements UserManagerFactory {
    private String adminName = "admin";
    private String insertUserStmt;
    private String updateUserStmt;
    private String deleteUserStmt;
    private String selectUserStmt;
    private String selectAllStmt;
    private String isAdminStmt;
    private String authenticateStmt;
    private DataSource dataSource;
    private PasswordEncryptor passwordEncryptor = new Md5PasswordEncryptor();

    public UserManager createUserManager() {
        if (this.dataSource == null) {
            throw new FtpServerConfigurationException("Required data source not provided");
        }
        if (this.insertUserStmt == null) {
            throw new FtpServerConfigurationException("Required insert user SQL statement not provided");
        }
        if (this.updateUserStmt == null) {
            throw new FtpServerConfigurationException("Required update user SQL statement not provided");
        }
        if (this.deleteUserStmt == null) {
            throw new FtpServerConfigurationException("Required delete user SQL statement not provided");
        }
        if (this.selectUserStmt == null) {
            throw new FtpServerConfigurationException("Required select user SQL statement not provided");
        }
        if (this.selectAllStmt == null) {
            throw new FtpServerConfigurationException("Required select all users SQL statement not provided");
        }
        if (this.isAdminStmt == null) {
            throw new FtpServerConfigurationException("Required is admin user SQL statement not provided");
        }
        if (this.authenticateStmt == null) {
            throw new FtpServerConfigurationException("Required authenticate user SQL statement not provided");
        }
        return new DbUserManager(this.dataSource, this.selectAllStmt, this.selectUserStmt, this.insertUserStmt, this.updateUserStmt, this.deleteUserStmt, this.authenticateStmt, this.isAdminStmt, this.passwordEncryptor, this.adminName);
    }

    public String getAdminName() {
        return this.adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getSqlUserInsert() {
        return this.insertUserStmt;
    }

    public void setSqlUserInsert(String sql) {
        this.insertUserStmt = sql;
    }

    public String getSqlUserDelete() {
        return this.deleteUserStmt;
    }

    public void setSqlUserDelete(String sql) {
        this.deleteUserStmt = sql;
    }

    public String getSqlUserUpdate() {
        return this.updateUserStmt;
    }

    public void setSqlUserUpdate(String sql) {
        this.updateUserStmt = sql;
    }

    public String getSqlUserSelect() {
        return this.selectUserStmt;
    }

    public void setSqlUserSelect(String sql) {
        this.selectUserStmt = sql;
    }

    public String getSqlUserSelectAll() {
        return this.selectAllStmt;
    }

    public void setSqlUserSelectAll(String sql) {
        this.selectAllStmt = sql;
    }

    public String getSqlUserAuthenticate() {
        return this.authenticateStmt;
    }

    public void setSqlUserAuthenticate(String sql) {
        this.authenticateStmt = sql;
    }

    public String getSqlUserAdmin() {
        return this.isAdminStmt;
    }

    public void setSqlUserAdmin(String sql) {
        this.isAdminStmt = sql;
    }

    public PasswordEncryptor getPasswordEncryptor() {
        return this.passwordEncryptor;
    }

    public void setPasswordEncryptor(PasswordEncryptor passwordEncryptor) {
        this.passwordEncryptor = passwordEncryptor;
    }
}

