/*
 * Copyright: Scheer E2E AG
 */

package ch.e2e.examples.exception;

import ch.e2e.bridge.server.BridgeException;

@SuppressWarnings("unused")
public class ThrowException {

    /**
     * Throws an exception.
     *
     * @param message the description of the error
     * @param code the code of the error
     * @param domain the domain of the error
     */
     public static void throwException(String message, String code, String domain) {
        throw new BridgeException(message, code, domain);
    }

    /**
     * Throws an exception wrapping the causing throwable.
     *
     * @param message the description of the cause
     * @param code the code of the error
     * @param domain the domain of the error
     */
    public static void throwExceptionWithCause(String message, String code, String domain) {
        throw new BridgeException(new IllegalStateException(message), code, domain);
    }

    private ThrowException() {
    }

}
