/*
 * e2e technologies Ltd.
 * Project: java AddOn examples
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * $Id: ProductList.java,v 1.4 2010/12/20 09:40:38 pmuessig Exp $
 */
package ch.e2e.examples.list;

import java.util.ArrayList;
import java.util.List;

/**
 * The class to handle with the existing products.<br><br>
 * <B>This class can be used to import.</B><br><br>
 * You can use the methods:<br>
 * <ul>
 * <code><li><a href="#getAllProductIds()">public ArrayList getAllProductIds()</a></li></code>
 * <code><li><a href="#getProducts(java.util.ArrayList)">public ArrayList getProducts(ArrayList productIds)</a></li></code>
 * </ul>
 * Copyright &#169; 2001-2005 E2E technologies Ltd. All rights reserved.
 * @author tzimber
 * @version $Revision: 1.4 $
 */
public class ProductList {
	/**
	 * Returns the products, found for the list of product ids.
	 * @param productIds The list of product ids.
	 * All elements in this list must be of type java.lang.String.
	 * @return The list with the products, found for these ids. All elements
	 * in this list are of type <code>ch.e2e.examples.list.Product</code>.
	 */
	public static List<Product> getProducts(List<String> productIds) {
		ArrayList<Product> products = new ArrayList<Product>();
        ProductDB productDB = ProductDB.getInstance();
 		for (String id : productIds) {
            products.add(productDB.findProduct(id));
		}
		return products;
	}

	/**
	 * Returns all existing product ids.
	 * @return The list of all product ids. All elements
	 * in this list are of type <code>java.lang.String</code>.
	 */
	public static List<String> getAllProductIds() {
		return ProductDB.getInstance().getAllProductIds();
	}
}
