/*
 * e2e technologies Ltd.
 * Project: java AddOn examples
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * $Id: CustomerDB.java,v 1.2 2010/11/19 11:06:51 pmuessig Exp $
 */
package ch.e2e.examples.list;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.util.HashMap;

/**
 * Holds the list of all customers.<br><br>
 * Copyright &#169; 2001-2005 E2E technologies Ltd. All rights reserved.
 * @author tzimber
 * @version $Revision: 1.2 $
 */
public class CustomerDB {
	/**
	 * The one and only instance of this class.
	 */
	private static CustomerDB db = new CustomerDB();
	/**
	 * The map of customers, using the customer id as key.
	 */
	private HashMap<String, Customer> customers = new HashMap<String, Customer>();

	/**
	 * Reads the customer informations from the file <code>ch/e2e/examples/list/customer.xml</code>
	 */
	private CustomerDB() {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			factory.setValidating(false);
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document document = builder.parse(getClass().getClassLoader().getResourceAsStream("ch/e2e/examples/list/customer.xml"));
			NodeList customerList = document.getDocumentElement().getElementsByTagName("customer");
			int length = customerList.getLength();
			for (int i = 0; i < length; i++) {
				Element customerNode = (Element)customerList.item(i);
				addCustomer(customerNode);
			}
		} catch (Exception e) {
			// ignore
		}
	}

	/**
	 * Adds a customer, defined by its xml element.
	 * @param customerNode The xml element defining the customer.
	 */
	private void addCustomer(Element customerNode) {
		Customer customer = new Customer();
		NodeList idList = customerNode.getElementsByTagName("id");
		String id = idList.item(0).getFirstChild().getNodeValue();
		customer.setId(id);
		NodeList nameList = customerNode.getElementsByTagName("name");
		String name = nameList.item(0).getFirstChild().getNodeValue();
		customer.setName(name);
		NodeList streetList = customerNode.getElementsByTagName("street");
		String street = streetList.item(0).getFirstChild().getNodeValue();
		customer.setStreet(street);
		NodeList postalCodeList = customerNode.getElementsByTagName("postalcode");
		String postalCode = postalCodeList.item(0).getFirstChild().getNodeValue();
		customer.setPostalCode(postalCode);
		NodeList townList = customerNode.getElementsByTagName("town");
		String town = townList.item(0).getFirstChild().getNodeValue();
		customer.setTown(town);
		customers.put(id, customer);
	}

	/**
	 * Returns the instance of this class.
	 * @return The instance of this class.
	 */
	public static CustomerDB getInstance() {
		return db;
	}

	/**
	 * Returns the customer for a given customer id.
	 * @param customerID
	 * @return The customer for a given customer id, or <code>null</code> if
	 * no such customer exsits.
	 */
	public synchronized Customer findCustomer(String customerID) {
		return customers.get(customerID);
	}
}
