/*
 * e2e technologies Ltd.
 * Project: java AddOn examples
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * $Id: Customer.java,v 1.1 2008/11/15 22:09:47 tzimber Exp $
 */
package ch.e2e.examples.list;

/**
 * Contains all informations about a customer.<br><br>
 * Copyright &#169; 2001-2005 E2E technologies Ltd. All rights reserved.
 * @author tzimber
 * @version $Revision: 1.1 $
 */
public class Customer {
	/**
	 * The name of the customer.
	 */
	private String name;
	/**
	 * The id of the customer.
	 */
	private String id;
	/**
	 * The town the customer lives.
	 */
	private String town;
	/**
	 * The postalcode of the town the customer lives.
	 */
	private String postalCode;
	/**
	 * The street the customer lives.
	 */
	private String street;

	/**
	 * Returns the id of the customer.
	 * @return The id of the customer.
	 */
	public String getId() {
		return id;
	}

	/**
	 * Sets the id of the customer.
	 * @param id The id of the customer.
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * Returns the name of the customer.
	 * @return The name of the customer.
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets the name of the customer.
	 * @param name The name of the customer.
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Returns the postalcode of the town the customer lives.
	 * @return The postalcode of the town the customer lives.
	 */
	public String getPostalCode() {
		return postalCode;
	}

	/**
	 * Sets the postalcode of the town the customer lives.
	 * @param postalCode The postalcode of the town the customer lives.
	 */
	public void setPostalCode(String postalCode) {
		this.postalCode = postalCode;
	}

	/**
	 * Returns the street the customer lives.
	 * @return The street the customer lives.
	 */
	public String getStreet() {
		return street;
	}

	/**
	 * Sets the street the customer lives.
	 * @param street The street of the customer lives.
	 */
	public void setStreet(String street) {
		this.street = street;
	}

	/**
	 * Returns the town the customer lives.
	 * @return The town the customer lives.
	 */
	public String getTown() {
		return town;
	}

	/**
	 * Sets the town the customer lives.
	 * @param town The town the customer lives.
	 */
	public void setTown(String town) {
		this.town = town;
	}
}
