/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.services.psk;

import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import com.ibm.mq.jms.services.psk.MessageCatalogue;
import com.ibm.mq.jms.services.psk.PSK;
import com.ibm.mq.jms.services.psk.Trace;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.MissingResourceException;
import java.util.TimeZone;

public abstract class LogServiceProvider {
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/services/psk/LogServiceProvider.java, jms, j600, j600-101-060328 1.5.1.1 05/05/25 15:13:05";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int BinaryOutput = 0;
    public static final int FormattedOutput = 1;
    String m_serviceName = "logger";
    int m_format = 0;
    MessageCatalogue[] m_msgCats = null;
    private SimpleDateFormat m_dateFormatter;
    private static String helpSuffix = "_help";

    public LogServiceProvider(String string) throws LogException {
        Trace.entry(this, "LogServiceProvider");
        Trace.trace(2, this, sccsid);
        this.m_serviceName = string;
        this.m_dateFormatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        TimeZone timeZone = TimeZone.getDefault();
        ((Calendar)gregorianCalendar).setTimeZone(timeZone);
        this.m_dateFormatter.setCalendar(gregorianCalendar);
        Trace.exit(this, "LogServiceProvider");
    }

    public abstract void closeLog() throws LogException;

    protected String formatHelpMsg(LogMessage logMessage) {
        Trace.entry(this, "formatHelpMsg");
        String string = null;
        String string2 = logMessage.getKey() + "_help";
        Object[] objectArray = logMessage.getInserts();
        String string3 = null;
        if (this.m_msgCats != null) {
            for (int i = 0; i < this.m_msgCats.length; ++i) {
                try {
                    String string4 = objectArray == null ? this.m_msgCats[i].getMessage(string2) : this.m_msgCats[i].getMessage(string2, objectArray);
                    string3 = string4;
                    break;
                }
                catch (MissingResourceException missingResourceException) {
                    continue;
                }
            }
        }
        if (string3 != null) {
            string = string3;
        }
        Trace.exit(this, "formatHelpMsg");
        return string;
    }

    protected String formatMsg(LogMessage logMessage) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_dateFormatter.format(logMessage.getDate()));
        stringBuffer.append(" ");
        String string = logMessage.getKey();
        stringBuffer.append(string);
        switch (logMessage.getLevel()) {
            case 0: {
                stringBuffer.append("I ");
                break;
            }
            case 1: {
                stringBuffer.append("W ");
                break;
            }
            case 2: {
                stringBuffer.append("E ");
            }
        }
        Object[] objectArray = logMessage.getInserts();
        String string2 = null;
        if (this.m_msgCats != null) {
            for (int i = 0; i < this.m_msgCats.length; ++i) {
                try {
                    String string3 = objectArray == null ? this.m_msgCats[i].getMessage(string) : this.m_msgCats[i].getMessage(string, objectArray);
                    string2 = string3;
                    break;
                }
                catch (MissingResourceException missingResourceException) {
                    continue;
                }
            }
        }
        if (string2 == null) {
            try {
                MessageCatalogue messageCatalogue = PSK.getPSKCatalogue();
                string2 = messageCatalogue.getMessage("msgNotFound", string);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = "Message: " + string + " not found in catalogue.";
            }
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    protected int getFormatStyle() {
        return this.m_format;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public abstract void log(LogMessage var1) throws LogException;

    public abstract void logExplanation(LogMessage var1) throws LogException;

    public void setLogCatalogueSearchOrder(MessageCatalogue[] messageCatalogueArray) {
        this.m_msgCats = messageCatalogueArray;
    }

    public void setOutputFormat(int n) {
        this.m_format = n;
    }
}

