/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSNullMessage;
import com.ibm.jms.JMSStringResources;
import com.ibm.mq.MQC;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.BrokerCommandFailedException;
import com.ibm.mq.jms.BrokerConnectionInfo;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQJMSStringResources;
import com.ibm.mq.jms.MQQueueSubscription;
import com.ibm.mq.jms.MQSubAdmin;
import com.ibm.mq.jms.MQSubEntry;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.NoBrokerResponseException;
import com.ibm.mq.jms.PCF;
import com.ibm.mq.jms.RFH;
import com.ibm.mq.jms.RFH1BrokerMessageImpl;
import com.ibm.mq.jms.RFH2;
import com.ibm.mq.jms.RFH2BrokerMessageImpl;
import com.ibm.mq.jms.SubscriptionInfo;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;

public class SubscriptionHelper {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/SubscriptionHelper.java, jms, j600, j600-101-060328 1.44.1.1 05/05/25 16:01:16";
    static final int NON_DURABLE = 0;
    static final int DURABLE = 1;
    static final int REGISTER_SUBSCRIBER = 0;
    static final int DEREGISTER_SUBSCRIBER = 1;
    static final int REGISTER_SHAREDQ_SUBSCRIBER = 2;
    static final int DEREGISTER_SHAREDQ_SUBSCRIBER = 3;
    private static final String[] CMD_PREFIX = new String[]{"MQPSCommand RegSub MQPSTopic ", "MQPSCommand DeregSub MQPSTopic ", "MQPSCommand RegSub MQPSRegOpts CorrelAsId MQPSTopic ", "MQPSCommand DeregSub MQPSRegOpts CorrelAsId MQPSTopic "};
    private static final String MQPS_STREAM_NAME_B = " MQPSStreamName ";
    private static final String MQPS_Q_NAME_B = " MQPSQName ";
    private static final String CLASSNAME = "com.ibm.mq.jms.SubscriptionHelper";
    private static final int BROKER_TIMEOUT = 120000;
    private static JMSStringResources jmsStrings = new MQJMSStringResources();

    /*
     * Loose catch block
     */
    public static Vector getBrokerSubs(String string, Session session) throws Exception {
        Vector vector;
        MessageConsumer messageConsumer;
        Exception exception;
        block13: {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "getBrokerSubs");
            }
            Vector vector2 = new Vector();
            String string2 = Utils.padString(string, 48);
            String string3 = "MQ/S/" + string2 + "/Subscribers/Identities";
            MQTopic mQTopic = new MQTopic();
            mQTopic.setBaseTopicName("\"" + string3 + "/*\"");
            exception = null;
            messageConsumer = null;
            messageConsumer = session.createConsumer((Destination)mQTopic);
            BytesMessage bytesMessage = null;
            do {
                if ((bytesMessage = (BytesMessage)messageConsumer.receiveNoWait()) == null) continue;
                SubscriptionHelper.interpretMetaMessage(bytesMessage, vector2, string3);
            } while (bytesMessage != null);
            vector = vector2;
            Object var11_11 = null;
            try {
                if (messageConsumer != null) {
                    messageConsumer.close();
                }
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) break block13;
                Trace.trace(CLASSNAME, "getBrokerSubs was unable to close our meta-topic subscriber due to: " + (Object)((Object)jMSException));
                if (exception != null) break block13;
                throw jMSException;
            }
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "getBrokerSubs");
        }
        return vector;
        catch (Exception exception2) {
            try {
                exception = exception2;
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Subscription or message receipt failed due to: " + exception2);
                }
                throw exception2;
            }
            catch (Throwable throwable) {
                block15: {
                    block14: {
                        Object var11_12 = null;
                        try {
                            if (messageConsumer != null) {
                                messageConsumer.close();
                            }
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) break block14;
                            Trace.trace(CLASSNAME, "getBrokerSubs was unable to close our meta-topic subscriber due to: " + (Object)((Object)jMSException));
                            if (exception != null) break block14;
                            throw jMSException;
                        }
                    }
                    if (!Trace.isOn) break block15;
                    Trace.exit(CLASSNAME, "getBrokerSubs");
                }
                throw throwable;
            }
        }
    }

    public static Vector getMatchingSubs(Vector vector, SubscriptionInfo subscriptionInfo) {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "getMatchingSubs");
            Trace.trace(CLASSNAME, "objs has " + vector.size() + " elements");
            Trace.trace(CLASSNAME, "match is:\n" + subscriptionInfo);
        }
        Vector<SubscriptionInfo> vector2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            SubscriptionInfo subscriptionInfo2 = (SubscriptionInfo)vector.elementAt(i);
            if (!subscriptionInfo2.wildcardMatch(subscriptionInfo)) continue;
            if (vector2 == null) {
                vector2 = new Vector<SubscriptionInfo>();
            }
            vector2.addElement(subscriptionInfo2);
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "getMatchingSubs");
        }
        return vector2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String validateQueueName(String string, int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "validateQueueName");
            }
            String string2 = null;
            if (string.trim().equals("")) {
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "queueName is blank; reverting to MQJMSv1 approach");
                }
                string2 = n == 0 ? "SYSTEM.JMS.ND.*" : "SYSTEM.JMS.D.*";
            } else {
                if (n == 0 && !string.startsWith("SYSTEM.JMS.ND.") || n == 1 && !string.startsWith("SYSTEM.JMS.D.")) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3021", string);
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
                    }
                    throw jMSException;
                }
                string2 = string;
            }
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "validateQueueName returning '" + string2 + "'");
            }
            String string3 = string2;
            return string3;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "validateQueueName");
            }
        }
    }

    static String createSubscriberQueue(MQQueueManager mQQueueManager, String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "createSubscriberQueue");
            }
            String string2 = null;
            if (!string.endsWith("*")) {
                throw ConfigEnvironment.newException("MQJMS3021", string);
            }
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Creating a new PERMDYN queue");
                Trace.trace(CLASSNAME, "Model:  SYSTEM.JMS.MODEL.QUEUE");
                Trace.trace(CLASSNAME, "Prefix: " + string);
            }
            MQQueue mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.MODEL.QUEUE", 8225, null, string, null);
            string2 = mQQueue.name;
            mQQueue.close();
            String string3 = string2;
            return string3;
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS2008", "Queue prefix: " + string);
            jMSException.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
            }
            Trace.trace(CLASSNAME, "Linked Exception " + mQException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "createSubscriberQueue");
            }
        }
    }

    static MQQueue getSubscriberQueue(MQQueueManager mQQueueManager, String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "getSubscriberQueue");
            }
            MQQueue mQQueue = null;
            if (string.endsWith("*")) {
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Using multi-queue approach");
                    Trace.trace(CLASSNAME, "Model:  SYSTEM.JMS.MODEL.QUEUE");
                    Trace.trace(CLASSNAME, "Prefix: " + string);
                }
                mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.MODEL.QUEUE", 8225, null, string, null);
            } else {
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Using shared-queue approach");
                }
                mQQueue = mQQueueManager.accessQueue(string, 8225);
            }
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "QName:  " + mQQueue.name);
            }
            MQQueue mQQueue2 = mQQueue;
            return mQQueue2;
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS2008", string);
            jMSException.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
            }
            Trace.trace(CLASSNAME, "Linked Exception " + mQException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "getSubscriberQueue");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static void sendBrokerCommand(MQQueueManager var0, BrokerConnectionInfo var1_1, int var2_2, int var3_3, String var4_4, String var5_5, byte[] var6_6, boolean var7_7, String var8_8) throws JMSException {
        block35: {
            try {
                block36: {
                    block34: {
                        if (Trace.isOn) {
                            Trace.entry("com.ibm.mq.jms.SubscriptionHelper", "sendBrokerCommand");
                        }
                        var9_9 = null;
                        switch (var2_2) {
                            case 0: {
                                var9_9 = new RFH1BrokerMessageImpl();
                                break;
                            }
                            case 1: {
                                var9_9 = new RFH2BrokerMessageImpl();
                                break;
                            }
                            default: {
                                var10_10 = ConfigEnvironment.newException("MQJMS1016");
                                throw var10_10;
                            }
                        }
                        switch (var3_3) {
                            case 0: {
                                var9_9.set("MQPSCommand", "RegSub");
                                break;
                            }
                            case 1: {
                                var9_9.set("MQPSCommand", "DeregSub");
                                break;
                            }
                            case 2: {
                                var9_9.set("MQPSCommand", "RegSub");
                                var9_9.setOption("MQPSRegOpts", 1);
                                break;
                            }
                            case 3: {
                                var9_9.set("MQPSCommand", "DeregSub");
                                var9_9.setOption("MQPSRegOpts", 1);
                                break;
                            }
                            default: {
                                var10_11 = ConfigEnvironment.newException("MQJMS1016");
                                throw var10_11;
                            }
                        }
                        var9_9.set("MQPSTopic", var4_4);
                        var9_9.set("MQPSStreamName", var1_1.streamQ);
                        var9_9.set("MQPSQName", var5_5);
                        var10_12 = new MQMsg2();
                        try {
                            var11_13 = 8208;
                            var12_16 = new MQPutMessageOptions();
                            var12_16.options = 8196;
                            if (var8_8 != null) {
                                var10_12.setUserId(var8_8);
                                var11_13 |= 1024;
                                var12_16.options |= 1024;
                            }
                            var10_12.setFormat(var9_9.getHeaderFormat());
                            var9_9.writeToMessage(var10_12);
                            var10_12.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                            if (var7_7) {
                                var10_12.setReport(3);
                            }
                            if (var6_6 != null) {
                                var10_12.setCorrelationId(var6_6);
                            }
                            var0.putMsg2(var1_1.controlQ, var1_1.qmName, var10_12, (MQPutMessageOptions)var12_16);
                        }
                        catch (MQException var11_14) {
                            if (var11_14.completionCode == 1 && var11_14.reasonCode == 2104) break block34;
                            var12_17 = ConfigEnvironment.newException("MQJMS2007");
                            var12_17.setLinkedException((Exception)var11_14);
                            if (Trace.isOn) {
                                Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "Create and Throwing " + (Object)var12_17);
                            }
                            if (Trace.isOn) {
                                Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "Linked Exception " + var11_14);
                            }
                            throw var12_17;
                        }
                    }
                    if (!var7_7) break block35;
                    var11_15 = new MQMsg2();
                    var12_16 = null;
                    try {
                        var12_16 = var0.accessQueue("SYSTEM.JMS.REPORT.QUEUE", 8193);
                        var11_15.setCorrelationId(var10_12.getMessageId());
                        var13_18 = new MQGetMessageOptions();
                        var13_18.options = 1;
                        var13_18.waitInterval = 120000;
                        var12_16.getMsg2(var11_15, var13_18);
                        var16_20 = null;
                        ** if (var12_16 == null) goto lbl-1000
                    }
                    catch (Throwable var15_25) {
                        block37: {
                            var16_21 = null;
                            if (var12_16 != null) {
                                try {
                                    var12_16.close();
                                }
                                catch (MQException var17_23) {
                                    if (!Trace.isOn) break block37;
                                    Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "sendBrokerCommand failed to close replyQ due to: " + var17_23);
                                }
                            }
                        }
                        throw var15_25;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var12_16.close();
                        }
                        catch (MQException var17_22) {
                            if (Trace.isOn) {
                                Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "sendBrokerCommand failed to close replyQ due to: " + var17_22);
                            }
                        }
                    }
lbl-1000:
                    // 4 sources

                    {
                        break block36;
                        catch (MQException var13_19) {
                            var14_24 = new NoBrokerResponseException("Unable to retreive report message");
                            var14_24.setLinkedException(var13_19);
                            if (Trace.isOn) {
                                Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "Create and Throwing " + (Object)var14_24);
                            }
                            if (Trace.isOn) {
                                Trace.trace("com.ibm.mq.jms.SubscriptionHelper", "Linked Exception " + var13_19);
                            }
                            throw var14_24;
                        }
                    }
                }
                SubscriptionHelper.checkResponse(var11_15);
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit("com.ibm.mq.jms.SubscriptionHelper", "sendBrokerCommand");
                }
            }
        }
    }

    static void sendBrokerCommand(MQQueueManager mQQueueManager, BrokerConnectionInfo brokerConnectionInfo, int n, int n2, String string, String string2, byte[] byArray, boolean bl) throws JMSException {
        SubscriptionHelper.sendBrokerCommand(mQQueueManager, brokerConnectionInfo, n, n2, string, string2, byArray, bl, null);
    }

    static void deleteSubscriber(MQQueueSubscription mQQueueSubscription) throws JMSException {
        String string = mQQueueSubscription.isDurable() ? mQQueueSubscription.getClientId() + ":" + mQQueueSubscription.getSubName() : "";
        MQSubEntry mQSubEntry = new MQSubEntry(string, mQQueueSubscription.getTopic(), mQQueueSubscription.getQueueName(), mQQueueSubscription.getSelector(), mQQueueSubscription.getNoLocal(), mQQueueSubscription.getStatusMgrId(), mQQueueSubscription.isSharedQueue());
        MQQueueManager mQQueueManager = mQQueueSubscription.getMQSession().qm;
        BrokerConnectionInfo brokerConnectionInfo = mQQueueSubscription.getMQSession().getBrk();
        MQQueue mQQueue = mQQueueSubscription.getSubscriberQueue();
        mQSubEntry.setSubscriberId(mQQueueSubscription.getCorrelationId());
        SubscriptionHelper.deleteSubscriber(mQQueueManager, brokerConnectionInfo, mQSubEntry, mQQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteSubscriber(MQQueueManager mQQueueManager, BrokerConnectionInfo brokerConnectionInfo, MQSubEntry mQSubEntry) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "deleteSubscriber(qm,e)");
            }
            MQQueue mQQueue = SubscriptionHelper.accessQueue(mQQueueManager, mQSubEntry);
            SubscriptionHelper.deleteSubscriber(mQQueueManager, brokerConnectionInfo, mQSubEntry, mQQueue);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "deleteSubscriber(qm,e)");
            }
        }
    }

    static void deleteSubscriber(MQQueueManager mQQueueManager, BrokerConnectionInfo brokerConnectionInfo, MQSubEntry mQSubEntry, MQQueue mQQueue) throws JMSException {
        JMSException jMSException = null;
        try {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "deleteSubscriber(qm,bci,e,q)");
                Trace.trace(CLASSNAME, "Deregistering on '" + mQSubEntry.getQName() + "'");
            }
            int n = mQSubEntry.getSharedQueue() ? 3 : 1;
            int n2 = 0;
            String string = null;
            boolean bl = true;
            block13: while (bl) {
                try {
                    SubscriptionHelper.sendBrokerCommand(mQQueueManager, brokerConnectionInfo, n2, n, mQSubEntry.getTopic(), mQSubEntry.getQName(), mQSubEntry.getSubscriberId(), true, string);
                    bl = false;
                }
                catch (BrokerCommandFailedException brokerCommandFailedException) {
                    int n3 = brokerCommandFailedException.getReason();
                    switch (n3) {
                        case 3073: {
                            if (n2 == 0) {
                                if (Trace.isOn) {
                                    Trace.trace(CLASSNAME, "Failed using RFH1 retrying dereg with an RFH2 \n" + (Object)((Object)brokerCommandFailedException));
                                }
                                n2 = 1;
                                bl = true;
                                continue block13;
                            }
                            jMSException = brokerCommandFailedException;
                            bl = false;
                            if (!Trace.isOn) continue block13;
                            Trace.trace(CLASSNAME, "Failed to deregister due to " + (Object)((Object)brokerCommandFailedException));
                            continue block13;
                        }
                        case 3078: {
                            if (string == null) {
                                if (Trace.isOn) {
                                    Trace.trace(CLASSNAME, "retrying deregister with set_id_ctxt");
                                }
                                string = brokerCommandFailedException.getUserId();
                                bl = true;
                                continue block13;
                            }
                            if (Trace.isOn) {
                                Trace.trace(CLASSNAME, "Failed to deregister due to " + (Object)((Object)brokerCommandFailedException));
                            }
                            jMSException = brokerCommandFailedException;
                            bl = false;
                            continue block13;
                        }
                        case 3072: {
                            if (n2 == 0 && (mQSubEntry.getTopic().indexOf(43) != -1 || mQSubEntry.getTopic().indexOf(35) != -1 || mQSubEntry.getTopic().indexOf(42) != -1 || mQSubEntry.getTopic().indexOf(63) != -1)) {
                                if (Trace.isOn) {
                                    Trace.trace(CLASSNAME, "Retrying with RFH2 deregsiter");
                                }
                                n2 = 1;
                                bl = true;
                                continue block13;
                            }
                            if (Trace.isOn) {
                                Trace.trace(CLASSNAME, "Failed to deregister due to " + (Object)((Object)brokerCommandFailedException));
                            }
                            jMSException = brokerCommandFailedException;
                            bl = false;
                            continue block13;
                        }
                    }
                    jMSException = brokerCommandFailedException;
                    bl = false;
                    if (!Trace.isOn) continue;
                    Trace.trace(CLASSNAME, "Failed to deregister due to " + (Object)((Object)brokerCommandFailedException));
                }
                catch (JMSException jMSException2) {
                    jMSException = jMSException2;
                    bl = false;
                    if (!Trace.isOn) continue;
                    Trace.trace(CLASSNAME, "Failed to deregister due to " + (Object)((Object)jMSException2));
                }
            }
            SubscriptionHelper.deleteSubscriberMessages(mQSubEntry, mQQueue);
            if (jMSException != null) {
                throw jMSException;
            }
        }
        catch (JMSException jMSException3) {
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Throwing from deleteSubscriber: " + (Object)((Object)jMSException3));
                Exception exception = jMSException3.getLinkedException();
                if (exception != null) {
                    Trace.trace(CLASSNAME, "Linked exception: " + exception);
                }
            }
            if (jMSException != null && jMSException3 != jMSException) {
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "NOTE! Throwing pending deregException instead!");
                }
                throw jMSException;
            }
            throw jMSException3;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "deleteSubscriber(qm,bci,e,q)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteSubscriberMessages(MQQueueManager mQQueueManager, MQSubEntry mQSubEntry) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "deleteSubscriberMessages(qm,e)");
            }
            MQQueue mQQueue = null;
            String string = mQSubEntry.getQName();
            try {
                if (mQSubEntry.getSharedQueue()) {
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Opening queue AS_Q_DEF");
                    }
                    mQQueue = mQQueueManager.accessQueue(string, 8193);
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Opened OK");
                    }
                } else {
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Opening queue EXCLUSIVE");
                    }
                    mQQueue = mQQueueManager.accessQueue(string, 8196);
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Opened OK");
                    }
                }
            }
            catch (MQException mQException) {
                switch (mQException.reasonCode) {
                    case 2052: 
                    case 2085: {
                        if (!Trace.isOn) break;
                        Trace.trace(CLASSNAME, "Warning: SubQ '" + string + "' missing. Continuing though.");
                        break;
                    }
                    default: {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS3014", string);
                        jMSException.setLinkedException((Exception)mQException);
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
                        }
                        Trace.trace(CLASSNAME, "Linked Exception " + mQException);
                        throw jMSException;
                    }
                }
            }
            SubscriptionHelper.deleteSubscriberMessages(mQSubEntry, mQQueue);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "deleteSubscriberMessages(qm,e)");
            }
        }
    }

    static void deleteSubscriberMessages(MQQueueSubscription mQQueueSubscription) throws JMSException {
        String string = mQQueueSubscription.isDurable() ? mQQueueSubscription.getClientId() + ":" + mQQueueSubscription.getSubName() : "";
        MQSubEntry mQSubEntry = new MQSubEntry(string, mQQueueSubscription.getTopic(), mQQueueSubscription.getQueueName(), mQQueueSubscription.getSelector(), mQQueueSubscription.getNoLocal(), mQQueueSubscription.getStatusMgrId(), mQQueueSubscription.isSharedQueue());
        MQQueue mQQueue = mQQueueSubscription.getSubscriberQueue();
        mQSubEntry.setSubscriberId(mQQueueSubscription.getCorrelationId());
        SubscriptionHelper.deleteSubscriberMessages(mQSubEntry, mQQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void deleteSubscriberMessages(MQSubEntry mQSubEntry, MQQueue mQQueue) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "deleteSubscriberMessages(e,q)");
        }
        try {
            if (!mQSubEntry.getSharedQueue() && mQQueue != null) {
                try {
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "Closing & deleting non-shared queue");
                    }
                    mQQueue.closeOptions = 2;
                    mQQueue.close();
                    if (!Trace.isOn) return;
                    Trace.trace(CLASSNAME, "Close & delete completed OK");
                    return;
                }
                catch (MQException mQException) {
                    if (mQQueue != null) {
                        mQQueue.closeOptions = 0;
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3017", mQSubEntry.getQName());
                    jMSException.setLinkedException((Exception)mQException);
                    throw jMSException;
                }
            }
            if (!mQSubEntry.getSharedQueue() || mQQueue == null) return;
            try {
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "deleteSubscriberMessages(e,q) attempting shared queue message cleanup.");
                }
                MQMessage mQMessage = new MQMessage();
                mQMessage.correlationId = mQSubEntry.getSubscriberId();
                MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 8256;
                mQGetMessageOptions.matchOptions = 2;
                int n = 0;
                boolean bl = false;
                while (!bl) {
                    try {
                        mQMessage.messageId = MQC.MQMI_NONE;
                        mQQueue.get(mQMessage, mQGetMessageOptions, 1);
                        ++n;
                    }
                    catch (MQException mQException) {
                        if (mQException.reasonCode == 2079) {
                            ++n;
                            continue;
                        }
                        bl = true;
                        if (!Trace.isOn) continue;
                        if (mQException.reasonCode == 2033) {
                            Trace.trace(CLASSNAME, "deleteSubscriberMessages cleanup complete: 2033 reached. Removed " + n + " messages.");
                            continue;
                        }
                        Trace.trace(CLASSNAME, "deleteSubscriberMessages cleanup: Unexpected MQException thrown: " + mQException);
                    }
                }
                mQQueue.close();
                return;
            }
            catch (MQException mQException) {
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Caught " + mQException);
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3017", mQSubEntry.getQName());
                jMSException.setLinkedException((Exception)mQException);
                Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            MQException mQException = (MQException)jMSException.getLinkedException();
            switch (mQException.reasonCode) {
                case 2052: 
                case 2085: {
                    if (!Trace.isOn) return;
                    Trace.trace(CLASSNAME, "deleteSubscriberMessages: Warning: subscription queue " + mQSubEntry.getQName() + " couldn't be found");
                    return;
                }
                default: {
                    throw jMSException;
                }
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "deleteSubscriberMessages(e,q)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MQQueue createOrOpenQueue(MQQueueManager mQQueueManager, String string, boolean bl) throws MQException {
        try {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "createOrOpenQueue");
            }
            MQQueue mQQueue = null;
            int n = 8226;
            mQQueue = string.endsWith("*") ? mQQueueManager.accessQueue("SYSTEM.JMS.MODEL.QUEUE", n, null, string, null) : mQQueueManager.accessQueue(string, n);
            MQQueue mQQueue2 = mQQueue;
            return mQQueue2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "createOrOpenQueue");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MQQueue accessQueue(MQQueueManager mQQueueManager, MQSubEntry mQSubEntry) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "accessQueue");
            }
            MQQueue mQQueue = null;
            try {
                mQQueue = mQSubEntry.getSharedQueue() ? mQQueueManager.accessQueue(mQSubEntry.getQName(), 8193) : mQQueueManager.accessQueue(mQSubEntry.getQName(), 8196);
            }
            catch (MQException mQException) {
                switch (mQException.reasonCode) {
                    case 2052: 
                    case 2085: {
                        if (!Trace.isOn) break;
                        Trace.trace(CLASSNAME, "Warning: Subscription queue '" + mQSubEntry.getQName() + "' no longer exists.");
                        break;
                    }
                    default: {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "accessQueue: MQException '" + mQException + "' caught");
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS3014");
                        jMSException.setLinkedException((Exception)mQException);
                        throw jMSException;
                    }
                }
            }
            MQQueue mQQueue2 = mQQueue;
            return mQQueue2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "accessQueue");
            }
        }
    }

    static void checkResponse(MQMsg2 mQMsg2) throws BrokerCommandFailedException, JMSException {
        String string;
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "checkResponse");
        }
        if (mQMsg2 == null) {
            Trace.trace(CLASSNAME, "response is NULL");
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1074");
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Creating and Throwing " + (Object)((Object)jMSException));
                Trace.exit(CLASSNAME, "checkResponse (via Exception)");
            }
            throw jMSException;
        }
        try {
            Trace.trace(CLASSNAME, "Getting format");
            string = mQMsg2.getFormat();
            Trace.trace(CLASSNAME, "Got format: " + string);
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Getting format as long: " + mQMsg2.getFormatAsLong());
            }
        }
        catch (Exception exception) {
            Trace.trace(CLASSNAME, "Caught " + exception);
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1087");
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
                Trace.exit(CLASSNAME, "checkResponse (via Exception)");
            }
            throw jMSException;
        }
        if (string.compareTo("MQHRF   ") == 0) {
            String string2;
            int n;
            int n2;
            Trace.trace(CLASSNAME, "RFH1 header found");
            RFH rFH = null;
            try {
                rFH = new RFH(mQMsg2);
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Throwing " + (Object)((Object)jMSException));
                    Trace.exit(CLASSNAME, "checkResponse (via Exception)");
                }
                throw jMSException;
            }
            try {
                n2 = Integer.parseInt(rFH.getValue("MQPSCompCode"));
                n = Integer.parseInt(rFH.getValue("MQPSReason"));
                string2 = rFH.getValue("MQPSReasonText");
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "MQPSCompCode returned " + n2);
                    Trace.trace(CLASSNAME, "MQPSReason returned " + n);
                    if (string2 != null) {
                        Trace.trace(CLASSNAME, "MQPSReasonText returned " + string2);
                    }
                }
            }
            catch (Exception exception) {
                Trace.trace(CLASSNAME, "Caught " + exception);
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1087");
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
                    Trace.exit(CLASSNAME, "checkResponse (via Exception)");
                }
                throw jMSException;
            }
            if (n2 == 2) {
                BrokerCommandFailedException brokerCommandFailedException = new BrokerCommandFailedException("Broker command failed: " + string2 + " Reason code " + n);
                brokerCommandFailedException.setReason(n);
                switch (n) {
                    case 3078: {
                        String string3 = rFH.getValue("MQPSUserId");
                        brokerCommandFailedException.setUserId(string3);
                    }
                }
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Creating and Throwing " + (Object)((Object)brokerCommandFailedException));
                    Trace.exit(CLASSNAME, "checkResponse (via Exception)");
                }
                throw brokerCommandFailedException;
            }
            if (n2 == 1 && n == 3081) {
                BrokerCommandFailedException brokerCommandFailedException = new BrokerCommandFailedException("Broker command failed: " + string2 + " Reason code " + n);
                brokerCommandFailedException.setReason(n);
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Creating and Throwing " + (Object)((Object)brokerCommandFailedException));
                    Trace.exit(CLASSNAME, "checkResponse (via Exception)");
                }
                throw brokerCommandFailedException;
            }
        } else {
            String string4;
            Object object;
            Trace.trace(CLASSNAME, "RFH2 header found");
            try {
                object = new RFH2(mQMsg2);
                string4 = ((RFH2)object).getNameValueString();
                int n = string4.indexOf("<pscr>");
                int n3 = string4.indexOf("</pscr>");
                if (n > 0 && n3 > 0) {
                    string4 = string4.substring(n, n3 + 7);
                }
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Response NameValue CCSID is " + ((RFH2)object).getCodedCharSetId());
                    Trace.trace(CLASSNAME, "Response NameValue string is " + string4);
                }
            }
            catch (Exception exception) {
                Trace.trace(CLASSNAME, "Caught exception: " + exception);
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1087");
                if (Trace.isOn) {
                    Trace.exception(CLASSNAME, "checkResponse", (Throwable)jMSException);
                    Trace.exit(CLASSNAME, "checkResponse (via Exception)");
                }
                throw jMSException;
            }
            if (!string4.startsWith("<pscr><Completion>")) {
                Trace.trace(CLASSNAME, "nameValueString does not start with <pscr><Completion>");
                object = ConfigEnvironment.newException("MQJMS1087");
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Create and Throwing " + object);
                    Trace.exit(CLASSNAME, "checkResponse (via Exception)");
                }
                throw object;
            }
            Trace.trace(CLASSNAME, "nameValueString DID start with <pscr><Completion>");
            Trace.trace(CLASSNAME, "Extract the completion value");
            String string5 = string4.substring(string4.indexOf("<Completion>") + 12, string4.indexOf("</Completion>"));
            if (string5.compareTo("ok") != 0) {
                Trace.trace(CLASSNAME, "Extract the reason value");
                String string6 = string4.substring(string4.indexOf("<Reason>") + 8, string4.indexOf("</Reason>"));
                Trace.trace(CLASSNAME, "Extract numeric reason code");
                int n = Integer.valueOf(string6);
                Trace.trace(CLASSNAME, "Numeric reason code expected");
                object = new BrokerCommandFailedException("Broker command failed: Reason code " + n);
                ((BrokerCommandFailedException)((Object)object)).setReason(n);
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "Creating and Throwing " + object);
                    Trace.exit(CLASSNAME, "checkResponse (via Exception)");
                }
                throw object;
            }
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "checkResponse");
        }
    }

    static void MQPUT1(MQQueueManager mQQueueManager, String string, String string2, MQJMSMessage mQJMSMessage, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "MQPUT1");
            Trace.trace(CLASSNAME, "About to perform an MQPUT1. Params follow:");
            Trace.trace(CLASSNAME, "   QueueManager:       '" + mQQueueManager.name + "'");
            Trace.trace(CLASSNAME, "   BrokerQueueManager: '" + string + "'");
            Trace.trace(CLASSNAME, "   Queue:              '" + string2 + "'");
            Trace.trace(CLASSNAME, "   Message:            '" + mQJMSMessage.toString() + "'");
        }
        MQQueue mQQueue = null;
        try {
            int n = 8208;
            if (bl) {
                n |= 0x400;
            }
            mQQueue = mQQueueManager.accessQueue(string2, n, string, null, null);
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS2008", string2);
            jMSException.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Failed to access broker queue due to: " + mQException);
                Trace.trace(CLASSNAME, "Create and Throwing " + (Object)((Object)jMSException));
                Trace.exit(CLASSNAME, "MQPUT1 (via Exception)");
            }
            throw jMSException;
        }
        try {
            MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
            mQPutMessageOptions.options |= 0x2000;
            if (bl) {
                mQPutMessageOptions.options |= 0x400;
            }
            mQQueue.putMsg2(mQJMSMessage, mQPutMessageOptions);
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3011");
            jMSException.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Failed to MQPUT broker command due to: " + mQException);
                Trace.trace(CLASSNAME, "Creating and Throwing " + (Object)((Object)jMSException));
                Trace.exit(CLASSNAME, "MQPUT1 (via Exception)");
            }
            throw jMSException;
        }
        try {
            mQQueue.close();
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS2000");
            jMSException.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Failed to close broker command due to: " + mQException);
                Trace.trace(CLASSNAME, "Creating and Throwing " + (Object)((Object)jMSException));
                Trace.exit(CLASSNAME, "MQPUT1 (via Exception)");
            }
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit(CLASSNAME, "MQPUT1");
        }
    }

    static void MQPUT1(MQQueueManager mQQueueManager, String string, String string2, MQJMSMessage mQJMSMessage) throws JMSException {
        SubscriptionHelper.MQPUT1(mQQueueManager, string, string2, mQJMSMessage, false);
    }

    static void unsubscribe(MQQueueManager mQQueueManager, BrokerConnectionInfo brokerConnectionInfo, String string, MQSubAdmin mQSubAdmin) throws JMSException {
        try {
            Object object;
            MQSubEntry mQSubEntry;
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "unsubscribe");
            }
            if ((mQSubEntry = mQSubAdmin.getResolved(mQQueueManager, brokerConnectionInfo, string, null, false)) == null) {
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "No entry found for '" + string + "'");
                }
                String string2 = "MQJMS3018";
                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
                throw invalidDestinationException;
            }
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Entry found for '" + string + "'");
                Trace.trace(CLASSNAME, mQSubEntry.toString());
            }
            MQQueue mQQueue = null;
            try {
                mQQueue = mQSubAdmin.checkInactive(mQQueueManager, mQSubEntry);
            }
            catch (JMSException jMSException) {
                object = (MQException)jMSException.getLinkedException();
                switch (((MQException)object).reasonCode) {
                    case 2052: 
                    case 2085: {
                        if (!Trace.isOn) break;
                        Trace.trace(CLASSNAME, "Warning: durable sub queue '" + mQSubEntry.getQName() + " is missing\n");
                        Trace.trace(CLASSNAME, "Carrying on with deregister");
                        break;
                    }
                    default: {
                        throw jMSException;
                    }
                }
            }
            mQSubEntry.setSubscriberState('t');
            mQSubAdmin.add(mQSubEntry, false);
            SubscriptionHelper.deleteSubscriber(mQQueueManager, brokerConnectionInfo, mQSubEntry, mQQueue);
            MQSubEntry mQSubEntry2 = mQSubAdmin.remove(mQSubEntry);
            if (mQSubEntry2 == null) {
                if (Trace.isOn) {
                    Trace.trace(CLASSNAME, "unsubscribe problem - failed to remove the admin entry");
                }
                object = ConfigEnvironment.newException("MQJMS3013");
                throw object;
            }
            object = mQSubAdmin.remove(mQSubEntry);
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "unsubscribe throwing: " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(CLASSNAME, "linked exception: " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "unsubscribe");
            }
        }
    }

    private static MQJMSMessage buildPubSubMessage(String string, byte[] byArray, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "buildPubSubMessage");
            Trace.trace(CLASSNAME, "  directive: '" + string + "'");
            Trace.trace(CLASSNAME, "  correlId:  '" + Utils.bytesToHex(byArray) + "'");
            Trace.trace(CLASSNAME, "  report:    '" + (bl ? "true" : "false") + "'");
        }
        try {
            MQJMSMessage mQJMSMessage = new MQJMSMessage();
            JMSNullMessage jMSNullMessage = new JMSNullMessage(jmsStrings);
            jMSNullMessage.setJMSDeliveryMode(2);
            mQJMSMessage.writeRFH(string, jMSNullMessage, false, 0);
            mQJMSMessage.setFormat("MQHRF   ");
            mQJMSMessage.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
            if (bl) {
                mQJMSMessage.setReport(3);
            }
            if (byArray != null) {
                mQJMSMessage.setCorrelationId(byArray);
            }
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "buildPubSubMessage");
            }
            return mQJMSMessage;
        }
        catch (Exception exception) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3008");
            jMSException.setLinkedException(exception);
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Unable to build p/s command message: " + exception);
                Trace.trace(CLASSNAME, "Creating and Throwing " + (Object)((Object)jMSException));
                Trace.exit(CLASSNAME, "buildPubSubMessage (via Exception)");
            }
            throw jMSException;
        }
    }

    private static void interpretMetaMessage(BytesMessage bytesMessage, Vector vector, String string) throws Exception {
        if (Trace.isOn) {
            Trace.entry(CLASSNAME, "interpretMetaMessage");
            Trace.trace(CLASSNAME, "Incoming message: " + bytesMessage);
        }
        try {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            PCF pCF = new PCF(bytesMessage);
            int n = pCF.getParameterCount();
            for (int i = 0; i < n; ++i) {
                int n2 = pCF.getParameterType(i);
                if (n2 == 4) {
                    PCF.MQCFST mQCFST = (PCF.MQCFST)pCF.getParameterAt(i);
                    int n3 = mQCFST.paramId;
                    String string8 = mQCFST.value;
                    if (n3 == 3031) {
                        if (string8.startsWith(string)) {
                            string8 = string8.substring(string.length() + 1);
                        }
                        if (string8.startsWith(string)) {
                            return;
                        }
                        string2 = string8;
                        continue;
                    }
                    if (n3 == 3034) continue;
                    if (n3 == 3039) {
                        string6 = string8;
                        continue;
                    }
                    if (n3 == 3042) {
                        string3 = string8;
                        continue;
                    }
                    if (n3 == 3043) {
                        string4 = string8;
                        continue;
                    }
                    if (n3 == 3044) {
                        string5 = string8;
                        continue;
                    }
                    if (n3 != 3038) continue;
                    string7 = string8;
                    SubscriptionInfo subscriptionInfo = new SubscriptionInfo(string3, string4, string2, string5, string6, string7);
                    vector.addElement(subscriptionInfo);
                    string7 = null;
                    string6 = null;
                    string5 = null;
                    string4 = null;
                    string3 = null;
                    continue;
                }
                if (n2 == 3) continue;
                throw new Exception("Unknown paramType in broker PCF response: " + n2);
            }
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Exception caught in interpretMetaMessage: " + exception);
            }
            throw exception;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "interpretMetaMessage");
            }
        }
    }
}

