/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.MQXATopicConnection;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.XAConnection;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;

public class MQXATopicConnectionFactory
extends MQTopicConnectionFactory
implements XATopicConnectionFactory {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQXATopicConnectionFactory.java, jms, j600, j600-101-060328 1.24.1.1 05/05/25 15:58:03";
    static /* synthetic */ Class class$com$ibm$mq$jms$MQXATopicConnectionFactory;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQXATopicConnectionFactoryFactory;

    public XATopicConnection createXATopicConnection() throws JMSException {
        try {
            MQXATopicConnection mQXATopicConnection;
            if (Trace.isOn) {
                Trace.entry(this, "createXATopicConnection");
            }
            if (2 == this.getTransportType()) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS6311");
                throw jMSException;
            }
            MQXATopicConnection mQXATopicConnection2 = mQXATopicConnection = new MQXATopicConnection(this);
            return mQXATopicConnection2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception: " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createXATopicConnection");
            }
        }
    }

    public XATopicConnection createXATopicConnection(String string, String string2) throws JMSException {
        try {
            Object object;
            if (Trace.isOn) {
                Trace.entry(this, "createXATopicConnection");
                Trace.trace(this, "userName  = " + string);
                if (string2 != null) {
                    Trace.trace(this, "password is non-null");
                }
            }
            if (2 == this.getTransportType()) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS6311");
                throw jMSException;
            }
            if (MQEnvironment.runningInWS() && string != null && string.length() > 12) {
                if (Trace.isOn) {
                    Trace.trace(this, "Running in Websphere with userName longer than 12 chars");
                    Trace.trace(this, "UserName is " + string);
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1092", string);
                throw jMSException;
            }
            int n = this.getTransportType();
            switch (n) {
                case 1: 
                case 3: {
                    break;
                }
                case 0: {
                    object = (String)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return System.getProperty("user.name");
                        }
                    });
                    if (((String)object).equals(string)) break;
                    String string3 = "MQJMS2013";
                    String string4 = ConfigEnvironment.getErrorMessage(string3);
                    JMSSecurityException jMSSecurityException = new JMSSecurityException(string4, string3);
                    if (Trace.isOn) {
                        Trace.trace(this, "Creating and Throwing " + jMSSecurityException);
                        Trace.exit(this, "createTopicConnection");
                    }
                    throw jMSSecurityException;
                }
                default: {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1008", String.valueOf(n));
                    throw jMSException;
                }
            }
            Object object2 = object = new MQXATopicConnection(this, string, string2);
            return object2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception: " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createXATopicConnection");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference getReference() throws NamingException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getReference");
            }
            Reference reference = new Reference((class$com$ibm$mq$jms$MQXATopicConnectionFactory == null ? (class$com$ibm$mq$jms$MQXATopicConnectionFactory = MQXATopicConnectionFactory.class$("com.ibm.mq.jms.MQXATopicConnectionFactory")) : class$com$ibm$mq$jms$MQXATopicConnectionFactory).getName(), (class$com$ibm$mq$jms$MQXATopicConnectionFactoryFactory == null ? (class$com$ibm$mq$jms$MQXATopicConnectionFactoryFactory = MQXATopicConnectionFactory.class$("com.ibm.mq.jms.MQXATopicConnectionFactoryFactory")) : class$com$ibm$mq$jms$MQXATopicConnectionFactoryFactory).getName(), null);
            super.populateReference(reference);
            Reference reference2 = reference;
            return reference2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getReference");
            }
        }
    }

    public XAConnection createXAConnection(String string, String string2) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createXATopicConnection");
                Trace.trace(this, "userName  = " + string);
                if (string2 != null) {
                    Trace.trace(this, "password is non-null");
                }
            }
            XATopicConnection xATopicConnection = this.createXATopicConnection(string, string2);
            return xATopicConnection;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception: " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn()) {
                Trace.exit(this, "createXAConnection");
            }
        }
    }

    public XAConnection createXAConnection() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createXAConnection");
            }
            XATopicConnection xATopicConnection = this.createXATopicConnection();
            return xATopicConnection;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception: " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createXAConnection");
            }
        }
    }

    public void setTransportType(int n) throws JMSException {
        if (n == 2 | n == 4) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS6311");
            throw jMSException;
        }
        super.setTransportType(n);
    }

    public int getReceiveIsolation() throws JMSException {
        String string = "MQJMS1069";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public boolean getOutcomeNotification() throws JMSException {
        String string = "MQJMS1069";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public int getProcessDuration() throws JMSException {
        String string = "MQJMS1069";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setReceiveIsolation(int n) throws JMSException {
        String string = "MQJMS1069";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setOutcomeNotification(boolean bl) throws JMSException {
        String string = "MQJMS1069";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    public void setProcessDuration(int n) throws JMSException {
        String string = "MQJMS1069";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        IllegalStateException illegalStateException = new IllegalStateException(string2, string);
        throw illegalStateException;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

