/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSMapMessage;
import com.ibm.jms.JMSMessage;
import com.ibm.jms.JMSStreamMessage;
import com.ibm.jms.JMSTextMessage;
import com.ibm.mq.MQCcsidTable;
import com.ibm.mq.MQException;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;

class MQJMSMessage
extends MQMsg2 {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQJMSMessage.java, jms, j600, j600-101-060328 1.92.1.3 05/07/21 16:34:58";
    public static final String CLASSNAME = "com.ibm.mq.jms.MQJMSMessage";
    private static final int RFH_CHARACTER_SET = 1208;
    private static final byte[] SPACES = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    private static final String RFH_CHAR_SET_STRING = "UTF8";
    public static final String MQRFH_STRUC_ID = "RFH ";
    public static final int MQRFH_VERSION_1 = 1;
    public static final int MQRFH_VERSION_2 = 2;
    public static final int MQRFH_NO_FLAGS = 0;
    public static final String MQFMT_RF_HEADER_1 = "MQHRF   ";
    public static final String MQFMT_RF_HEADER_2 = "MQHRF2  ";
    public static final int MQRFH_STRUC_LENGTH_FIXED_1 = 32;
    public static final int MQRFH_STRUC_LENGTH_FIXED_2 = 36;
    public static final int MQCCSI_INHERIT = -2;
    private static final long MQHEADER_ASCII = 5571313378871214080L;
    private static final long MQHEADER_EBCDIC = -3109515640373772288L;
    private static final long MQHEADER_MASK = -1099511627776L;
    public static final long MQRFH2_ASCII = 5571313732236222496L;
    public static final long MQRFH2_EBCDIC = -3109514705028104128L;
    public static final long MQRFH1_ASCII = 5571313732235042848L;
    public static final long MQRFH1_EBCDIC = -3109514705039769536L;
    public static final long MQSTR_ASCII = 5571325835654209568L;
    public static final long MQSTR_EBCDIC = -3109486074469007296L;
    private static final String BLANK_STRING15 = "               ";
    private static final Integer ZERO = new Integer(0);
    private static final byte[] MQ_NONE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String ENCODING_PROPERTY = "JMS_IBM_Encoding";
    private static final int RFH2_FIXED_SIZE = 36;
    private static final int MQRFH_VERSION_OFFSET = 4;
    private static final int RFH2_LENGTH_OFFSET = 8;
    private static final int RFH2_ENCODING_OFFSET = 12;
    private static final int RFH2_CHARSET_OFFSET = 16;
    private static final int RFH2_FORMAT_OFFSET = 20;
    private static final int RFH_CHAR_SET_OFFSET = 32;
    private byte[] cachedFixedRFH2 = null;
    private int cachedRFH2Length;
    private int cachedRFH2Encoding;
    private int cachedRFH2CharSet;
    private boolean persistenceFromMD;
    private boolean targetClientMatching = true;
    private boolean hasRFH2 = false;
    private byte[] formatAsByteArray = new byte[8];
    private static Hashtable ccsidTable = new Hashtable(7);
    String cachedRFH2Format;

    MQJMSMessage() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    JMSMessage createJMSMessage(MQSession mQSession) throws JMSException, IOException {
        JMSMessage jMSMessage;
        int n = this.getCharacterSet();
        int n2 = this.getEncoding();
        if (mQSession != null && mQSession.connection != null) {
            this.persistenceFromMD = mQSession.getPersistenceFromMD();
            this.targetClientMatching = mQSession.connection.targetClientMatching;
        }
        try {
            try {
                JMSMessage jMSMessage2 = null;
                String string = null;
                int n3 = 0;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                this.hasRFH2 = false;
                boolean bl = false;
                boolean bl2 = false;
                if (Trace.isOn) {
                    Trace.entry(this, "createJMSMessage");
                }
                int n12 = n2;
                long l = this.getFormatAsLong();
                int n13 = 1208;
                int n14 = 1;
                n3 = 0;
                int n15 = 0;
                while ((l & 0xFFFFFF0000000000L) == 5571313378871214080L || (l & 0xFFFFFF0000000000L) == -3109515640373772288L) {
                    int n16;
                    int n17;
                    int n18;
                    block51: {
                        block46: {
                            this.skipReadingBytes(8);
                            n18 = this.readInt(n12);
                            n17 = this.readInt(n12);
                            n16 = this.readInt(n12);
                            if (l != 5571313732236222496L && l != -3109514705028104128L) break block46;
                            this.hasRFH2 = true;
                            l = (long)this.readInt(1) << 32;
                            l += (long)this.readInt(1) & 0xFFFFFFFFL;
                            n13 = this.getCharacterSet();
                            n14 = n12;
                            this.skipReadingBytes(4);
                            int n19 = this.readInt(n12);
                            if (n19 == 1208) {
                                bl = true;
                            } else {
                                string2 = MQJMSMessage.getCharacterSetString(n19, n12);
                                bl = false;
                            }
                            n3 += 36;
                            while (n3 < n18 + n15) {
                                int n20;
                                block49: {
                                    block47: {
                                        int n21;
                                        byte[] byArray;
                                        block50: {
                                            block48: {
                                                n20 = this.readInt(n12);
                                                n3 += 4;
                                                if (!bl) break block47;
                                                byArray = this.getMessageDataRef();
                                                if (byArray[(n21 = n3) + 0] != 60 || byArray[n21 + 1] != 109 || byArray[n21 + 2] != 99 || byArray[n21 + 3] != 100 || byArray[n21 + 4] != 62) break block48;
                                                n4 = n3;
                                                n5 = n20;
                                                break block49;
                                            }
                                            if (byArray[n21 + 0] != 60 || byArray[n21 + 1] != 106 || byArray[n21 + 2] != 109 || byArray[n21 + 3] != 115 || byArray[n21 + 4] != 62) break block50;
                                            n8 = n3;
                                            n9 = n20;
                                            break block49;
                                        }
                                        if (byArray[n21 + 0] == 60 && byArray[n21 + 1] == 117 && byArray[n21 + 2] == 115 && byArray[n21 + 3] == 114 && byArray[n21 + 4] == 62) {
                                            n6 = n3;
                                            n7 = n20;
                                            break block49;
                                        } else if (byArray[n21 + 0] == 60 && byArray[n21 + 1] == 109 && byArray[n21 + 2] == 113 && byArray[n21 + 3] == 101 && byArray[n21 + 4] == 120 && byArray[n21 + 5] == 116 && byArray[n21 + 6] == 62) {
                                            n10 = n3;
                                            n11 = n20;
                                        }
                                        break block49;
                                    }
                                    String string7 = new String(this.getMessageDataRef(), n3, n20, string2);
                                    if (Trace.isOn) {
                                        Trace.trace(this, "createJMSMessage found Folder " + string7);
                                    }
                                    if (string7.startsWith("<mcd>")) {
                                        string3 = string7;
                                    } else if (string7.startsWith("<usr>")) {
                                        string4 = string7;
                                    } else if (string7.startsWith("<jms>")) {
                                        string5 = string7;
                                    } else if (string7.startsWith("<mqext>")) {
                                        string6 = string7;
                                    }
                                }
                                n3 += n20;
                                this.skipReadingBytes(n20);
                            }
                            break block51;
                        }
                        l = (long)this.readInt(1) << 32;
                        l += (long)this.readInt(1) & 0xFFFFFFFFL;
                        n13 = this.getCharacterSet();
                        n14 = n12;
                        this.skipReadingBytes(n18 - 28);
                        n3 += n18;
                    }
                    n12 = n17;
                    this.setEncoding(n17);
                    n15 += n18;
                    if (n16 == -2) continue;
                    this.setCharacterSet(n16);
                }
                if (bl && n5 > 0) {
                    String string8;
                    byte[] byArray = this.getMessageDataRef();
                    if (l == 5571325835654209568L || l == -3109486074469007296L) {
                        string8 = "jms_text";
                        string = "MQSTR   ";
                    } else {
                        string8 = "jms_bytes";
                    }
                    jMSMessage2 = JMSMessage._parseMcdFolderUtf8(mQSession, MQSession.jmsStrings, string8, byArray, n4, n5);
                    if (n9 > 0) {
                        jMSMessage2._parseJmsFolderUtf8(byArray, n8, n9, mQSession, this.persistenceFromMD);
                        bl2 = true;
                    }
                    if (n7 > 0) {
                        string4 = new String(byArray, n6, n7, RFH_CHAR_SET_STRING);
                        jMSMessage2._parseUsrFolder(string4);
                    }
                    if (n11 > 0) {
                        jMSMessage2._parseMQExtFolderUtf8(byArray, n10, n11);
                    }
                } else if (string3 != null) {
                    String string9;
                    if (l == 5571325835654209568L || l == -3109486074469007296L) {
                        string9 = "jms_text";
                        string = "MQSTR   ";
                    } else {
                        string9 = "jms_bytes";
                    }
                    jMSMessage2 = JMSMessage._parseMcdFolder(mQSession, MQSession.jmsStrings, string3, string9);
                    if (string5 != null) {
                        jMSMessage2._parseJmsFolder(mQSession, string5, this.persistenceFromMD);
                        bl2 = true;
                    }
                    if (string4 != null) {
                        jMSMessage2._parseUsrFolder(string4);
                    }
                    if (string6 != null) {
                        jMSMessage2._parseMQExtFolder(string6);
                    }
                } else if (this.getMessageDataLength() == 0) {
                    jMSMessage2 = (JMSMessage)mQSession.createMessage();
                } else if (l == 5571325835654209568L || l == -3109486074469007296L) {
                    string = "MQSTR   ";
                    jMSMessage2 = (JMSMessage)mQSession.createTextMessage();
                } else {
                    jMSMessage2 = (JMSMessage)mQSession.createBytesMessage();
                }
                if (!bl2) {
                    jMSMessage2.setJMSDeliveryMode(-3);
                }
                this.setHeaderFromMQMD(jMSMessage2);
                if (string == null) {
                    this.formatAsByteArray[0] = (byte)(l >>> 56 & 0xFFL);
                    this.formatAsByteArray[1] = (byte)(l >>> 48 & 0xFFL);
                    this.formatAsByteArray[2] = (byte)(l >>> 40 & 0xFFL);
                    this.formatAsByteArray[3] = (byte)(l >>> 32 & 0xFFL);
                    this.formatAsByteArray[4] = (byte)(l >>> 24 & 0xFFL);
                    this.formatAsByteArray[5] = (byte)(l >>> 16 & 0xFFL);
                    this.formatAsByteArray[6] = (byte)(l >>> 8 & 0xFFL);
                    this.formatAsByteArray[7] = (byte)(l >>> 0 & 0xFFL);
                    String string10 = MQJMSMessage.getCharacterSetString(n13, n14);
                    string = new String(this.formatAsByteArray, string10);
                }
                this.setHeaderFromMQMD_on_Receive(jMSMessage2, string);
                if (n3 < this.getMessageDataLength()) {
                    jMSMessage2._importBody(this.getMessageData(), n3, this.getEncoding(), MQJMSMessage.getCharacterSetString(this.getCharacterSet(), this.getEncoding()));
                }
                jMSMessage2._setReadOnly();
                jMSMessage = jMSMessage2;
                Object var37_45 = null;
            }
            catch (IOException iOException) {
                if (!Trace.isOn) throw iOException;
                Trace.trace(this, "createJMSMessage throwing " + iOException);
                throw iOException;
            }
            catch (MQException mQException) {
                JMSException jMSException = new JMSException("MQJMS1000");
                jMSException.setLinkedException((Exception)mQException);
                Trace.trace(this, "createJMSMessage throwing " + (Object)((Object)jMSException));
                Trace.trace(this, "linked exception " + mQException);
                throw jMSException;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "createJMSMessage throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var37_46 = null;
            this.setCharacterSet(n);
            this.setEncoding(n2);
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createJMSMessage");
            throw throwable;
        }
        this.setCharacterSet(n);
        this.setEncoding(n2);
        if (!Trace.isOn) return jMSMessage;
        Trace.exit(this, "createJMSMessage");
        return jMSMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getCharacterSetString(int n, int n2) {
        try {
            String string;
            String string2;
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "getCharacterSetString");
            }
            if (n == 0) {
                n = 819;
            }
            if (n % 4096 == 1200) {
                string2 = (n2 & 0xF) == 2 ? "UnicodeLittle" : "UnicodeBig";
            } else {
                string = Integer.toString(n);
                string2 = MQCcsidTable.lookup(string);
                if (string2 == null) {
                    string2 = "Cp" + string;
                }
            }
            if (Trace.isOn) {
                Trace.trace(2, CLASSNAME, "Mapped " + n + " -> " + string2);
            }
            string = string2;
            return string;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "getCharacterSetString");
            }
        }
    }

    void setHeaderFromMQMD(Message message) throws JMSException {
        try {
            boolean bl;
            Serializable serializable;
            if (Trace.isOn) {
                Trace.entry(this, "setHeaderFromMQMD");
            }
            message.setJMSPriority(this.getPriority());
            if (message.getJMSDeliveryMode() == -2 || this.persistenceFromMD) {
                if (this.getPersistence() == 0) {
                    message.setJMSDeliveryMode(1);
                } else if (this.getPersistence() == 1) {
                    message.setJMSDeliveryMode(2);
                } else {
                    message.setJMSDeliveryMode(-1);
                }
            }
            if (message instanceof JMSMessage) {
                if (Trace.isOn) {
                    Trace.trace(this, "message is from com.ibm.jms");
                }
                serializable = (JMSMessage)message;
                ((JMSMessage)serializable)._setCcsidForStrings(this._getCcsid(), this._getIsCcsidAscii(), this._doStringsNeedCcsidConversion());
                ((JMSMessage)serializable)._setJMSMessageIDAsBytes(this.getMessageId());
                ((JMSMessage)serializable)._setJMSXUserIDFromBytes(this.getUserIdAsBytes());
                ((JMSMessage)serializable)._setJMSXPutAppIDFromBytes(this.getPutApplicationNameAsBytes());
                if ((this.getMessageFlags() & 8) != 0 || (this.getMessageFlags() & 0x10) != 0) {
                    ((JMSMessage)serializable)._setJMSXGroupSeqFromInt(this.getMessageSequenceNumber());
                    String string = JMSMessage._idToString(this.getGroupId());
                    if (string != null) {
                        ((JMSMessage)serializable)._setJMSXObjectProperty("JMSXGroupID", string);
                    }
                }
                ((JMSMessage)serializable)._setJMSIBMPutDateFromBytes(this.getPutDateAsBytes());
                ((JMSMessage)serializable)._setJMSIBMPutTimeFromBytes(this.getPutTimeAsBytes());
                ((JMSMessage)serializable)._setJMSIBMPutApplTypeFromInt(this.getPutApplicationType());
                bl = ((JMSMessage)serializable)._hasJMSReplyTo();
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "message is from another vendor, only updating subset of properties");
                }
                message.setJMSMessageID(JMSMessage._idToString(this.getMessageId()));
                boolean bl2 = bl = message.getJMSReplyTo() != null;
            }
            if (!bl && this.getReplyToQueueName() != null && !this.getReplyToQueueName().trim().equals("")) {
                serializable = new MQQueue(this.getReplyToQueueManagerName(), this.getReplyToQueueName());
                if (!this.hasRFH2 && this.targetClientMatching) {
                    ((MQDestination)serializable).setTargetClient(1);
                }
                message.setJMSReplyTo((Destination)serializable);
            }
        }
        catch (MQException mQException) {
            JMSException jMSException = new JMSException("MQJMS1000");
            jMSException.setLinkedException((Exception)mQException);
            Trace.trace(this, "setHeaderFromMQMD throwing " + (Object)((Object)jMSException));
            Trace.trace(this, "linked exception " + mQException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setHeaderFromMQMD");
            }
        }
    }

    void setHeaderFromMQMD_on_Receive(JMSMessage jMSMessage, String string) throws JMSException {
        try {
            int n;
            int n2;
            if (Trace.isOn) {
                Trace.entry(this, "setHeaderFromMQMD_on_Receive");
            }
            if (jMSMessage.getJMSCorrelationID() == null) {
                jMSMessage.setJMSCorrelationIDAsBytes(this.getCorrelationIdRef());
            }
            if (jMSMessage.getJMSTimestamp() == 0L) {
                jMSMessage.setJMSTimestamp(this.getPutTimeMillis());
            }
            if (jMSMessage.getJMSExpiration() == 0L && this.getExpiry() > 0) {
                jMSMessage.setJMSExpiration(System.currentTimeMillis() + (long)(this.getExpiry() * 100));
            }
            if (this.getBackoutCount() > 0) {
                jMSMessage.setJMSRedelivered(true);
            }
            jMSMessage._setJMSXDeliveryCountFromInt(this.getBackoutCount() + 1);
            jMSMessage._setJMSIBMMsgTypeFromInt(this.getMessageType());
            jMSMessage._setJMSXObjectProperty("JMS_IBM_Format", string);
            if (this.getFeedback() != 0) {
                jMSMessage._setJMSIBMFeedbackFromInt(this.getFeedback());
            }
            if ((n2 = (n = this.getReport()) & 0x7000000) != 0) {
                jMSMessage._setJMSIBMReportExceptionFromInt(n2);
            }
            if ((n2 = n & 0xE00000) != 0) {
                jMSMessage._setJMSIBMReportExpirationFromInt(n2);
            }
            if ((n2 = n & 0x700) != 0) {
                jMSMessage._setJMSIBMReportCOAFromInt(n2);
            }
            if ((n2 = n & 0x3800) != 0) {
                jMSMessage._setJMSIBMReportCODFromInt(n2);
            }
            if ((n2 = n & 1) != 0) {
                jMSMessage._setJMSIBMReportPANFromInt(n2);
            }
            if ((n2 = n & 2) != 0) {
                jMSMessage._setJMSIBMReportNANFromInt(n2);
            }
            if ((n2 = n & 0x40) != 0) {
                jMSMessage._setJMSIBMPassCorrelIDFromInt(n2);
            }
            if ((n2 = n & 0x80) != 0) {
                jMSMessage._setJMSIBMReportMsgIDFromInt(n2);
            }
            if ((n2 = n & 0x8000000) != 0) {
                jMSMessage._setJMSIBMReportDiscardFromInt(n2);
            }
            if ((this.getMessageFlags() & 0x10) != 0) {
                jMSMessage._setJMSIBMLastMsgInGroupFromBool(true);
            }
        }
        catch (MQException mQException) {
            JMSException jMSException = new JMSException("MQJMS1000");
            jMSException.setLinkedException((Exception)mQException);
            Trace.trace(this, "setHeaderFromMQMD_on_Receive throwing " + (Object)((Object)jMSException));
            Trace.trace(this, "linked exception " + mQException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setHeaderFromMQMD_on_Receive");
            }
        }
    }

    void write(JMSMessage jMSMessage, boolean bl, int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "write");
            }
            jMSMessage.setJMSRedelivered(false);
            jMSMessage._setJMSXObjectProperty("JMSXDeliveryCount", ZERO);
            this.writeMQMD(jMSMessage);
            if (bl) {
                this.writeRFH2(jMSMessage, n);
            } else {
                this.setCharacterSet(n);
            }
            byte[] byArray = jMSMessage._exportBody(this.getEncoding(), MQJMSMessage.getCharacterSetString(n, this.getEncoding()));
            if (byArray != null) {
                this.appendByteArray(byArray);
            }
        }
        catch (IOException iOException) {
            String string = ConfigEnvironment.getErrorMessage("MQJMS1065");
            if (Trace.isOn) {
                Trace.trace(0, this, "Throwing JMSException " + string);
            }
            JMSException jMSException = new JMSException(string);
            jMSException.setLinkedException((Exception)iOException);
            throw jMSException;
        }
        catch (MQException mQException) {
            JMSException jMSException = new JMSException("MQJMS1000");
            jMSException.setLinkedException((Exception)mQException);
            Trace.trace(this, "write throwing " + (Object)((Object)jMSException));
            Trace.trace(this, "linked exception " + mQException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "write");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeFolder(String string) throws IOException, MQException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "writeFolder");
            }
            int n = this.getMessageDataLength();
            byte[] byArray = string.getBytes(RFH_CHAR_SET_STRING);
            int n2 = byArray.length;
            int n3 = 3 - (n + n2 - 1) % 4;
            this.appendInt(n2 += n3, this.getEncoding());
            this.appendByteArray(byArray);
            this.appendByteArray(SPACES, 0, n3);
            int n4 = n2 + 4;
            return n4;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "writeFolder");
            }
        }
    }

    private void writeMQMD(JMSMessage jMSMessage) throws JMSException {
        try {
            String string;
            Object object;
            if (Trace.isOn) {
                Trace.entry(this, "writeMQMD");
            }
            this.setPriority(jMSMessage.getJMSPriority());
            this.setMessageId(MQ_NONE);
            byte[] byArray = jMSMessage.getJMSCorrelationIDAsBytes();
            if (byArray != null) {
                this.setCorrelationId(byArray);
            } else {
                String string2 = jMSMessage.getJMSCorrelationID();
                if (string2 == null) {
                    this.setCorrelationId(MQ_NONE);
                } else {
                    try {
                        this.setCorrelationId(string2.getBytes(RFH_CHAR_SET_STRING));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        int n = 1022;
                        String string3 = MQSession.jmsStrings.getErrorMessage(n);
                        JMSException jMSException = new JMSException(string3, MQSession.jmsStrings.getNativeKey(n));
                        jMSException.setLinkedException((Exception)unsupportedEncodingException);
                        if (Trace.isOn) {
                            Trace.exit(this, "writeMQMD, via Exception");
                        }
                        throw jMSException;
                    }
                }
            }
            int n = jMSMessage.getJMSDeliveryMode();
            if (n == 1) {
                this.setPersistence(0);
            } else if (n == 2) {
                this.setPersistence(1);
            } else if (n == 2) {
                this.setPersistence(0);
            } else {
                String string4 = ConfigEnvironment.getErrorMessage("MQJMS1042");
                if (Trace.isOn) {
                    Trace.trace(0, this, "Throwing JMSException " + string4);
                }
                throw new JMSException(string4);
            }
            if (jMSMessage instanceof JMSTextMessage || jMSMessage instanceof JMSStreamMessage || jMSMessage instanceof JMSMapMessage) {
                this.setFormat("MQSTR   ");
            } else {
                this.setFormat("        ");
            }
            long l = jMSMessage._getTimeToLive();
            if (l == 0L) {
                this.setExpiry(-1);
            } else if (l < 214748364700L) {
                this.setExpiry((int)((l + 100L) / 100L));
            } else {
                this.setExpiry(-1);
            }
            Destination destination = jMSMessage.getJMSReplyTo();
            this.resetReplyToQueueName();
            this.resetReplyToQueueManagerName();
            if (destination instanceof MQQueue) {
                object = ((MQQueue)destination).getBaseQueueName();
                if (object != null) {
                    this.setReplyToQueueName((String)object);
                }
                if ((string = ((MQQueue)destination).getBaseQueueManagerName()) != null) {
                    this.setReplyToQueueManagerName(string);
                }
                this.setMessageType(1);
            } else {
                this.setMessageType(8);
            }
            object = jMSMessage.getPropertyNames();
            this.setReport(0);
            this.setFeedback(0);
            this.setGroupId(MQ_NONE);
            this.setMessageSequenceNumber(1);
            this.setOffset(0);
            this.setMessageFlags(0);
            this.setOriginalLength(-1);
            Destination destination2 = jMSMessage.getJMSDestination();
            boolean bl = destination2 instanceof Queue;
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                if (!string.startsWith("JMS")) continue;
                if (Trace.isOn) {
                    Trace.trace(3, this, "Processing property " + string);
                }
                if (bl && string.equals("JMSXGroupID")) {
                    String string5 = jMSMessage.getStringProperty("JMSXGroupID");
                    if (string5.startsWith("ID:")) {
                        this.setGroupId(jMSMessage._stringToId(string5));
                    } else {
                        this.setGroupId(string5.getBytes(RFH_CHAR_SET_STRING));
                    }
                    this.setMessageFlags(this.getMessageFlags() | 8);
                    continue;
                }
                if (bl && string.equals("JMSXGroupSeq")) {
                    this.setMessageSequenceNumber(jMSMessage._getJMSXGroupSeqAsInt());
                    this.setMessageFlags(this.getMessageFlags() | 8);
                    continue;
                }
                if (!string.startsWith("JMS_IBM_")) continue;
                if (string.equals("JMS_IBM_Format")) {
                    this.setFormat(jMSMessage.getStringProperty("JMS_IBM_Format"));
                    continue;
                }
                if (string.equals("JMS_IBM_MsgType")) {
                    this.setMessageType(jMSMessage._getJMSIBMMsgTypeAsInt());
                    continue;
                }
                if (string.equals("JMS_IBM_Feedback")) {
                    this.setFeedback(jMSMessage._getJMSIBMFeedbackAsInt());
                    continue;
                }
                if (string.equals("JMS_IBM_Report_Exception")) {
                    this.setReport(this.getReport() | jMSMessage._getJMSIBMReportExceptionAsInt() & 0x7000000);
                    continue;
                }
                if (string.equals("JMS_IBM_Report_Expiration")) {
                    this.setReport(this.getReport() | jMSMessage._getJMSIBMReportExpirationAsInt() & 0xE00000);
                    continue;
                }
                if (string.equals("JMS_IBM_Report_COA")) {
                    this.setReport(this.getReport() | jMSMessage._getJMSIBMReportCOAAsInt() & 0x700);
                    continue;
                }
                if (string.equals("JMS_IBM_Report_COD")) {
                    this.setReport(this.getReport() | jMSMessage._getJMSIBMReportCODAsInt() & 0x3800);
                    continue;
                }
                if (string.equals("JMS_IBM_Report_PAN")) {
                    this.setReport(this.getReport() | jMSMessage._getJMSIBMReportPANAsInt() & 1);
                    continue;
                }
                if (string.equals("JMS_IBM_Report_NAN")) {
                    this.setReport(this.getReport() | jMSMessage._getJMSIBMReportNANAsInt() & 2);
                    continue;
                }
                if (string.equals("JMS_IBM_Report_Pass_Msg_ID")) {
                    this.setReport(this.getReport() | jMSMessage._getJMSIBMReportMsgIDAsInt() & 0x80);
                    continue;
                }
                if (string.equals("JMS_IBM_Report_Pass_Correl_ID")) {
                    this.setReport(this.getReport() | jMSMessage._getJMSIBMPassCorrelIDAsInt() & 0x40);
                    continue;
                }
                if (string.equals("JMS_IBM_Report_Discard_Msg")) {
                    this.setReport(this.getReport() | jMSMessage._getJMSIBMReportDiscardAsInt() & 0x8000000);
                    continue;
                }
                if (!string.equals("JMS_IBM_Last_Msg_In_Group") || !(destination2 instanceof Queue) || !jMSMessage._getJMSIBMLastMsgInGroupAsBool()) continue;
                this.setMessageFlags(this.getMessageFlags() | 0x10);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1059");
            jMSException.setLinkedException((Exception)unsupportedEncodingException);
            if (Trace.isOn) {
                Trace.trace(this, "Write Throwing " + (Object)((Object)jMSException));
            }
            if (Trace.isOn) {
                Trace.trace(this, "Linked Exception " + unsupportedEncodingException);
            }
            throw jMSException;
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
            jMSException.setLinkedException((Exception)mQException);
            if (Trace.isOn) {
                Trace.trace(this, "write Throwing" + (Object)((Object)jMSException));
            }
            if (Trace.isOn) {
                Trace.trace(this, "Linked Exception " + mQException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "writeMQMD");
            }
        }
    }

    public void writeRFH(String string, JMSMessage jMSMessage, boolean bl, int n) throws JMSException, IOException {
        try {
            Object var8_5 = null;
            if (Trace.isOn) {
                Trace.entry(this, "writeRFH");
            }
            String string2 = string + BLANK_STRING15;
            int n2 = string2.length() / 16 * 16;
            String string3 = string2.substring(0, n2);
            this.appendByteArray(MQRFH_STRUC_ID.getBytes());
            this.appendInt(1, this.getEncoding());
            this.appendInt(32 + n2, this.getEncoding());
            this.appendInt(this.getEncoding(), this.getEncoding());
            if (n == 0 || n == -2) {
                n = this.getCharacterSet();
            }
            if (bl) {
                this.appendInt(this.getCharacterSet(), this.getEncoding());
                this.appendByteArray(MQFMT_RF_HEADER_2.getBytes());
            } else {
                this.appendInt(n, this.getEncoding());
                this.appendByteArray("        ".getBytes());
                this.setFormat(MQFMT_RF_HEADER_1);
            }
            this.appendInt(0, this.getEncoding());
            this.appendByteArray(string3.getBytes());
            this.write(jMSMessage, bl, n);
        }
        catch (MQException mQException) {
            JMSException jMSException = new JMSException("MQJMS1000");
            jMSException.setLinkedException((Exception)mQException);
            Trace.trace(this, "writeRFH throwing " + (Object)((Object)jMSException));
            Trace.trace(this, "linked exception " + mQException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "writeRFH");
            }
        }
    }

    private int reverseInt(int n) {
        int n2 = 0;
        n2 = (n >> 24 & 0xFF) << 0 | (n >> 16 & 0xFF) << 8 | (n >> 8 & 0xFF) << 16 | (n >> 0 & 0xFF) << 24;
        return n2;
    }

    protected byte[] buildCacheableRFH(String string, int n, int n2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "buildCacheableRFH");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            String string2 = string + BLANK_STRING15;
            int n3 = string2.length() / 16 * 16;
            String string3 = string2.substring(0, n3);
            int n4 = 1;
            int n5 = 32 + n3;
            int n6 = this.getEncoding();
            int n7 = this.getCharacterSet();
            int n8 = 0;
            String string4 = MQJMSMessage.getCharacterSetString(n7, n6);
            if ((n2 & 0xF) == 2) {
                n4 = this.reverseInt(n4);
                n5 = this.reverseInt(n5);
                n6 = this.reverseInt(n6);
                n7 = this.reverseInt(n7);
                n8 = this.reverseInt(n8);
            }
            dataOutputStream.write(MQRFH_STRUC_ID.getBytes(string4));
            dataOutputStream.writeInt(n4);
            dataOutputStream.writeInt(n5);
            dataOutputStream.writeInt(n6);
            if (n == 0 || n == -2) {
                n = this.getCharacterSet();
            }
            dataOutputStream.writeInt(n7);
            dataOutputStream.write(MQFMT_RF_HEADER_2.getBytes(string4));
            dataOutputStream.writeInt(0);
            dataOutputStream.write(string3.getBytes(string4));
            dataOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("MQJMS1000");
            jMSException.setLinkedException((Exception)iOException);
            Trace.trace(this, "buildCacheableRFH throwing " + (Object)((Object)jMSException));
            Trace.trace(this, "linked exception " + iOException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "buildCacheableRFH");
            }
        }
    }

    private final void insertIntIntoByteArray(int n, byte[] byArray, int n2, int n3) {
        switch (n3 & 0xF) {
            case 0: 
            case 1: {
                byArray[n2 + 0] = (byte)(n >>> 24 & 0xFF);
                byArray[n2 + 1] = (byte)(n >>> 16 & 0xFF);
                byArray[n2 + 2] = (byte)(n >>> 8 & 0xFF);
                byArray[n2 + 3] = (byte)(n >>> 0 & 0xFF);
                break;
            }
            case 2: {
                byArray[n2 + 3] = (byte)(n >>> 24 & 0xFF);
                byArray[n2 + 2] = (byte)(n >>> 16 & 0xFF);
                byArray[n2 + 1] = (byte)(n >>> 8 & 0xFF);
                byArray[n2 + 0] = (byte)(n >>> 0 & 0xFF);
                break;
            }
            default: {
                Trace.trace(1, this, "Invalid encoding in insertIntIntoByteArray: " + (n3 & 0xF));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRFH2(JMSMessage jMSMessage, int n) throws JMSException, IOException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "writeRFH2");
        }
        try {
            int n2;
            int n3;
            byte[] byArray;
            int n4;
            int n5;
            byte[] byArray2;
            int n6;
            int n7;
            byte[] byArray3;
            byte[] byArray4 = jMSMessage._getMcdFolder().getBytes(RFH_CHAR_SET_STRING);
            int n8 = 3 - (byArray4.length - 1) % 4;
            int n9 = byArray4.length + n8;
            byte[] byArray5 = jMSMessage._getJmsFolder(this.persistenceFromMD).getBytes(RFH_CHAR_SET_STRING);
            int n10 = 3 - (byArray5.length - 1) % 4;
            int n11 = byArray5.length + n10;
            int n12 = 44 + n9 + n11;
            String string = jMSMessage._getUsrFolder();
            if (string.equals("<usr></usr>")) {
                byArray3 = null;
                n7 = 0;
                n6 = 0;
            } else {
                byArray3 = string.getBytes(RFH_CHAR_SET_STRING);
                n7 = 3 - (byArray3.length - 1) % 4;
                n6 = byArray3.length + n7;
                n12 += n6;
                n12 += 4;
            }
            string = jMSMessage._getPscFolder();
            if (string.equals("<psc></psc>")) {
                byArray2 = null;
                n5 = 0;
                n4 = 0;
            } else {
                byArray2 = jMSMessage._getPscFolder().getBytes(RFH_CHAR_SET_STRING);
                n5 = 3 - (byArray2.length - 1) % 4;
                n4 = byArray2.length + n5;
                n12 += n4;
                n12 += 4;
            }
            string = jMSMessage._getMQExtFolder();
            if (string == null) {
                byArray = null;
                n3 = 0;
                n2 = 0;
            } else {
                byArray = jMSMessage._getMQExtFolder().getBytes(RFH_CHAR_SET_STRING);
                n3 = 3 - (byArray.length - 1) % 4;
                n2 = byArray.length + n3;
                n12 += n2;
                n12 += 4;
            }
            if (this.cachedFixedRFH2 == null) {
                this.cachedRFH2Length = n12;
                this.cachedRFH2Encoding = this.getEncoding();
                this.cachedRFH2CharSet = n;
                this.cachedRFH2Format = this.getFormat();
                int n13 = 0;
                this.cachedFixedRFH2 = new byte[36];
                this.insertStrIntoByteArray(MQRFH_STRUC_ID, 4, this.cachedFixedRFH2, n13, this.getCharacterSet(), this.cachedRFH2Encoding);
                this.insertIntIntoByteArray(2, this.cachedFixedRFH2, n13 += MQRFH_STRUC_ID.length(), this.cachedRFH2Encoding);
                this.insertIntIntoByteArray(this.cachedRFH2Length, this.cachedFixedRFH2, n13 += 4, this.cachedRFH2Encoding);
                this.insertIntIntoByteArray(this.cachedRFH2Encoding, this.cachedFixedRFH2, n13 += 4, this.cachedRFH2Encoding);
                this.insertIntIntoByteArray(this.cachedRFH2CharSet, this.cachedFixedRFH2, n13 += 4, this.cachedRFH2Encoding);
                this.insertStrIntoByteArray(this.cachedRFH2Format, 8, this.cachedFixedRFH2, n13 += 4, this.getCharacterSet(), this.cachedRFH2Encoding);
                this.insertIntIntoByteArray(0, this.cachedFixedRFH2, n13 += 8, this.cachedRFH2Encoding);
                this.insertIntIntoByteArray(1208, this.cachedFixedRFH2, n13 += 4, this.cachedRFH2Encoding);
            } else {
                boolean bl = false;
                if (this.cachedRFH2Encoding != this.getEncoding()) {
                    bl = true;
                    this.cachedRFH2Encoding = this.getEncoding();
                    this.insertIntIntoByteArray(this.cachedRFH2Encoding, this.cachedFixedRFH2, 12, this.cachedRFH2Encoding);
                    this.insertIntIntoByteArray(1208, this.cachedFixedRFH2, 32, this.cachedRFH2Encoding);
                    this.insertIntIntoByteArray(2, this.cachedFixedRFH2, 4, this.cachedRFH2Encoding);
                }
                if (bl || this.cachedRFH2Length != n12) {
                    this.cachedRFH2Length = n12;
                    this.insertIntIntoByteArray(this.cachedRFH2Length, this.cachedFixedRFH2, 8, this.cachedRFH2Encoding);
                }
                if (bl || this.cachedRFH2CharSet != n) {
                    this.cachedRFH2CharSet = n;
                    this.insertIntIntoByteArray(this.cachedRFH2CharSet, this.cachedFixedRFH2, 16, this.cachedRFH2Encoding);
                }
                if (!this.cachedRFH2Format.equals(this.getFormat())) {
                    this.cachedRFH2Format = this.getFormat();
                    this.insertStrIntoByteArray(this.cachedRFH2Format, 8, this.cachedFixedRFH2, 20, this.getCharacterSet(), this.cachedRFH2Encoding);
                }
            }
            this.setFormat(MQFMT_RF_HEADER_2);
            this.appendByteArray(this.cachedFixedRFH2);
            if (byArray2 != null) {
                this.appendInt(n4, this.getEncoding());
                this.appendByteArray(byArray2);
                this.appendByteArray(SPACES, 0, n5);
            }
            this.appendInt(n9, this.getEncoding());
            this.appendByteArray(byArray4);
            this.appendByteArray(SPACES, 0, n8);
            this.appendInt(n11, this.getEncoding());
            this.appendByteArray(byArray5);
            this.appendByteArray(SPACES, 0, n10);
            if (byArray != null) {
                this.appendInt(n2, this.getEncoding());
                this.appendByteArray(byArray);
                this.appendByteArray(SPACES, 0, n3);
            }
            if (byArray3 != null) {
                this.appendInt(n6, this.getEncoding());
                this.appendByteArray(byArray3);
                this.appendByteArray(SPACES, 0, n7);
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "writeRFH2");
            }
        }
    }

    private void insertStrIntoByteArray(String string, int n, byte[] byArray, int n2, int n3, int n4) throws JMSException {
        try {
            byte[] byArray2;
            String string2 = MQJMSMessage.getCharacterSetString(n3, n4);
            int n5 = 0;
            if (string != null) {
                byArray2 = string.getBytes(string2);
                System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                n5 = byArray2.length;
            } else {
                n5 = 0;
            }
            if (n > n5) {
                byArray2 = " ".getBytes(string2);
                for (int i = n5; i < n; ++i) {
                    byArray[n2 + i] = byArray2[0];
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
            jMSException.setLinkedException((Exception)unsupportedEncodingException);
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
            }
            if (Trace.isOn) {
                Trace.trace(this, "linked exception " + unsupportedEncodingException);
            }
            throw jMSException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getCCSID(String string) {
        int n;
        try {
            Integer n2;
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "getCCSID");
            }
            if ((n2 = (Integer)ccsidTable.get(string)) != null) {
                n = n2;
            } else {
                if (string.startsWith("Cp")) {
                    string = string.substring(2);
                }
                if ((n = Integer.parseInt(string)) < 0) {
                    int n3 = 0;
                    return n3;
                }
            }
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Mapped " + string + " -> " + n);
            }
            int n4 = n;
            return n4;
        }
        catch (NumberFormatException numberFormatException) {
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "got a number format exception, returning 0");
            }
            n = 0;
            return n;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "getCCSID");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistenceFromMD(boolean bl) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setPersistenceFromMD");
            }
            this.persistenceFromMD = bl;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setPersistenceFromMD");
            }
        }
    }

    static {
        ccsidTable.put("JIS", new Integer(2022));
        ccsidTable.put("EUCJIS", new Integer(954));
        ccsidTable.put("SJIS", new Integer(932));
        ccsidTable.put("KSC5601", new Integer(5601));
        ccsidTable.put(RFH_CHAR_SET_STRING, new Integer(1208));
        ccsidTable.put("UnicodeLittle", new Integer(1200));
        ccsidTable.put("UnicodeBig", new Integer(1200));
        ccsidTable.put("GB18030", new Integer(5488));
        ccsidTable.put("ISO8859_1", new Integer(819));
        ccsidTable.put("ISO8859-1", new Integer(819));
    }
}

