/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSDestination;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.naming.RefAddr;
import javax.naming.Reference;

public abstract class MQDestination
implements Destination,
JMSDestination,
Serializable {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQDestination.java, jms, j600, j600-101-060328 1.67.1.1 05/05/25 15:47:43";
    private static final String CLASSNAME = "MQDestination";
    private static final int DEF_EXPIRY = -2;
    private static final int DEF_PRIORITY = -2;
    private static final int DEF_PERSISTENCE = -2;
    private static final int DEF_CCSID = 1208;
    private static final int DEF_TARGET = 0;
    private static final int DEF_ENCODING = 273;
    private int version = 6;
    private String description = null;
    private long expiry = -2L;
    private int priority = -2;
    private int persistence = -2;
    private int CCSID = 1208;
    private int targetClient = 0;
    private int encoding = 273;
    private int failIfQuiesce = 1;
    private Properties userProperties = null;
    String cachedDNVs = null;
    String cachedUNVs = null;
    private Boolean supportsNPHigh = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFailIfQuiesce() {
        if (Trace.isOn) {
            try {
                Trace.entry(this, "getFailIfQuiesce");
                int n = this.failIfQuiesce;
                return n;
            }
            finally {
                Trace.exit(this, "getFailIfQuiesce");
            }
        }
        return this.failIfQuiesce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFailIfQuiesce(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setFailIfQuiesce");
            }
            switch (n) {
                case 0: 
                case 1: {
                    this.failIfQuiesce = n;
                    return;
                }
                default: {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "failIfQuiesce", String.valueOf(n));
                    throw jMSException;
                }
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setFailIfQuiesce");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVersion() {
        if (Trace.isOn) {
            try {
                Trace.entry(this, "getVersion");
                int n = this.version;
                return n;
            }
            finally {
                Trace.exit(this, "getVersion");
            }
        }
        return this.version;
    }

    public void setVersion(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setVersion");
            }
            JMSException jMSException = new JMSException("version can't be changed");
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        catch (Throwable throwable) {
            if (Trace.isOn) {
                Trace.exit(this, "setVersion");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() {
        if (Trace.isOn) {
            try {
                Trace.entry(this, "getDescription");
                String string = this.description;
                return string;
            }
            finally {
                Trace.exit(this, "getDescription");
            }
        }
        return this.description;
    }

    public void setDescription(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setDescription");
        }
        this.description = string;
        if (Trace.isOn) {
            Trace.exit(this, "setDescription");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPriority() {
        if (Trace.isOn) {
            try {
                Trace.entry(this, "getPriority");
                int n = this.priority;
                return n;
            }
            finally {
                Trace.exit(this, "getPriority");
            }
        }
        return this.priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(int n) throws JMSException {
        block7: {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setPriority");
                }
                if (n == -2 || n == -1 || n >= 0 && n <= 9) {
                    this.priority = n;
                    this.cachedDNVs = null;
                    break block7;
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "priority", String.valueOf(n));
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "setPriority");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExpiry() {
        if (Trace.isOn) {
            try {
                Trace.entry(this, "getExpiry");
                long l = this.expiry;
                return l;
            }
            finally {
                Trace.exit(this, "getExpiry");
            }
        }
        return this.expiry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpiry(long l) throws JMSException {
        block7: {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setExpiry");
                }
                if (l > 0L || l == -2L || l == 0L) {
                    this.expiry = l;
                    this.cachedDNVs = null;
                    break block7;
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "expiry", String.valueOf(l));
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "setExpiry");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPersistence() {
        if (Trace.isOn) {
            try {
                Trace.entry(this, "getPersistence");
                int n = this.persistence;
                return n;
            }
            finally {
                Trace.exit(this, "getPersistence");
            }
        }
        return this.persistence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPersistence(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setPersistence");
            }
            switch (n) {
                case -2: 
                case -1: 
                case 1: 
                case 2: 
                case 3: {
                    this.persistence = n;
                    this.cachedDNVs = null;
                    return;
                }
                default: {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "persistence", String.valueOf(n));
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                    throw jMSException;
                }
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setPersistence");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTargetClient() {
        if (Trace.isOn) {
            try {
                Trace.entry(this, "getTargetClient");
                int n = this.targetClient;
                return n;
            }
            finally {
                Trace.exit(this, "getTargetClient");
            }
        }
        return this.targetClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTargetClient(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setTargetClient");
            }
            switch (n) {
                case 0: 
                case 1: {
                    this.targetClient = n;
                    this.cachedDNVs = null;
                    return;
                }
                default: {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "targetClient", String.valueOf(n));
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                    throw jMSException;
                }
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setTargetClient");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCCSID() {
        if (Trace.isOn) {
            try {
                Trace.entry(this, "getCCSID");
                int n = this.CCSID;
                return n;
            }
            finally {
                Trace.exit(this, "getCCSID");
            }
        }
        return this.CCSID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCCSID(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setCCSID");
            }
            if (n < 0) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "CCSID", String.valueOf(n));
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
            this.CCSID = n;
            this.cachedDNVs = null;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setCCSID");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEncoding() {
        if (Trace.isOn) {
            try {
                Trace.entry(this, "getEncoding");
                int n = this.encoding;
                return n;
            }
            finally {
                Trace.exit(this, "getEncoding");
            }
        }
        return this.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEncoding(int n) throws JMSException {
        try {
            int n2;
            if (Trace.isOn) {
                Trace.entry(this, "setEncoding");
            }
            if ((n & ~(n2 = 819)) != 0) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "encoding", Integer.toHexString(n));
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
            this.encoding = n;
            this.cachedDNVs = null;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setEncoding");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "getProperty", string);
        }
        if (string == null) {
            return null;
        }
        try {
            String string2;
            if (this.userProperties == null) {
                String string3 = null;
                return string3;
            }
            String string4 = string2 = this.userProperties.getProperty(string);
            return string4;
        }
        finally {
            Trace.exit(this, "getProperty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String string, String string2) {
        if (Trace.isOn) {
            Trace.entry(this, "setProperty");
        }
        try {
            if (string != null && string2 != null) {
                if (this.userProperties == null) {
                    this.userProperties = new Properties();
                }
                this.userProperties.put(string, string2);
                this.cachedUNVs = null;
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setProperty");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        try {
            boolean bl;
            if (Trace.isOn) {
                Trace.entry(this, "equals");
            }
            if (object == null) {
                bl = false;
            } else if (object instanceof MQDestination) {
                MQDestination mQDestination = (MQDestination)object;
                bl = this.version == mQDestination.version && this.twoStringsEqual(this.description, mQDestination.description) && this.expiry == mQDestination.expiry && this.priority == mQDestination.priority && this.persistence == mQDestination.persistence && this.CCSID == mQDestination.CCSID && this.targetClient == mQDestination.targetClient && this.encoding == mQDestination.encoding && this.failIfQuiesce == mQDestination.failIfQuiesce;
            } else {
                bl = false;
            }
            if (Trace.isOn) {
                Trace.trace(this, "equals - result is " + bl);
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "equals");
            }
        }
    }

    public int hashCode() {
        int n = this.version ^ (int)(this.expiry & 0xFFFFFFFFFFFFFFFFL) ^ this.priority << 4 ^ this.persistence << 8 ^ this.CCSID ^ this.targetClient << 12 ^ this.encoding << 16;
        if (this.description != null) {
            n ^= this.description.hashCode();
        }
        return n;
    }

    public String getStringFromDestination() {
        if (Trace.isOn) {
            Trace.entry(this, "getStringFromDestination");
        }
        if (this instanceof MQQueue) {
            if (Trace.isOn) {
                Trace.exit(this, "getStringFromDestination");
            }
            return ((MQQueue)this).getQueueName();
        }
        if (this instanceof MQTopic) {
            if (Trace.isOn) {
                Trace.exit(this, "getStringFromDestination");
            }
            return ((MQTopic)this).getTopicName();
        }
        if (Trace.isOn) {
            Trace.exit(this, "getStringFromDestination");
        }
        return "";
    }

    static Destination createDestination(String string) {
        try {
            MQDestination mQDestination = null;
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "createDestination");
            }
            if (string != null) {
                if (string.startsWith("queue:")) {
                    mQDestination = new MQQueue(string);
                } else if (string.startsWith("topic")) {
                    mQDestination = new MQTopic(string);
                } else {
                    try {
                        Logger.log(new LogMessage(2, "MQJMS1027", string));
                    }
                    catch (LogException logException) {
                        System.err.println("failed to log error because of " + logException);
                    }
                    String string2 = ConfigEnvironment.getErrorMessage("MQJMS0003");
                    if (Trace.isOn) {
                        Trace.trace(CLASSNAME, "A RuntimeException is about to be thrown with the message: " + string2);
                        Trace.exit(CLASSNAME, "createDestination");
                    }
                    throw new RuntimeException(string2 + ": " + string);
                }
            }
            MQQueue mQQueue = mQDestination;
            return mQQueue;
        }
        catch (JMSException jMSException) {
            RuntimeException runtimeException = new RuntimeException(jMSException.toString());
            if (Trace.isOn) {
                Trace.trace(CLASSNAME, "Throwing " + runtimeException);
            }
            throw runtimeException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLASSNAME, "createDestination");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean twoStringsEqual(String string, String string2) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "twoStringsEqual");
            }
            boolean bl = MQConnectionFactory.twoStringsEqual(string, string2);
            return bl;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "twoStringsEqual");
            }
        }
    }

    String getDestNVs() {
        if (this.cachedDNVs == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.expiry != -2L) {
                stringBuffer.append("&expiry=").append(this.expiry);
            }
            if (this.priority != -2) {
                stringBuffer.append("&priority=").append(this.priority);
            }
            if (this.persistence != -2) {
                stringBuffer.append("&persistence=").append(this.persistence);
            }
            if (this.CCSID != 1208) {
                stringBuffer.append("&CCSID=").append(this.CCSID);
            }
            if (this.targetClient != 0) {
                stringBuffer.append("&targetClient=").append(this.targetClient);
            }
            if (this.encoding != 273) {
                stringBuffer.append("&encoding=").append(this.encoding);
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.deleteCharAt(0);
            }
            this.cachedDNVs = stringBuffer.toString();
        }
        return this.cachedDNVs;
    }

    String getUserNVs() {
        if (this.cachedUNVs == null) {
            if (this.userProperties == null) {
                this.cachedUNVs = "";
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                Enumeration<Object> enumeration = this.userProperties.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (string == null) continue;
                    try {
                        String string2;
                        block12: {
                            block11: {
                                string2 = this.userProperties.getProperty(string);
                                try {
                                    string = URLEncoder.encode(string, "UTF8");
                                }
                                catch (NoSuchMethodError noSuchMethodError) {
                                    if (!Trace.isOn) break block11;
                                    Trace.trace(this, "URLEncoder was used with 1.3.1 jvm this is not supported");
                                }
                            }
                            if (string.equals("ibmxml") || string2 == null) continue;
                            try {
                                string2 = URLEncoder.encode(string2, "UTF8");
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                if (!Trace.isOn) break block12;
                                Trace.trace(this, "URLEncoder was used with 1.3.1 jvm this is not supported");
                            }
                        }
                        stringBuffer.append('&').append(string).append('=').append(string2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.deleteCharAt(0);
                }
                this.cachedUNVs = stringBuffer.toString();
            }
        }
        return this.cachedUNVs;
    }

    Properties getPropertiesFromURI(String string) throws JMSException {
        Properties properties = null;
        String string2 = null;
        try {
            int n;
            if (Trace.isOn) {
                Trace.entry(this, "getPropertiesFromURI");
            }
            if ((n = string.indexOf(63)) == -1) {
                string2 = string;
            } else if (string.length() > n + 1) {
                string2 = string.substring(n + 1);
            }
            while (string2 != null) {
                String string3;
                int n2 = string2.indexOf(38);
                if (n2 != -1) {
                    string3 = string2.substring(0, n2);
                    string2 = string2.substring(n2 + 1);
                } else {
                    string3 = string2;
                    string2 = null;
                }
                int n3 = string3.indexOf(61);
                if (n3 == -1) {
                    String string4 = "MQJMS0003";
                    String string5 = ConfigEnvironment.getErrorMessage(string4);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string5, string4);
                    throw invalidDestinationException;
                }
                String string6 = string3.substring(0, n3);
                String string7 = string3.substring(n3 + 1);
                try {
                    string6 = URLDecoder.decode(string6, "UTF8");
                    string7 = URLDecoder.decode(string7, "UTF8");
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    if (Trace.isOn) {
                        Trace.trace(this, "URLDecoder was used with 1.3.1 jvm this is not supported");
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    String string8 = "MQJMS0003";
                    String string9 = ConfigEnvironment.getErrorMessage(string8);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string9, string8);
                    throw invalidDestinationException;
                }
                if (properties == null) {
                    properties = new Properties();
                }
                properties.put(string6, string7);
            }
            Properties properties2 = properties;
            return properties2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getPropertiesFromURI");
            }
        }
    }

    void setFromProperties(Properties properties) throws JMSException {
        try {
            String string;
            if (Trace.isOn) {
                Trace.entry(this, "setFromProperties");
            }
            if ((string = (String)properties.remove("expiry")) != null) {
                this.setExpiry(Integer.parseInt(string));
            }
            if ((string = (String)properties.remove("priority")) != null) {
                this.setPriority(Integer.parseInt(string));
            }
            if ((string = (String)properties.remove("persistence")) != null) {
                this.setPersistence(Integer.parseInt(string));
            }
            if ((string = (String)properties.remove("CCSID")) != null) {
                this.setCCSID(Integer.parseInt(string));
            }
            if ((string = (String)properties.remove("targetClient")) != null) {
                this.setTargetClient(Integer.parseInt(string));
            }
            if ((string = (String)properties.remove("encoding")) != null) {
                this.setEncoding(Integer.parseInt(string));
            }
            if (properties.size() > 0) {
                this.userProperties = properties;
            }
            this.cachedUNVs = null;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        catch (NumberFormatException numberFormatException) {
            String string = "MQJMS0003";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string2, string);
            invalidDestinationException.setLinkedException((Exception)numberFormatException);
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + invalidDestinationException);
            }
            throw invalidDestinationException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setFromProperties");
            }
        }
    }

    void setCommonFromReference(Reference reference) throws JMSException {
        try {
            RefAddr refAddr;
            if (Trace.isOn) {
                Trace.entry(this, "setCommonFromReference");
            }
            if ((refAddr = reference.get("VER")) != null) {
                long l = Long.parseLong((String)refAddr.getContent());
            }
            if ((refAddr = reference.get("DESC")) != null) {
                this.setDescription((String)refAddr.getContent());
            }
            if ((refAddr = reference.get("CCS")) != null) {
                this.setCCSID(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get("EXP")) != null) {
                this.setExpiry(Long.parseLong((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get("PRI")) != null) {
                this.setPriority(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get("PER")) != null) {
                this.setPersistence(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get("TC")) != null) {
                this.setTargetClient(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get("ENC")) != null) {
                this.setEncoding(Integer.parseInt((String)refAddr.getContent()));
            }
            if ((refAddr = reference.get("FIQ")) != null) {
                this.setFailIfQuiesce(Integer.parseInt((String)refAddr.getContent()));
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setCommonFromReference");
            }
        }
    }

    boolean isNPHighCheckDone() {
        return this.supportsNPHigh != null;
    }

    boolean getNPHighSupported() {
        return this.supportsNPHigh != null && this.supportsNPHigh != false;
    }

    void setNPHighSupported(boolean bl) {
        this.supportsNPHigh = new Boolean(bl);
    }

    MQDestination() {
    }
}

