/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.ConnectionBrowser;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.MQMessageReference;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQQueueConnection;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.MessageReference;
import com.ibm.mq.jms.MessageReferenceHandler;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.ConnectionConsumer;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;

class MQConnectionConsumer
implements ConnectionConsumer {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2004 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQConnectionConsumer.java, jms, j600, j600-101-060328 1.43.1.1 05/05/25 15:56:54";
    private String name;
    private MQConnection conn;
    private MQDestination dest;
    private ConnectionBrowser browser;
    private MQConnectionConsumerMRH mrh;

    MQConnectionConsumer(MQConnection mQConnection, MQDestination mQDestination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        this(mQConnection, mQDestination, string, serverSessionPool, n, null);
    }

    MQConnectionConsumer(MQConnection mQConnection, MQDestination mQDestination, String string, ServerSessionPool serverSessionPool, int n, String string2) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "Constructor", "name = '" + (string2 == null ? "null" : string2) + "', maxMessageCount = " + n);
            }
            try {
                if (mQDestination == null) {
                    String string3 = "MQJMS0003";
                    String string4 = ConfigEnvironment.getErrorMessage(string3);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string4, string3);
                    throw invalidDestinationException;
                }
                if (!(mQConnection instanceof MQQueueConnection && mQDestination instanceof MQQueue || mQConnection instanceof MQTopicConnection && mQDestination instanceof MQTopic || mQConnection instanceof MQConnection && mQDestination instanceof MQQueue || mQConnection instanceof MQConnection && mQDestination instanceof MQTopic)) {
                    throw ConfigEnvironment.newException("MQJMS1077");
                }
                this.conn = mQConnection;
                this.dest = mQDestination;
                if (serverSessionPool == null) {
                    throw ConfigEnvironment.newException("MQJMS1084");
                }
                if (n <= 0) {
                    throw ConfigEnvironment.newException("MQJMS1083");
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Sanity checks failed");
                    Trace.exception(this, "Constructor", (Throwable)jMSException);
                }
                throw jMSException;
            }
            this.name = string2;
            this.mrh = new MQConnectionConsumerMRH(serverSessionPool, n);
            if (this.dest instanceof MQQueue) {
                this.browser = this.conn.createConnectionBrowser((MQQueue)this.dest, string, (MessageReferenceHandler)this.mrh, 0);
            } else if (this.dest instanceof MQTopic) {
                this.browser = string2 == null ? this.conn.createConnectionBrowser((MQTopic)this.dest, string, (MessageReferenceHandler)this.mrh, 0) : this.conn.createDurableConnectionBrowser((MQTopic)this.dest, string2, string, this.mrh, 0, false);
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "Constructor");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        JMSException jMSException = null;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "close");
            }
            try {
                this.browser.close();
            }
            catch (JMSException jMSException2) {
                if (Trace.isOn) {
                    Trace.trace(this, "Encountered problem closing browser: " + jMSException2.getMessage());
                }
                jMSException = jMSException2;
            }
            this.mrh.deliverNow();
            if (Trace.isOn && null != this.mrh.getException()) {
                Trace.trace(this, "endDeliver encountered problems: " + this.mrh.getException().getMessage());
            }
            if (null != jMSException) {
                throw jMSException;
            }
            return;
        }
        catch (JMSException jMSException3) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via Exception");
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "close");
            }
        }
    }

    public ServerSessionPool getServerSessionPool() {
        return this.mrh.getServerSessionPool();
    }

    class MQConnectionConsumerMRH
    implements MessageReferenceHandler {
        private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2000, 2005. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private static final String sccsid = "jms/com/ibm/mq/jms/MQConnectionConsumer.java, jms, j600, j600-101-060328 05/05/25 15:56:54 @(#) 1.43.1.1";
        private ServerSessionPool sessionPool;
        private int maxMessages;
        private Vector references;
        private JMSException jmsException;

        public MQConnectionConsumerMRH(ServerSessionPool serverSessionPool, int n) {
            this.sessionPool = serverSessionPool;
            this.maxMessages = n;
            this.references = new Vector(n);
        }

        public void endDeliver() {
            this.deliverNow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessageReference(MessageReference messageReference) {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "handleMessageReference");
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Adding messageReference to internal vector");
                }
                this.references.addElement(messageReference);
                int n = this.references.size();
                if (n >= this.maxMessages) {
                    if (Trace.isOn) {
                        Trace.trace(this, "batch complete. Calling endDeliver()  to process messageReference batch");
                    }
                    this.endDeliver();
                }
                return;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "handleMessageReference");
                }
            }
        }

        ServerSessionPool getServerSessionPool() {
            return this.sessionPool;
        }

        private void setException(JMSException jMSException) {
            this.jmsException = jMSException;
        }

        JMSException getException() {
            return this.jmsException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void deliverNow() {
            try {
                int n;
                if (Trace.isOn) {
                    Trace.entry(this, "deliverNow");
                    if (null == this.references) {
                        Trace.trace(this, "references vector is null!");
                        throw new JMSException("null references array");
                    }
                    Trace.trace(this, "references Vector contains " + this.references.size() + " messageReferences");
                }
                if ((n = this.references.size()) > 0) {
                    if (Trace.isOn) {
                        Trace.trace(this, "We have messages to deliver.");
                    }
                    ServerSession serverSession = null;
                    Session session = null;
                    try {
                        if (Trace.isOn) {
                            Trace.trace(this, "Getting ServerSession");
                        }
                        if ((serverSession = this.sessionPool.getServerSession()) != null) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Getting JMSSession");
                            }
                            session = serverSession.getSession();
                        }
                    }
                    catch (JMSException jMSException) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Exception thrown trying to get session from pool");
                            Trace.exception(this, "endDeliver", (Throwable)jMSException);
                        }
                        throw jMSException;
                    }
                    MQSession mQSession = null;
                    if (session == null || !(session instanceof MQSession)) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Alien session from pool");
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1078");
                        throw jMSException;
                    }
                    mQSession = (MQSession)session;
                    if (serverSession != null && mQSession != null) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Got good Session and ServerSesssion.");
                            Trace.trace(this, "About to deliver " + n + " messages");
                        }
                        Vector vector = null;
                        vector = this.references;
                        this.references = new Vector(this.maxMessages);
                        try {
                            mQSession.deliver(vector);
                            serverSession.start();
                        }
                        catch (JMSException jMSException) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Exception thrown trying to deliver messages to session");
                                Trace.trace(this, "Returning messages to references vector");
                            }
                            Enumeration enumeration = vector.elements();
                            while (enumeration.hasMoreElements()) {
                                MQMessageReference mQMessageReference = (MQMessageReference)enumeration.nextElement();
                                this.references.addElement(mQMessageReference);
                            }
                            throw jMSException;
                        }
                    }
                }
                return;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, " Exception catch and held:" + jMSException.getMessage());
                    Trace.exception(this, "deliverNow", (Throwable)jMSException);
                }
                this.setException(jMSException);
                return;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "deliverNow");
                }
            }
        }
    }
}

