/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.services.Trace;
import java.util.Hashtable;
import javax.jms.JMSException;

public class MQBrokerSubscriptionList {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2001, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQBrokerSubscriptionList.java, jms, j600, j600-101-060328 1.7.1.1 05/05/25 15:45:58";
    private static String CLSNAME = "MQBrokerSubscriptionList";
    private static Hashtable openSubscriptions;

    public MQBrokerSubscriptionList() {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "constructor");
        }
        if (openSubscriptions == null) {
            if (Trace.isOn) {
                Trace.trace(CLSNAME, "creating new Hashtable");
            }
            openSubscriptions = new Hashtable();
        }
        if (Trace.isOn) {
            Trace.exit(CLSNAME, "constructor");
        }
    }

    public synchronized boolean getSubscription(String string, MQSession mQSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "getSubscription");
        }
        try {
            if (openSubscriptions.containsKey(string)) {
                JMSException jMSException = new JMSException("MQJMS3023");
                if (Trace.isOn) {
                    Trace.trace(CLSNAME, "subscription " + string + " already in use");
                    Trace.exception(CLSNAME, "getSubscription", (Throwable)jMSException);
                }
                throw jMSException;
            }
            openSubscriptions.put(string, mQSession);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            if (Trace.isOn) {
                Trace.exception(CLSNAME, "getSubscription", (Throwable)exception);
            }
            throw (JMSException)((Object)exception);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLSNAME, "getSubscription");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean removeSubscription(String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "removeSubscription");
            Trace.trace(CLSNAME, "removing subscription '" + string + "'");
        }
        try {
            if (!openSubscriptions.containsKey(string)) {
                JMSException jMSException = new JMSException("MQJMS3051");
                if (Trace.isOn) {
                    Trace.exception(CLSNAME, "removeSubscription", (Throwable)jMSException);
                }
                throw jMSException;
            }
            openSubscriptions.remove(string);
            boolean bl = true;
            return bl;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(CLSNAME, "removeSubscription");
            }
        }
    }
}

