/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthub2.impl.client.BaseConfig;
import com.ibm.disthub2.impl.client.DebugObject;
import com.ibm.disthub2.impl.client.SessionConfig;
import com.ibm.disthub2.impl.formats.Framing;
import com.ibm.disthub2.impl.formats.MessageEncrypter;
import com.ibm.disthub2.impl.formats.MessageHandle;
import com.ibm.disthub2.impl.formats.SchemaRegistry;
import com.ibm.disthub2.impl.multicast.ControlChannelListener;
import com.ibm.disthub2.impl.multicast.MulticastTopic;
import com.ibm.disthub2.impl.multicast.PeerId;
import com.ibm.disthub2.impl.multicast.client.ClientBridge;
import com.ibm.disthub2.impl.multicast.client.MulticastException;
import com.ibm.disthub2.impl.multicast.client.MulticastMessageReceiver;
import com.ibm.disthub2.impl.security.IntegrityCompromisedException;
import com.ibm.disthub2.impl.security.MessageProtection;
import com.ibm.disthub2.impl.security.Qop;
import com.ibm.disthub2.impl.security.SecurityContext;
import com.ibm.disthub2.impl.util.FastHashtable;
import com.ibm.disthub2.impl.util.FastVector;
import com.ibm.disthub2.impl.util.FeatureSet;
import com.ibm.disthub2.impl.util.Hex;
import com.ibm.disthub2.impl.util.TopicHandler;
import com.ibm.disthub2.spi.ClientExceptionConstants;
import com.ibm.disthub2.spi.ClientLogConstants;
import com.ibm.disthub2.spi.ExceptionBuilder;
import com.ibm.mq.jms.ConnectionImpl;
import com.ibm.mq.jms.MulticastHeartbeatTimeoutException;
import com.ibm.mq.jms.MulticastPacketLossException;
import com.ibm.mq.jms.SubscriptionInfoImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;

public class ConnectionMulticastSupport
implements MulticastMessageReceiver,
ClientLogConstants,
ClientExceptionConstants {
    private static final DebugObject debug = new DebugObject("ConnectionMulticastSupport");
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/ConnectionMulticastSupport.java, disthub, j600, j600-101-060328 1.16.1.5 05/07/27 08:12:40";
    private ClientBridge bridge;
    private PeerId peerId = null;
    private ConnectionImpl connection;
    private FastHashtable multicastTopics;
    private FastHashtable topicToSusbcriptions;
    private FastHashtable partitionTopics;
    private InetAddress brokerMulticastInterface;

    public ConnectionMulticastSupport(ConnectionImpl connectionImpl) throws IOException {
        this.connection = connectionImpl;
        this.multicastTopics = new FastHashtable();
        this.topicToSusbcriptions = new FastHashtable();
        this.partitionTopics = new FastHashtable();
        this.setClientConfigParameters(connectionImpl.getFeatureSet());
        this.bridge = ClientBridge.getInstance((Properties)connectionImpl.getSessionConfig().getMulticastProperties());
    }

    public void setClientConfigParameters(FeatureSet featureSet) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"setClientConfigParameters");
        }
        if (this.bridge == null) {
            String string = featureSet.get("MULTICAST", "MULTICAST_DATA_PORT");
            if (string != null) {
                SessionConfig.MULTICAST_DATA_PORT = Integer.parseInt(string);
            }
            if ((string = featureSet.get("MULTICAST", "MULTICAST_BACKOFF_TIME_MILLIS")) != null) {
                SessionConfig.MULTICAST_BACKOFF_TIME_MILLIS = Integer.parseInt(string);
            }
            if ((string = featureSet.get("MULTICAST", "MULTICAST_NACK_CHECK_PERIOD_MILLIS")) != null) {
                SessionConfig.MULTICAST_NACK_CHECK_PERIOD_MILLIS = Integer.parseInt(string);
            }
            if ((string = featureSet.get("MULTICAST", "MULTICAST_PACKET_BUFFERS")) != null) {
                SessionConfig.MULTICAST_PACKET_BUFFERS = Integer.parseInt(string);
            }
            if ((string = featureSet.get("MULTICAST", "MULTICAST_SOCKET_BUFFER_SIZE_KBYTE")) != null) {
                SessionConfig.MULTICAST_SOCKET_BUFFER_SIZE_KBYTE = Integer.parseInt(string);
            }
            if ((string = featureSet.get("MULTICAST", "MULTICAST_MAX_MEMORY_ALLOWED_K_BYTES")) != null) {
                SessionConfig.MULTICAST_MAX_MEMORY_ALLOWED_K_BYTES = Integer.parseInt(string);
            }
            if ((string = featureSet.get("MULTICAST", "MULTICAST_PROTOCOL_TYPE")) != null) {
                this.connection.getSessionConfig().MULTICAST_PROTOCOL_TYPE = string;
            }
            if (this.connection.ipv6Connection()) {
                try {
                    this.brokerMulticastInterface = Inet6Address.getByName(featureSet.get("MULTICAST", "MULTICAST_MULTICAST_IPV6INTERFACE"));
                }
                catch (UnknownHostException unknownHostException) {
                    throw new IOException(unknownHostException.toString());
                }
            }
            try {
                this.brokerMulticastInterface = InetAddress.getByName(featureSet.get("MULTICAST", "MULTICAST_MULTICAST_INTERFACE"));
            }
            catch (UnknownHostException unknownHostException) {
                throw new IOException(unknownHostException.toString());
            }
        }
        if (debug.debugIt(16)) {
            debug.debug(-153415734321212L, (Object)"setClientConfigParameters", (Object)("MULTICAST_DATA_PORT=" + SessionConfig.MULTICAST_DATA_PORT + "MULTICAST_BACKOFF_TIME_MILLIS=" + SessionConfig.MULTICAST_BACKOFF_TIME_MILLIS + "MULTICAST_NACK_CHECK_PERIOD_MILLIS=" + SessionConfig.MULTICAST_NACK_CHECK_PERIOD_MILLIS + "MULTICAST_PACKET_BUFFERS=" + SessionConfig.MULTICAST_PACKET_BUFFERS + "MULTICAST_SOCKET_BUFFER_SIZE_KBYTE=" + SessionConfig.MULTICAST_SOCKET_BUFFER_SIZE_KBYTE + "brokerMulticastInterface=" + featureSet.get("MULTICAST", "MULTICAST_MULTICAST_INTERFACE") + "brokerMulticastInterface=" + featureSet.get("MULTICAST", "MULTICAST_MULTICAST_INTERFACE") + "MULTICAST_PROTOCOL_TYPE=" + this.connection.getSessionConfig().MULTICAST_PROTOCOL_TYPE + "MULTICAST_MAX_MEMORY_ALLOWED_K_BYTES=" + SessionConfig.MULTICAST_MAX_MEMORY_ALLOWED_K_BYTES));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"setClientConfigParameters");
        }
    }

    public void registerTopics(SubscriptionInfoImpl subscriptionInfoImpl) {
        if (subscriptionInfoImpl.multicastTopics != null) {
            Enumeration enumeration = subscriptionInfoImpl.multicastTopics.elements();
            while (enumeration.hasMoreElements()) {
                MulticastTopic multicastTopic = (MulticastTopic)enumeration.nextElement();
                this.registerTopic(subscriptionInfoImpl, multicastTopic);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTopic(SubscriptionInfoImpl subscriptionInfoImpl, MulticastTopic multicastTopic) {
        FastVector fastVector;
        FastVector fastVector2 = null;
        if (this.topicToSusbcriptions.containsKey((Object)multicastTopic.topic)) {
            fastVector2 = (FastVector)this.topicToSusbcriptions.get((Object)multicastTopic.topic);
        } else {
            fastVector2 = new FastVector();
            this.topicToSusbcriptions.put((Object)multicastTopic.topic, (Object)fastVector2);
        }
        if (multicastTopic.partitionLabel != null) {
            if (multicastTopic.getKey() != null) {
                multicastTopic.rekey = true;
            }
            if (this.partitionTopics.containsKey((Object)multicastTopic.partitionLabel)) {
                fastVector = (FastHashtable)this.partitionTopics.get((Object)multicastTopic.partitionLabel);
            } else {
                fastVector = new FastHashtable();
                this.partitionTopics.put((Object)multicastTopic.partitionLabel, (Object)fastVector);
            }
            fastVector.put((Object)multicastTopic.topic, (Object)multicastTopic);
        }
        if (fastVector2.indexOf((Object)subscriptionInfoImpl) < 0) {
            fastVector = fastVector2;
            synchronized (fastVector) {
                fastVector2.addElement((Object)subscriptionInfoImpl);
            }
        }
        if (!this.multicastTopics.containsKey((Object)multicastTopic.topic)) {
            this.multicastTopics.put((Object)multicastTopic.topic, (Object)multicastTopic);
        } else if (multicastTopic.enabled) {
            fastVector = (MulticastTopic)this.multicastTopics.get((Object)multicastTopic.topic);
            if (!fastVector.enabled) {
                this.multicastTopics.put((Object)multicastTopic.topic, (Object)multicastTopic);
            }
        }
        if (multicastTopic.enabled) {
            this.bridge.registerTopic(multicastTopic, this.brokerMulticastInterface, (MulticastMessageReceiver)this, this.connection.ipv6Connection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterTopic(SubscriptionInfoImpl subscriptionInfoImpl, MulticastTopic multicastTopic) {
        FastVector fastVector;
        if (multicastTopic.enabled) {
            this.bridge.deregisterTopic((MulticastMessageReceiver)this, this.brokerMulticastInterface, multicastTopic);
        }
        int n = 0;
        if (this.topicToSusbcriptions.containsKey((Object)multicastTopic.topic)) {
            FastVector fastVector2 = fastVector = (FastVector)this.topicToSusbcriptions.get((Object)multicastTopic.topic);
            synchronized (fastVector2) {
                if (fastVector.indexOf((Object)subscriptionInfoImpl) > -1) {
                    fastVector.removeElementAt(fastVector.indexOf((Object)subscriptionInfoImpl));
                }
                n = fastVector.size();
            }
        }
        if (n == 0) {
            if (multicastTopic.partitionLabel != null && this.partitionTopics.containsKey((Object)multicastTopic.partitionLabel)) {
                fastVector = (FastHashtable)this.partitionTopics.get((Object)multicastTopic.partitionLabel);
                fastVector.remove((Object)multicastTopic.topic);
            }
            if (this.multicastTopics.containsKey((Object)multicastTopic.topic)) {
                this.multicastTopics.remove((Object)multicastTopic.topic);
            }
        }
        subscriptionInfoImpl.deleteMulticastTopic(multicastTopic);
    }

    public void deregisterAllTopics(SubscriptionInfoImpl subscriptionInfoImpl) {
        if (subscriptionInfoImpl.multicastTopics != null) {
            Enumeration enumeration = subscriptionInfoImpl.multicastTopics.elements();
            while (enumeration.hasMoreElements()) {
                MulticastTopic multicastTopic = (MulticastTopic)enumeration.nextElement();
                this.deregisterTopic(subscriptionInfoImpl, multicastTopic);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTopics(MulticastTopic[] multicastTopicArray) throws IOException {
        for (int i = 0; i < multicastTopicArray.length; ++i) {
            Object object;
            Object object2;
            Object object3;
            if (this.multicastTopics.containsKey((Object)multicastTopicArray[i].topic)) {
                Object object4;
                Enumeration enumeration;
                if (!multicastTopicArray[i].enabled) {
                    object2 = object3 = (MulticastTopic)this.multicastTopics.get((Object)multicastTopicArray[i].topic);
                    synchronized (object2) {
                        object3.setSecurity(null, false);
                        if (this.topicToSusbcriptions.containsKey((Object)multicastTopicArray[i].topic)) {
                            object = (FastVector)this.topicToSusbcriptions.get((Object)multicastTopicArray[i].topic);
                            enumeration = object.elements();
                            while (enumeration.hasMoreElements()) {
                                object4 = (SubscriptionInfoImpl)((Object)enumeration.nextElement());
                                this.deregisterTopic((SubscriptionInfoImpl)((Object)object4), (MulticastTopic)object3);
                            }
                        }
                    }
                    if (((MulticastTopic)object3).partitionLabel != null || !this.partitionTopics.containsKey((Object)multicastTopicArray[i].topic)) continue;
                    object2 = (FastHashtable)this.partitionTopics.get((Object)((MulticastTopic)object3).topic);
                    object = object2.elements();
                    while (object.hasMoreElements()) {
                        enumeration = (MulticastTopic)object.nextElement();
                        object4 = enumeration;
                        synchronized (object4) {
                            enumeration.setSecurity(null, false);
                            if (this.topicToSusbcriptions.containsKey((Object)((MulticastTopic)enumeration).topic)) {
                                FastVector fastVector = (FastVector)this.topicToSusbcriptions.get((Object)((MulticastTopic)enumeration).topic);
                                Enumeration enumeration2 = fastVector.elements();
                                while (enumeration2.hasMoreElements()) {
                                    SubscriptionInfoImpl subscriptionInfoImpl = (SubscriptionInfoImpl)((Object)enumeration2.nextElement());
                                    this.deregisterTopic(subscriptionInfoImpl, (MulticastTopic)enumeration);
                                }
                            }
                        }
                    }
                    continue;
                }
                object2 = object3 = (MulticastTopic)this.multicastTopics.get((Object)multicastTopicArray[i].topic);
                synchronized (object2) {
                    if (multicastTopicArray[i].hasQop() || object3.hasQop()) {
                        ((MulticastTopic)object3).qop = multicastTopicArray[i].qop;
                        object3.newKey(multicastTopicArray[i].getKey(), multicastTopicArray[i].timeStamp);
                    }
                    ((MulticastTopic)object3).reliable = multicastTopicArray[i].reliable;
                    if (((MulticastTopic)object3).groupAddress != multicastTopicArray[i].groupAddress && this.topicToSusbcriptions.containsKey((Object)((MulticastTopic)object3).topic)) {
                        object = (FastVector)this.topicToSusbcriptions.get((Object)((MulticastTopic)object3).topic);
                        enumeration = object.elements();
                        while (enumeration.hasMoreElements()) {
                            object4 = (SubscriptionInfoImpl)((Object)enumeration.nextElement());
                            if (((MulticastTopic)object3).enabled) {
                                this.deregisterTopic((SubscriptionInfoImpl)((Object)object4), (MulticastTopic)object3);
                            } else {
                                ((MulticastTopic)object3).enabled = true;
                            }
                            ((MulticastTopic)object3).groupAddress = multicastTopicArray[i].groupAddress;
                            ((SubscriptionInfoImpl)((Object)object4)).addMulticastTopic((MulticastTopic)object3);
                            this.registerTopic((SubscriptionInfoImpl)((Object)object4), (MulticastTopic)object3);
                        }
                    }
                    continue;
                }
            }
            if (!multicastTopicArray[i].enabled) continue;
            if (multicastTopicArray[i].hasQop()) {
                multicastTopicArray[i].rekey = true;
            }
            if (multicastTopicArray[i].partitionLabel == null) {
                object3 = this.connection.allSubs.elements();
                while (object3.hasMoreElements()) {
                    object2 = (SubscriptionInfoImpl)((Object)object3.nextElement());
                    object = ((SubscriptionInfoImpl)((Object)object2)).parsedTopic;
                    if (!TopicHandler.topicMatch((Object[][])object, (String)multicastTopicArray[i].topic, (char)'/')) continue;
                    ((SubscriptionInfoImpl)((Object)object2)).addMulticastTopic(multicastTopicArray[i]);
                    this.registerTopic((SubscriptionInfoImpl)((Object)object2), multicastTopicArray[i]);
                }
                continue;
            }
            if (multicastTopicArray[i].partitionLabel == null || !this.topicToSusbcriptions.containsKey((Object)multicastTopicArray[i].partitionLabel)) continue;
            object3 = (FastVector)this.topicToSusbcriptions.get((Object)multicastTopicArray[i].partitionLabel);
            object2 = object3.elements();
            while (object2.hasMoreElements()) {
                object = (SubscriptionInfoImpl)((Object)object2.nextElement());
                ((SubscriptionInfoImpl)((Object)object)).addMulticastTopic(multicastTopicArray[i]);
                this.registerTopic((SubscriptionInfoImpl)((Object)object), multicastTopicArray[i]);
            }
        }
    }

    public void sendControlMessage(byte[] byArray) {
        this.bridge.onControlMessage(byArray, (ControlChannelListener)this);
    }

    public MessageEncrypter incoming(byte[] byArray, MulticastTopic multicastTopic) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-165922073994779L, (Object)"incoming", (Object)byArray, (Object)multicastTopic);
        }
        MessageProtection messageProtection = null;
        if (multicastTopic.securityContext == null && multicastTopic.rekey) {
            multicastTopic.setSecurity(multicastTopic.getKey(), false);
        }
        if (multicastTopic.securityContext != null) {
            try {
                Qop.checkIntegrity((byte[])byArray, (SecurityContext)multicastTopic.securityContext, (boolean)false, (boolean)true);
            }
            catch (IntegrityCompromisedException integrityCompromisedException) {
                if (multicastTopic.newKey != 0L || multicastTopic.newCounter) {
                    if (multicastTopic.newKey != 0L && !multicastTopic.setNewKey()) {
                        throw integrityCompromisedException;
                    }
                    multicastTopic.newCounter = false;
                    Qop.checkIntegrity((byte[])byArray, (SecurityContext)multicastTopic.securityContext, (boolean)false, (boolean)true);
                }
                throw integrityCompromisedException;
            }
            multicastTopic.securityContext.newMessage();
            if (Framing.qop((byte[])byArray) == 14) {
                MessageProtection messageProtection2 = multicastTopic.securityContext.getMP();
                Qop.sessionDecrypt((byte[])byArray, (MessageProtection)messageProtection2, (Object)multicastTopic.securityContext.getServerKey(), (byte[])multicastTopic.securityContext.getDecryptIV());
                messageProtection = messageProtection2;
            }
        }
        if (debug.debugIt(16)) {
            debug.debug(-153415734321212L, (Object)"incoming", (Object)Hex.toString((byte[])byArray));
        }
        if (debug.debugIt(64)) {
            debug.debug(-142394261359015L, (Object)"incoming", messageProtection);
        }
        return messageProtection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String string, byte[] byArray) {
        String string2 = null;
        if (this.connection.ipv6Connection() && string.length() > 6 && string.substring(0, 6).equals("IPv6//")) {
            try {
                string = string2 = string.substring(6, string.length());
            }
            catch (Exception exception) {
                this.connection.setException(exception);
            }
        }
        if (this.multicastTopics.containsKey((Object)string)) {
            MulticastTopic multicastTopic;
            MulticastTopic multicastTopic2 = multicastTopic = (MulticastTopic)this.multicastTopics.get((Object)string);
            synchronized (multicastTopic2) {
                try {
                    MessageHandle messageHandle = null;
                    byte[] byArray2 = new byte[byArray.length];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    MessageEncrypter messageEncrypter = this.incoming(byArray2, multicastTopic);
                    messageHandle = SchemaRegistry.getMessageHandle((byte[])byArray2, (MessageEncrypter)messageEncrypter);
                    if (BaseConfig.getBaseConfig().ENABLE_QOP_SECURITY && multicastTopic.qop > Framing.qop((byte[])byArray2)) {
                        Byte by = new Byte(Framing.qop((byte[])byArray2));
                        Byte by2 = new Byte(multicastTopic.qop);
                        Integer n = new Integer(1);
                        throw new IOException(ExceptionBuilder.buildReasonString((int)1481488182, (Object[])new Object[]{by, by2, n}));
                    }
                    if (this.topicToSusbcriptions.containsKey((Object)string)) {
                        FastVector fastVector = (FastVector)this.topicToSusbcriptions.get((Object)string);
                        this.connection.newMulticastMessage(fastVector, messageHandle);
                    }
                }
                catch (IOException iOException) {
                    this.connection.setException(iOException);
                }
            }
        }
    }

    public void onControlMessage(byte[] byArray) {
        this.connection.sendMulticastControlMsg(byArray);
    }

    public PeerId getAddress() {
        if (this.peerId == null) {
            this.peerId = new PeerId(this.connection.getAddress(), this.connection.getPort());
        }
        return this.peerId;
    }

    public boolean isOpen() {
        return this.connection.isActive();
    }

    public void setAddress(PeerId peerId) {
        this.peerId = peerId;
    }

    public void onException(MulticastException multicastException) {
        if (multicastException instanceof com.ibm.disthub2.impl.multicast.client.MulticastPacketLossException) {
            this.connection.onException((Exception)((Object)new MulticastPacketLossException(ConfigEnvironment.getErrorMessage("MQJMS1103", new Integer(((com.ibm.disthub2.impl.multicast.client.MulticastPacketLossException)multicastException).getNumberOfPackets())))));
        } else if (multicastException instanceof com.ibm.disthub2.impl.multicast.client.MulticastHeartbeatTimeoutException) {
            this.connection.onException((Exception)((Object)new MulticastHeartbeatTimeoutException(ConfigEnvironment.getErrorMessage("MQJMS1104"))));
        }
    }

    public void close() {
        this.bridge.shutdown();
    }
}

