/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.jms.JMSStringResources;
import com.ibm.mq.MQObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;

public class JMSObjectMessage
extends JMSMessage
implements ObjectMessage {
    static final long serialVersionUID = -9160649637541619341L;
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/jms/JMSObjectMessage.java, jms, j600, j600-101-060328 1.25.1.1 05/05/25 15:13:29";
    byte[] messageBytes = null;
    int dataStart;
    boolean readOnly = false;

    public JMSObjectMessage(JMSStringResources jMSStringResources) throws JMSException {
        if (trace != null) {
            trace.entry(this, "constructor");
            trace.trace(2, this, sccsid);
        }
        this.messageClass = "jms_object";
        this.jmsStrings = jMSStringResources;
        if (trace != null) {
            trace.exit(this, "constructor");
        }
    }

    public JMSObjectMessage(JMSStringResources jMSStringResources, Serializable serializable) throws JMSException {
        this(jMSStringResources);
        if (trace != null) {
            trace.entry(this, "constructor with Object");
            trace.trace(2, this, sccsid);
        }
        this.setObject(serializable);
        if (trace != null) {
            trace.exit(this, "constructor with Object");
        }
    }

    public byte[] _exportBody(int n, String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "_exportBody");
        }
        if (this.messageBytes != null && this.dataStart != 0) {
            int n2 = this.messageBytes.length - this.dataStart;
            byte[] byArray = new byte[n2];
            System.arraycopy(this.messageBytes, this.dataStart, byArray, 0, n2);
            this.messageBytes = byArray;
            this.dataStart = 0;
        }
        if (trace != null) {
            trace.exit(this, "_exportBody");
        }
        return this.messageBytes;
    }

    public void _importBody(byte[] byArray, int n, int n2, String string) throws JMSException {
        if (trace != null) {
            trace.entry(this, "_importBody");
        }
        this.messageBytes = byArray;
        this.dataStart = n;
        if (trace != null) {
            trace.exit(this, "_importBody");
        }
    }

    public void clearBody() throws JMSException {
        if (trace != null) {
            trace.entry(this, "clearBody");
        }
        this.readOnly = false;
        this.messageBytes = null;
        if (trace != null) {
            trace.exit(this, "clearBody");
        }
    }

    public Serializable getObject() throws JMSException {
        Serializable serializable = null;
        if (trace != null) {
            trace.entry(this, "getObject");
        }
        try {
            if (this.messageBytes != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.messageBytes, this.dataStart, this.messageBytes.length - this.dataStart);
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                MQObjectInputStream mQObjectInputStream = new MQObjectInputStream(byteArrayInputStream, classLoader);
                serializable = (Serializable)mQObjectInputStream.readObject();
            }
        }
        catch (IOException iOException) {
            JMSException jMSException = this.newMessageFormatException(1024);
            jMSException.setLinkedException((Exception)iOException);
            if (trace != null) {
                trace.exit(this, "getObject, via Exception");
            }
            throw jMSException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            JMSException jMSException = this.newMessageFormatException(1024);
            jMSException.setLinkedException((Exception)classNotFoundException);
            if (trace != null) {
                trace.exit(this, "getObject, via Exception");
            }
            throw jMSException;
        }
        if (trace != null) {
            trace.exit(this, "getObject");
        }
        return serializable;
    }

    public void setObject(Serializable serializable) throws JMSException {
        if (trace != null) {
            trace.entry(this, "setObject");
        }
        if (this.readOnly) {
            throw this.newMessageNotWriteableException();
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            this.messageBytes = byteArrayOutputStream.toByteArray();
            this.dataStart = 0;
            serializable = null;
        }
        catch (IOException iOException) {
            JMSException jMSException = this.newMessageFormatException(1023);
            jMSException.setLinkedException((Exception)iOException);
            if (trace != null) {
                trace.exit(this, "setObject, via Exception");
            }
            throw jMSException;
        }
        if (trace != null) {
            trace.exit(this, "setObject");
        }
    }

    public String toString() {
        if (trace != null) {
            trace.entry(this, "toString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("\n");
        try {
            Serializable serializable = this.getObject();
            if (serializable == null) {
                stringBuffer.append("<null>");
            } else {
                stringBuffer.append(serializable.getClass());
            }
        }
        catch (JMSException jMSException) {
            stringBuffer.append(this.jmsStrings.getMessage(1025, (Object)jMSException));
            stringBuffer.append(">");
        }
        if (trace != null) {
            trace.exit(this, "toString");
        }
        return stringBuffer.toString();
    }

    void _setBodyReadOnly() {
        this.readOnly = true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.messageClass.equals("jms_object")) {
            this.messageClass = "jms_object";
        }
    }
}

