/*
 * e2e technologies Ltd.
 * Project:
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * $Id: Track.java,v 1.1 2008/11/14 20:25:11 tzimber Exp $
 */
package ch.e2e.examples.complex;

import org.w3c.dom.Element;

/**
 * Holds the information of a track.
 * Copyright &#169; 2001-2005 E2E technologies Ltd. All rights reserved.
 * @author tzimber
 * @version $Revision: 1.1 $
 */
public class Track {
	/**
	 * The title of the track
	 */
	private String title;
	/**
	 * The interpreter of the track
	 */
	private Interpreter interpreter;

	/**
	 * The default constructor of the object.
	 */
	public Track() {}

	/**
	 * Constructs a new Track object, by parsing the xml element from the DB.
	 * @param trackElement The xml element from the DB of this Track object.
	 */
	public Track(Element trackElement) {
		title = trackElement.getAttribute("title");
		if (trackElement.hasAttribute("interpreter")) {
			interpreter = new Interpreter(trackElement.getAttribute("interpreter"));
		} else {
			interpreter = findAlbumInterpreter(trackElement);
		}
	}

	/**
	 * Returns the interpreter of the track.
	 * @return the interpreter of the track.
	 */
	public Interpreter getInterpreter() {
		return interpreter;
	}

	/**
	 * Sets the interpreter of the track.
	 * @param interpreter The interpreter of the track.
	 */
	public void setInterpreter(Interpreter interpreter) {
		this.interpreter = interpreter;
	}

	/**
	 * Returns the title of the track.
	 * @return the title of the track.
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * Sets the title of the track.
	 * @param title The title of the track.
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * Searches for the interpreter of the album, if the xml element has
	 * no interpreter attribute.
	 * @param element The xml element from DB of this track.
	 * @return the interpreter of the album.
	 */
	private Interpreter findAlbumInterpreter(Element element) {
		Interpreter interpret;
		String nodename = element.getNodeName();
		while ((nodename != null) && !nodename.equals("album")) {
			element = (Element)element.getParentNode();
			nodename = (element == null)? null: element.getNodeName();
		}
		if (element == null) {
			interpret = new Interpreter("");
		} else {
			interpret = new Interpreter(element.getAttribute("interpreter"));
		}
		return interpret;
	}

	/**
	 * Overrides toString of java.lang.Object.
	 * @return a String representation of this track.
	 */
	public String toString() {
		return interpreter.getFullname() + ": " + title;
	}
}
