/*
 * e2e technologies Ltd.
 * Project: java AddOn examples
 * Copyright &#169; 2001-2005 e2e technologies Ltd. All rights reserved.
 * $Id: AlbumDB.java,v 1.1 2008/11/14 20:25:11 tzimber Exp $
 */
package ch.e2e.examples.complex;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

/**
 * Holds the list of all albums.<br><br>
 * Copyright &#169; 2001-2005 E2E technologies Ltd. All rights reserved.
 * @author tzimber
 * @version $Revision: 1.1 $
 */
public class AlbumDB {
	/**
	 * The one and only instance of this class.
	 */
	private static AlbumDB db = new AlbumDB();
	/**
	 * The list of all albums in the DB
	 */
	private ArrayList<Album> albums = new ArrayList<Album>();

	/**
	 * Reads the album informations from the file <code>ch/e2e/examples/albums.xml</code>
	 */
	private AlbumDB() {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			factory.setValidating(false);
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document document = builder.parse(getClass().getClassLoader().getResourceAsStream("ch/e2e/examples/complex/cdlist.xml"));
			NodeList albumList = document.getDocumentElement().getElementsByTagName("album");
			int length = albumList.getLength();
			for (int i = 0; i < length; i++) {
				Element albumElement = (Element)albumList.item(i);
				addAlbum(albumElement);
			}
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (FactoryConfigurationError e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Returns the instance of this class.
	 * @return The instance of this class.
	 */
	public static AlbumDB getInstance() {
		return db;
	}

	/**
	 * Retrieves the album wih the given title from the given interpreter.
	 * If the interpreter is null, the method returns all albums with the
	 * given title. If the title is null, the method returns all albums
	 * of the given interpreter.
	 * @param title
	 * @param interpreter
	 * @return the album wih the given title from the given interpreter.
	 */
	public synchronized Album[] findAlbum(String title, String interpreter) {
		ArrayList<Album> resultList = new ArrayList<Album>();
		if ((interpreter == null) || (interpreter.length() == 0)) {
			if (title != null) {
				for (Object album1 : albums) {
					Album album = (Album)album1;
					if (album.getTitle().equalsIgnoreCase(title)) {
						resultList.add(album);
					}
				}
			}
		} else {
			for (Object album1 : albums) {
				Album album = (Album)album1;
				Interpreter artist = album.getInterpreter();
				if (artist.getFullname().equalsIgnoreCase(interpreter)
						|| artist.getLastname().equalsIgnoreCase(interpreter)) {
					if ((title == null) || (title.length() == 0)) {
						resultList.add(album);
					} else {
						if (album.getTitle().equalsIgnoreCase(title)) {
							resultList.add(album);
						}
					}
				}
			}
		}
		Album[] albums = new Album[resultList.size()];
		resultList.toArray(albums);
		return albums;
	}

	/**
	 * Returns all existing interpreter.
	 * @return All existing interpreter.
	 */
	public synchronized String[] getAllInterpreter() {
		ArrayList<String> resultList = new ArrayList<String>();
		for (Album album : albums) {
			String interpreter = album.getInterpreter().getFullname();
			if (!interpreter.equalsIgnoreCase("sampler")
					&& !interpreter.equalsIgnoreCase("soundtrack")) {
				if (!resultList.contains(interpreter)) {
					resultList.add(interpreter);
				}
			}
			Track[] tracks = album.getTracks();
			for (Track track : tracks) {
				interpreter = track.getInterpreter().getFullname();
				if (!resultList.contains(interpreter)) {
					resultList.add(interpreter);
				}
			}
		}
		String[] interprets = new String[resultList.size()];
		resultList.toArray(interprets);
		return interprets;
	}

	/**
	 * Retrieves the album wih the given song of the given interpreter.
	 * If the interpreter is null, the method returns all albums with the
	 * given title. If the title is null, the method returns all albums
	 * of the given interpreter.
	 * @param songTitle The title of the song to search for.
	 * @param interpreter The name of the interpreter to search for.
	 * @return the album wih the given song of the given interpreter.
	 */
	public synchronized Album[] findSongAlbum(String songTitle, String interpreter) {
		ArrayList<Album> resultList = new ArrayList<Album>();
		if (songTitle != null) {
			for (Object album1 : albums) {
				Album album = (Album)album1;
				if (album.containsSong(songTitle, interpreter)) {
					resultList.add(album);
				}
			}
		}
		Album[] albums = new Album[resultList.size()];
		resultList.toArray(albums);
		return albums;
	}

	/**
	 * Retrieves all songs of the given interpreter.
	 * @param interpreter The name of the interpreter to search for.
	 * @return all songs of the given interpreter.
	 */
	public synchronized TrackResult[] findSongs(String interpreter) {
		HashMap<String, TrackResult> result = new HashMap<String, TrackResult>();
		for (Album album : albums) {
			Track[] albumTracks = album.getTracks();
			for (Track albumTrack : albumTracks) {
				Interpreter artist = albumTrack.getInterpreter();
				if (artist.getFullname().equalsIgnoreCase(interpreter)
						|| artist.getLastname().equalsIgnoreCase(interpreter)) {
					String title = albumTrack.getTitle().toUpperCase();
					TrackResult trackResult = result.get(title);
					if (trackResult == null) {
						trackResult = new TrackResult();
						trackResult.setTrack(albumTrack);
						result.put(title, trackResult);
					}
					trackResult.addAlbum(album.getTitle());
				}
			}
		}
		ArrayList<TrackResult> resultList = new ArrayList<TrackResult>(result.values());
		TrackResult[] tracks = new TrackResult[resultList.size()];
		resultList.toArray(tracks);
		return tracks;
	}

	/**
	 * Adds a album, defined by its xml element.
	 * @param albumElement The xml element defining the album.
	 */
	private void addAlbum(Element albumElement) {
		Album album = new Album(albumElement);
		albums.add(album);
	}
}
