/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms.services.psk;

import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import com.ibm.mq.jms.services.psk.LogServiceProvider;
import com.ibm.mq.jms.services.psk.Trace;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;

public class FileLogServiceProvider
extends LogServiceProvider {
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/services/psk/FileLogServiceProvider.java, jms, j600, j600-101-060328 1.5.1.1 05/05/25 15:11:44";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 1998, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final int m_overhead = 20;
    protected static final int m_nextOffset = 10;
    protected static final long m_topOfFile = 16L;
    protected static final long m_topOfMessages = 100L;
    private static final String CorruptedLogFiles = "The log files are corrupted !";
    private static final String MessageToBig = "Message size is bigger than log file size !";
    private File m_dir;
    private String m_logFilePrefix = "javalog";
    private int m_numLogFiles = 3;
    private boolean m_multipleLogFiles = true;
    private long m_maxLogFileSize = 0x100000L;
    private LogFile m_logFile = null;
    protected static long m_messageEmpty = 0L;
    protected static long m_wrapAround = -1L;
    private boolean m_wrapping = false;

    public FileLogServiceProvider(String string, File file) throws LogException {
        super(string);
        Trace.entry(this, "FileLogServiceProvider");
        Trace.trace(2, this, sccsid);
        this.m_dir = file;
        Trace.exit(this, "FileLogServiceProvider");
    }

    private boolean checkFileSpace(long l, long l2) {
        boolean bl = l + l2 + 20L + 10L <= this.m_maxLogFileSize;
        return bl;
    }

    public void closeLog() throws LogException {
        Trace.entry(this, "closeLog");
        Trace.trace(2, this, "messageCounter      : " + this.m_logFile.messageCounter);
        Trace.trace(2, this, "actualLogFileName   : " + this.m_logFile.file.getName());
        Trace.trace(2, this, "actualLogFileNumber : " + this.m_logFile.actualLogFileNumber);
        try {
            this.closeLogFile(this.m_logFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LogException(this.getServiceName(), iOException.getLocalizedMessage());
        }
        this.m_logFile.open = false;
        Trace.exit(this, "closeLog");
    }

    private void closeLogFile(LogFile logFile) throws IOException {
        Trace.entry(this, "closeLogFile");
        logFile.seek(16L);
        Trace.trace(3, this, "closeLogFile - topOfFile     : " + logFile.randAccess.getFilePointer());
        logFile.msgOut.writeBoolean(logFile.isActive);
        logFile.msgOut.flush();
        Trace.trace(3, this, "closeLogFile - latestMessage : " + logFile.latestMessage);
        logFile.msgOut.writeLong(logFile.latestMessage);
        logFile.msgOut.flush();
        Trace.trace(3, this, "closeLogFile - numberOfMsg   : " + logFile.numberOfMessages);
        Trace.trace(3, this, "closeLogFile - messageCounter: " + logFile.messageCounter);
        logFile.msgOut.writeLong(logFile.numberOfMessages + logFile.messageCounter);
        logFile.msgOut.flush();
        logFile.messageCounter = 0L;
        logFile.numberOfMessages = 0L;
        Trace.trace(3, this, "closeLogFile - fileLength    : " + this.m_maxLogFileSize);
        logFile.msgOut.writeLong(this.m_maxLogFileSize);
        logFile.msgOut.flush();
        logFile.msgOut.writeBoolean(true);
        logFile.msgOut.flush();
        logFile.msgOut.writeLong(this.m_numLogFiles);
        logFile.msgOut.flush();
        Trace.trace(3, this, "closeLogFile - FP after mainting the header : " + logFile.randAccess.getFilePointer());
        logFile.randAccess.seek(0L);
        logFile.msgOut.close();
        logFile.msgIn.close();
        logFile.outStream.close();
        logFile.inStream.close();
        logFile.randAccess.close();
        logFile.open = false;
        Trace.exit(this, "closeLogFile");
    }

    private void connectToExistStream(LogFile logFile) throws IOException, StreamCorruptedException {
        Trace.entry(this, "connectToExistStream");
        logFile.randAccess = new RandomAccessFile(logFile.file, "rw");
        logFile.outStream = new FileOutputStream(logFile.randAccess.getFD());
        logFile.msgOut = new ObjectOutputStream(logFile.outStream);
        logFile.seek(0L);
        logFile.inStream = new FileInputStream(logFile.randAccess.getFD());
        logFile.msgIn = new ObjectInputStream(logFile.inStream);
        logFile.seek(16L);
        boolean bl = logFile.msgIn.readBoolean();
        logFile.latestMessage = logFile.msgIn.readLong();
        Trace.trace(2, this, " latestMessage   : " + logFile.latestMessage);
        logFile.numberOfMessages = logFile.msgIn.readLong();
        Trace.trace(2, this, " numberOfMessages : " + logFile.numberOfMessages);
        logFile.msgIn.readLong();
        logFile.noOldMessages = logFile.msgIn.readBoolean();
        Trace.trace(2, this, " noOldMessages   : " + logFile.noOldMessages);
        if (!this.m_wrapping) {
            Trace.trace(2, this, " no wrapping, latestMessage : " + logFile.latestMessage);
            logFile.seek(logFile.latestMessage);
            long l = logFile.msgIn.readLong();
            logFile.seek(logFile.latestMessage + l + 10L);
        } else {
            Trace.trace(2, this, " wrapping");
            logFile.seek(100L);
        }
        Trace.exit(this, "connectToExistStream");
    }

    private void connectToNewStream(LogFile logFile) throws IOException, StreamCorruptedException {
        Trace.entry(this, "connectToNewStream");
        logFile.randAccess = new RandomAccessFile(logFile.file, "rw");
        logFile.seek(0L);
        logFile.outStream = new FileOutputStream(logFile.randAccess.getFD());
        logFile.msgOut = new ObjectOutputStream(logFile.outStream);
        logFile.seek(0L);
        logFile.inStream = new FileInputStream(logFile.randAccess.getFD());
        logFile.msgIn = new ObjectInputStream(logFile.inStream);
        logFile.seek(16L);
        logFile.msgOut.writeBoolean(true);
        logFile.msgOut.flush();
        logFile.msgOut.writeLong(0L);
        logFile.msgOut.flush();
        logFile.msgOut.writeLong(0L);
        logFile.msgOut.flush();
        logFile.msgOut.writeLong(this.m_maxLogFileSize);
        logFile.msgOut.flush();
        logFile.msgOut.writeBoolean(false);
        logFile.msgOut.flush();
        logFile.msgOut.writeLong(this.m_numLogFiles);
        logFile.msgOut.flush();
        logFile.seek(100L);
        long l = logFile.randAccess.getFilePointer();
        logFile.msgOut.writeLong(l + 10L);
        logFile.msgOut.flush();
        logFile.msgOut.writeLong(m_messageEmpty);
        logFile.msgOut.flush();
        logFile.seek(l);
        logFile.firstMessage = true;
        Trace.exit(this, "connectToNewStream");
    }

    private LogFile createLogFile() {
        Trace.entry(this, "createLogFile");
        String string = this.m_multipleLogFiles ? (this.m_logFile == null ? "1.log" : this.m_logFile.actualLogFileNumber + ".log") : ".log";
        LogFile logFile = new LogFile();
        logFile.file = new File(this.m_dir, this.m_logFilePrefix + string);
        if (this.m_logFile != null) {
            logFile.actualLogFileNumber = this.m_logFile.actualLogFileNumber;
        }
        Trace.exit(this, "createLogFile");
        return logFile;
    }

    private void debug(String string) {
    }

    private LogFile getActiveLogFile() throws IOException, StreamCorruptedException {
        int n = 1;
        boolean bl = false;
        Trace.entry(this, "getActiveLogFile");
        LogFile logFile = new LogFile();
        if (this.m_multipleLogFiles) {
            do {
                String string;
                File file;
                if ((file = new File(this.m_dir, string = new String(this.m_logFilePrefix + n + ".log"))).exists()) {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                    FileInputStream fileInputStream = new FileInputStream(randomAccessFile.getFD());
                    ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                    randomAccessFile.seek(16L);
                    if (objectInputStream.readBoolean()) {
                        logFile.isActive = true;
                        logFile.file = file;
                        logFile.actualLogFileNumber = n;
                        bl = true;
                        Trace.trace(3, this, "file found : " + string);
                    }
                    objectInputStream.close();
                    fileInputStream.close();
                    randomAccessFile.close();
                }
                if (n > this.m_numLogFiles) {
                    throw new StreamCorruptedException(CorruptedLogFiles);
                }
                ++n;
            } while (!bl);
        } else {
            logFile = this.m_logFile;
        }
        Trace.exit(this, "getActiveLogFile");
        return logFile;
    }

    private long getSizeOfMessage(LogMessage logMessage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(logMessage);
        objectOutputStream.flush();
        long l = byteArrayOutputStream.size();
        objectOutputStream.close();
        byteArrayOutputStream.close();
        return l;
    }

    private void insertMessage(LogFile logFile, long l, LogMessage logMessage, long l2) throws IOException {
        Trace.entry(this, "insertMessage", "actualPointer=" + l);
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        boolean bl = false;
        logFile.seek(l);
        l3 = logFile.msgIn.readLong();
        logFile.latestMessage = l4 = logFile.randAccess.getFilePointer();
        logFile.seek(l3);
        Trace.trace(3, this, "insertMessage - beginOfMessage : " + l4);
        Trace.trace(3, this, "insertMessage - sizeOfMessage  : " + l2);
        if (l3 - l4 > l2 + 20L) {
            logFile.seek(l);
            logFile.msgOut.writeLong(l4);
            logFile.msgOut.flush();
            logFile.msgOut.writeLong(l2);
            logFile.msgOut.flush();
            logFile.msgOut.writeObject(logMessage);
            logFile.msgOut.flush();
            logFile.msgOut.reset();
            logFile.seek(l4 + l2 + 10L);
            logFile.msgOut.writeLong(l3);
            logFile.msgOut.flush();
            this.maintainFileHeader(logFile, l4, logFile.isActive);
            logFile.seek(l4 + l2 + 10L);
        } else {
            while (!bl) {
                logFile.seek(l3);
                l5 = logFile.msgIn.readLong();
                if (l5 == m_wrapAround) {
                    logFile.seek(l);
                    logFile.msgOut.writeLong(l + 10L);
                    logFile.msgOut.flush();
                    logFile.msgOut.writeLong(m_wrapAround);
                    logFile.msgOut.flush();
                    long l6 = logFile.randAccess.getFilePointer();
                    logFile.randAccess.skipBytes((int)(logFile.file.length() - l6));
                    if (this.m_multipleLogFiles) {
                        logFile.isActive = false;
                        this.closeLogFile(logFile);
                        logFile = this.m_logFile = this.openNextLogFile();
                        logFile.isActive = true;
                    } else {
                        logFile.seek(100L);
                    }
                    this.writeLogMessage(logFile, logMessage);
                    Trace.exit(this, "insertMessage");
                    return;
                }
                logFile.seek(l3 + l5 + 10L);
                l3 = logFile.msgIn.readLong();
                if (l3 - l4 < l2 + 20L) {
                    bl = false;
                    logFile.seek(l3);
                    l5 = logFile.msgIn.readLong();
                    if (l5 == m_wrapAround) {
                        logFile.seek(l);
                        logFile.msgOut.writeLong(l + 10L);
                        logFile.msgOut.flush();
                        logFile.msgOut.writeLong(m_wrapAround);
                        logFile.msgOut.flush();
                        long l7 = logFile.randAccess.getFilePointer();
                        logFile.randAccess.skipBytes((int)(logFile.file.length() - l7));
                        if (this.m_multipleLogFiles) {
                            logFile.isActive = false;
                            this.closeLogFile(logFile);
                            logFile = this.m_logFile = this.openNextLogFile();
                            logFile.isActive = true;
                        } else {
                            logFile.seek(100L);
                        }
                        this.writeLogMessage(logFile, logMessage);
                        Trace.exit(this, "writeLogMessage");
                        return;
                    }
                    logFile.seek(l3 + l5 + 10L);
                    l3 = logFile.msgIn.readLong();
                    continue;
                }
                bl = true;
            }
            logFile.seek(l);
            logFile.msgOut.writeLong(l4);
            logFile.msgOut.flush();
            logFile.msgOut.writeLong(l2);
            logFile.msgOut.flush();
            logFile.msgOut.writeObject(logMessage);
            logFile.msgOut.flush();
            logFile.msgOut.reset();
            logFile.seek(l4 + l2 + 10L);
            logFile.msgOut.writeLong(l3);
            logFile.msgOut.flush();
            this.maintainFileHeader(logFile, l4, logFile.isActive);
            logFile.seek(l4 + l2 + 10L);
        }
        Trace.exit(this, "insertMessage");
    }

    public void log(LogMessage logMessage) throws LogException {
        try {
            if (this.getFormatStyle() == 0) {
                if (this.m_logFile == null || !this.m_logFile.open) {
                    this.openLogFile();
                }
                this.writeLogMessage(this.m_logFile, logMessage);
                ++this.m_logFile.messageCounter;
            }
        }
        catch (StreamCorruptedException streamCorruptedException) {
            streamCorruptedException.printStackTrace();
            throw new LogException(this.getServiceName(), streamCorruptedException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LogException(this.getServiceName(), iOException.getLocalizedMessage());
        }
    }

    public void logExplanation(LogMessage logMessage) {
    }

    private boolean logFileExists() throws IOException, StreamCorruptedException {
        Trace.entry(this, "logFileExists");
        boolean bl = false;
        String string = this.m_multipleLogFiles ? "1.log" : ".log";
        File file = new File(this.m_dir, this.m_logFilePrefix + string);
        if (file.exists()) {
            Trace.trace(2, this, "logFileExists  : " + file.getName());
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            FileInputStream fileInputStream = new FileInputStream(randomAccessFile.getFD());
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            randomAccessFile.seek(16L);
            objectInputStream.readBoolean();
            objectInputStream.readLong();
            objectInputStream.readLong();
            long l = objectInputStream.readLong();
            objectInputStream.readBoolean();
            long l2 = objectInputStream.readLong();
            objectInputStream.close();
            fileInputStream.close();
            randomAccessFile.close();
            if (this.m_maxLogFileSize != l) {
                Trace.trace(2, this, "false file size -> deleting old files");
                if (this.m_multipleLogFiles) {
                    int n = 1;
                    while ((long)n <= l2) {
                        File file2 = new File(this.m_dir, this.m_logFilePrefix + n + ".log");
                        file2.delete();
                        ++n;
                    }
                } else {
                    file.delete();
                }
                bl = false;
            } else {
                this.m_logFile = new LogFile();
                this.m_logFile.file = file;
                bl = true;
            }
        }
        return bl;
    }

    private void maintainFileHeader(LogFile logFile, long l, boolean bl) throws IOException {
        logFile.seek(16L);
        logFile.msgOut.writeBoolean(bl);
        logFile.msgOut.flush();
        logFile.msgOut.writeLong(l);
        logFile.msgOut.flush();
    }

    private void openLogFile() throws IOException, StreamCorruptedException {
        Trace.entry(this, "openLogFile");
        if (!this.logFileExists()) {
            this.m_logFile = this.createLogFile();
            this.connectToNewStream(this.m_logFile);
        } else {
            this.m_logFile = this.getActiveLogFile();
            this.connectToExistStream(this.m_logFile);
        }
        this.m_logFile.open = true;
        Trace.exit(this, "openLogFile");
    }

    private LogFile openNextLogFile() throws IOException, StreamCorruptedException {
        Trace.entry(this, "openNextLogFile", "old file = " + this.m_logFile.file.getName());
        if (this.m_logFile.actualLogFileNumber < this.m_numLogFiles) {
            Trace.trace(3, this, "openNextLogFile, actualLogFileNumber : " + this.m_logFile.actualLogFileNumber);
            Trace.trace(3, this, "openNextLogFile, numLogFiles         : " + this.m_numLogFiles);
            ++this.m_logFile.actualLogFileNumber;
            String string = this.m_logFilePrefix + this.m_logFile.actualLogFileNumber + ".log";
            this.m_logFile.file = new File(this.m_dir, string);
            if (!this.m_logFile.file.exists()) {
                Trace.trace(3, this, "openNextLogFile, create new log file");
                this.m_wrapping = false;
                this.m_logFile = this.createLogFile();
                this.connectToNewStream(this.m_logFile);
            } else {
                this.m_wrapping = true;
                this.connectToExistStream(this.m_logFile);
            }
            Trace.trace(3, this, "openNextLogFile, newLogFileNumber    : " + this.m_logFile.actualLogFileNumber);
            Trace.trace(3, this, "openNextLogFile, next file           : " + string);
            Trace.exit(this, "openNextLogFile");
            return this.m_logFile;
        }
        Trace.trace(3, this, "openNextLogFile, actualLogFileNumber : " + this.m_logFile.actualLogFileNumber);
        Trace.trace(3, this, "openNextLogFile, numLogFiles         : " + this.m_numLogFiles);
        this.m_logFile.actualLogFileNumber = 1;
        String string = this.m_logFilePrefix + this.m_logFile.actualLogFileNumber + ".log";
        this.m_logFile.file = new File(this.m_dir, string);
        if (!this.m_logFile.file.exists()) {
            Trace.trace(3, this, "openNextLogFile, create new log file");
            this.m_wrapping = false;
            this.m_logFile = this.createLogFile();
            this.connectToNewStream(this.m_logFile);
        } else {
            this.m_wrapping = true;
            this.connectToExistStream(this.m_logFile);
        }
        Trace.trace(3, this, "openNextLogFile, newLogFileNumber    : " + this.m_logFile.actualLogFileNumber);
        Trace.trace(3, this, "openNextLogFile, next file           : " + string);
        Trace.exit(this, "openNextLogFile");
        return this.m_logFile;
    }

    public void setLogFilePrefix(String string) {
        Trace.entry(this, "setLogFilePrefix");
        this.m_logFilePrefix = string;
        Trace.exit(this, "setLogFilePrefix");
    }

    public void setMaxLogFileSize(long l) {
        Trace.entry(this, "setMaxLogFileSize");
        this.m_maxLogFileSize = l * 1024L;
        Trace.exit(this, "setMaxLogFileSize");
    }

    public void setNumLogFiles(int n) {
        Trace.entry(this, "setNumLogFiles");
        if (n > 1) {
            this.m_multipleLogFiles = true;
        } else {
            this.m_multipleLogFiles = false;
            if (n <= 0) {
                n = 1;
            }
        }
        this.m_numLogFiles = n;
        Trace.exit(this, "setNumLogFiles");
    }

    private void writeLogMessage(LogFile logFile, LogMessage logMessage) throws IOException {
        Trace.entry(this, "writeLogMessage");
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        l = this.getSizeOfMessage(logMessage);
        if (l + 100L >= this.m_maxLogFileSize) {
            throw new IOException(MessageToBig);
        }
        l3 = logFile.randAccess.getFilePointer();
        if (!this.checkFileSpace(l3, l)) {
            l4 = logFile.msgIn.readLong();
            logFile.seek(l4);
            Trace.trace(3, this, " nextPointer for 'wrapAround' : " + l4);
            logFile.msgOut.writeLong(m_wrapAround);
            logFile.msgOut.flush();
            l5 = logFile.randAccess.getFilePointer();
            logFile.randAccess.skipBytes((int)(logFile.file.length() - l5));
            if (this.m_multipleLogFiles) {
                logFile.isActive = false;
                this.closeLogFile(logFile);
                logFile = this.m_logFile = this.openNextLogFile();
                l3 = logFile.randAccess.getFilePointer();
            } else {
                logFile.seek(100L);
                l3 = 100L;
            }
        }
        logFile.isActive = true;
        l4 = logFile.msgIn.readLong();
        logFile.seek(l4);
        Trace.trace(3, this, " nextPointer : " + l4);
        l2 = logFile.msgIn.readLong();
        if (l2 == m_messageEmpty) {
            this.writeMessage(logFile, l3, logMessage, l);
        } else {
            this.insertMessage(logFile, l3, logMessage, l);
        }
        this.m_wrapping = false;
    }

    private void writeMessage(LogFile logFile, long l, LogMessage logMessage, long l2) throws IOException {
        Trace.entry(this, "writeMessage");
        long l3 = 0L;
        long l4 = 0L;
        logFile.seek(l);
        l4 = logFile.msgIn.readLong();
        logFile.seek(l4);
        logFile.latestMessage = l3 = logFile.randAccess.getFilePointer();
        Trace.trace(3, this, "writeMessage - beginOfMessage : " + l3);
        Trace.trace(3, this, "writeMessage - sizeOfMessage  : " + l2);
        logFile.msgOut.writeLong(l2);
        logFile.msgOut.flush();
        logFile.msgOut.writeObject(logMessage);
        logFile.msgOut.flush();
        l4 = l3 + l2 + 20L;
        logFile.seek(l3 + l2 + 10L);
        logFile.msgOut.writeLong(l4);
        logFile.msgOut.flush();
        Trace.trace(3, this, "writeMessage - nextPointer   : " + l4);
        logFile.msgOut.writeLong(m_messageEmpty);
        logFile.msgOut.flush();
        logFile.msgOut.reset();
        this.maintainFileHeader(logFile, l3, logFile.isActive);
        logFile.seek(l3 + l2 + 10L);
        Trace.exit(this, "writeMessage");
    }

    private class LogFile {
        public File file;
        public boolean open = false;
        public int actualLogFileNumber = 1;
        public RandomAccessFile randAccess = null;
        public FileOutputStream outStream = null;
        public FileInputStream inStream = null;
        public ObjectOutputStream msgOut = null;
        public ObjectInputStream msgIn = null;
        public long latestMessage = 0L;
        public long numberOfMessages = 0L;
        public long messageCounter = 0L;
        public boolean firstMessage = true;
        public boolean noOldMessages = true;
        public boolean isActive = true;

        private LogFile() {
        }

        public void seek(long l) throws IOException {
            if (this.randAccess != null) {
                long l2 = this.randAccess.length();
                if (l2 < l) {
                    this.randAccess.seek(l2);
                    int n = 0;
                    while ((long)n <= l - l2) {
                        this.randAccess.writeByte(0);
                        ++n;
                    }
                }
                this.randAccess.seek(l);
            }
        }
    }
}

