/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQXAResource;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TransactionInProgressException;
import javax.jms.XASession;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class MQXASession
extends MQSession
implements XASession {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQXASession.java, jms, j600, j600-101-060328 1.19.1.1 05/05/25 15:57:22";
    XAResource resource;
    private MQSession session = null;

    public MQXASession(MQConnection mQConnection, MQSession mQSession, MQXAResource mQXAResource) throws JMSException {
        super(mQConnection, true, 0);
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        this.session = mQSession;
        this.qm = mQSession.qm;
        this.resource = mQXAResource;
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    public MQXASession(MQConnection mQConnection, MQQueueManager mQQueueManager, MQSession mQSession, MQXAResource mQXAResource) throws JMSException {
        super(mQConnection, mQQueueManager, true, 0);
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        this.qm = mQQueueManager;
        this.session = mQSession;
        this.resource = mQXAResource;
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    public XAResource getXAResource() {
        return this.resource;
    }

    public boolean getTransacted() throws JMSException {
        return true;
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        try {
            ((MQXAResource)this.resource).close();
        }
        catch (XAException xAException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS2012");
            jMSException.setLinkedException((Exception)xAException);
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Trace.trace(this, "linked exception: " + xAException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "close");
            }
        }
    }

    void acknowledge() throws JMSException {
        throw ConfigEnvironment.newException("MQJMS1016", "MQXASession.acknowledge");
    }

    public void commit() throws JMSException {
        String string = ConfigEnvironment.getErrorMessage("MQJMS1069");
        throw new TransactionInProgressException(string);
    }

    public void rollback() throws JMSException {
        String string = ConfigEnvironment.getErrorMessage("MQJMS1069");
        throw new TransactionInProgressException(string);
    }

    public void recover() throws JMSException {
        String string = ConfigEnvironment.getErrorMessage("MQJMS1069");
        throw new IllegalStateException(string);
    }

    public Session getSession() throws JMSException {
        return this.session;
    }

    boolean isStarted() {
        return this.session.isStarted();
    }

    boolean isStopped() {
        return this.session.isStopped();
    }
}

