/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQSPIQueue;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQMessageGroup;
import com.ibm.mq.jms.MQMessageReference;
import com.ibm.mq.jms.MQQueueAgent;
import com.ibm.mq.jms.MQQueueAgentThread;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;

class MQQueueAgentThread1Impl
extends MQQueueAgentThread {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQQueueAgentThread1Impl.java, jms, j600, j600-101-060328 1.23.1.1 05/05/25 15:45:16";
    private static long EOQTimeout = 3000L;
    private MQMessageGroup seenLastSweep = new MQMessageGroup();
    private MQMessageGroup seenThisSweep = new MQMessageGroup();
    private boolean lastMessageWasSeen = false;
    private boolean anyAlreadySeen = false;
    private long eoqTimeoutStart = 0L;

    MQQueueAgentThread1Impl(MQQueueAgent mQQueueAgent, MQConnection mQConnection, String string, String string2) throws JMSException {
        super(mQQueueAgent, mQConnection, string, string2);
        EOQTimeout = mQConnection.getEoqTimeout();
        this.options = 8362;
        this.mqGMO = new MQGetMessageOptions(true);
    }

    MQMessageReference browse(int n, long l) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "browse");
        }
        MQMessageReference mQMessageReference = null;
        long l2 = 0L;
        try {
            boolean bl = false;
            if (this.startSweep) {
                bl = true;
                l2 = System.currentTimeMillis();
                this.sweepStartedTime = System.currentTimeMillis();
                this.startSweep = false;
                this.sweepTimeoutStart = 0L;
                this.eoqTimeoutStart = -1L;
                this.lastMessageWasSeen = this.anyAlreadySeen;
                this.anyAlreadySeen = false;
                MQMessageGroup mQMessageGroup = this.seenLastSweep;
                this.seenLastSweep = this.seenThisSweep;
                this.seenThisSweep = mQMessageGroup;
                this.seenThisSweep.clear();
            }
            boolean bl2 = false;
            while (!bl2) {
                mQMessageReference = this.browseMsg(n, bl, 0);
                bl = false;
                if (mQMessageReference != null) {
                    if ((mQMessageReference = this.makeSuitableForDelivery(n, mQMessageReference)) == null) continue;
                    bl2 = true;
                    continue;
                }
                bl2 = true;
            }
            if (mQMessageReference == null) {
                long l3;
                this.deliverNow();
                l2 = l3 = System.currentTimeMillis();
                bl2 = false;
                if (EOQTimeout != -1L) {
                    if (this.eoqTimeoutStart == -1L) {
                        this.eoqTimeoutStart = l3;
                    } else if (l3 - this.eoqTimeoutStart >= EOQTimeout) {
                        bl2 = true;
                        this.startSweep = true;
                    }
                }
                while (!bl2) {
                    int n2 = (int)(l - (l2 - l3));
                    if (EOQTimeout != -1L && (long)n2 > EOQTimeout) {
                        n2 = (int)EOQTimeout;
                    }
                    if (n2 < 1000) {
                        n2 = 1000;
                    }
                    if ((mQMessageReference = this.browseMsg(n, false, n2)) != null) {
                        if ((mQMessageReference = this.makeSuitableForDelivery(n, mQMessageReference)) != null) {
                            bl2 = true;
                            continue;
                        }
                        mQMessageReference = null;
                        l2 = System.currentTimeMillis();
                        if (l - (l2 - l3) > 0L) continue;
                        bl2 = true;
                        continue;
                    }
                    bl2 = true;
                    mQMessageReference = null;
                }
            }
            if (mQMessageReference == null) {
                this.deliverNow();
                this.startSweep = true;
            } else if (this.sweepTimeoutStart != 0L) {
                if (l2 == 0L) {
                    l2 = System.currentTimeMillis();
                }
                if (l2 > this.sweepTimeoutStart + 30000L) {
                    this.deliverNow();
                    this.startSweep = true;
                }
            } else {
                if (l2 == 0L) {
                    l2 = System.currentTimeMillis();
                }
                this.sweepTimeoutStart = l2;
            }
            MQMessageReference mQMessageReference2 = mQMessageReference;
            return mQMessageReference2;
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.exception(this, "browse caught", (Throwable)mQException);
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1025");
            jMSException.setLinkedException((Exception)mQException);
            throw jMSException;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "browse forwarding", (Throwable)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "browse");
            }
        }
    }

    private MQMessageReference browseMsg(int n, boolean bl, int n2) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "browseMsg");
        }
        MQMessageReference mQMessageReference = null;
        try {
            int n3;
            boolean bl2;
            if (bl) {
                this.mqGMO.options &= 0xFFFFFFDF;
                this.mqGMO.options |= 0x10;
            } else {
                this.mqGMO.options &= 0xFFFFFFEF;
                this.mqGMO.options |= 0x20;
            }
            boolean bl3 = n == 0 ? false : !this.lastMessageWasSeen;
            boolean bl4 = bl2 = n == 0;
            this.mqGMO.options = bl3 ? (this.mqGMO.options &= 0xFFFFFFBF) : (this.mqGMO.options |= 0x40);
            if (n2 == 0) {
                this.mqGMO.options &= 0xFFFFFFFE;
            } else {
                this.mqGMO.options |= 1;
                this.mqGMO.waitInterval = n2;
            }
            MQJMSMessage mQJMSMessage = new MQJMSMessage();
            if (Trace.isOn) {
                Trace.trace(this, "About to browse message:");
                Trace.trace(this, (this.mqGMO.options & 0x40) == 0 ? "- browsing full message" : "- browsing with truncation");
                Trace.trace(this, (this.mqGMO.options & 0x20) == 0 ? "- browsing first message" : "- browsing next message");
                Trace.trace(this, (this.mqGMO.options & 1) == 0 ? "- browsing without waiting" : "- browsing with wait for " + this.mqGMO.waitInterval);
                Trace.trace(this, bl2 ? "- using batched-get" : "- using non-batched get");
            }
            if (bl2) {
                n3 = ((MQSPIQueue)this.mqQueue).spiBatchedGetNoExc(mQJMSMessage, this.mqGMO, 0);
                if (n3 == 2079) {
                    n3 = 0;
                }
            } else if (bl3) {
                n3 = this.mqQueue.getMsg2NoExc(mQJMSMessage, this.mqGMO);
            } else {
                n3 = this.mqQueue.getMsg2NoExc(mQJMSMessage, this.mqGMO, 0);
                if (n3 == 2079) {
                    n3 = 0;
                }
            }
            if (n3 == 2033) {
                if (Trace.isOn) {
                    Trace.trace(this, "MQRC_NO_MSG_AVAILABLE: returning null");
                }
                MQMessageReference mQMessageReference2 = null;
                return mQMessageReference2;
            }
            if (n3 != 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Unexpected reason code " + n3);
                }
                throw new MQException(2, n3, this);
            }
            if (Trace.isOn) {
                Trace.trace(this, "Browsed message");
            }
            mQMessageReference = new MQMessageReference(this.jmsSession);
            mQMessageReference.setMQJMSMessage(mQJMSMessage, bl3 ? 2 : 0);
            MQMessageReference mQMessageReference3 = mQMessageReference;
            return mQMessageReference3;
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.exception(this, "browseMsg passing ", (Throwable)mQException);
            }
            throw mQException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "browseMsg");
            }
        }
    }

    private MQMessageReference makeSuitableForDelivery(int n, MQMessageReference mQMessageReference) throws MQException, JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "makeSuitableForDelivery");
        }
        MQJMSMessage mQJMSMessage = null;
        try {
            int n2;
            MQMessageReference mQMessageReference2;
            MQMessageReference mQMessageReference3 = this.seenLastSweep.removeMessage(mQMessageReference);
            boolean bl = false;
            if (mQMessageReference3 == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "New message");
                }
                mQMessageReference2 = mQMessageReference;
                mQMessageReference.setBrowseTime(this.sweepStartedTime);
                mQJMSMessage = mQMessageReference.getMQJMSMessage();
                MQMessageReference mQMessageReference4 = (MQMessageReference)mQMessageReference.clone();
                this.seenThisSweep.addMessage(mQMessageReference4);
                this.lastMessageWasSeen = false;
                bl = true;
            } else {
                int n3;
                if (Trace.isOn) {
                    Trace.trace(this, "Previously seen message");
                }
                this.lastMessageWasSeen = true;
                this.anyAlreadySeen = true;
                int n4 = mQMessageReference3.getBackoutCount();
                n2 = mQMessageReference.getBackoutCount();
                boolean bl2 = n2 != n4;
                int n5 = mQMessageReference3.getDataQuantity();
                if (n5 == (n3 = mQMessageReference.getDataQuantity()) && null != mQMessageReference3.getMQJMSMessage() || n5 == 1 && n3 == 0 || n5 == 2) {
                    if (Trace.isOn) {
                        Trace.trace(this, "using old MessageReference.");
                    }
                    mQMessageReference2 = mQMessageReference3;
                    if (bl2) {
                        mQMessageReference2.setBackoutCount(n2);
                    }
                } else {
                    if (Trace.isOn) {
                        Trace.trace(this, "using new MessageReference.");
                    }
                    mQMessageReference.setBrowseTime(mQMessageReference3.getBrowseTime());
                    mQMessageReference2 = mQMessageReference;
                }
                MQMessageReference mQMessageReference5 = mQMessageReference2.getDataQuantity() != 0 ? (MQMessageReference)mQMessageReference2.clone() : mQMessageReference2;
                this.seenThisSweep.addMessage(mQMessageReference5);
                if (mQMessageReference3.isWanted() && (bl2 || mQMessageReference3.getBrowseTime() + 60000L <= this.sweepStartedTime)) {
                    bl = true;
                    mQMessageReference2.setBrowseTime(this.sweepStartedTime);
                } else {
                    mQMessageReference2 = null;
                }
            }
            if (Trace.isOn) {
                if (bl) {
                    Trace.trace(this, "Message is suitable for delivery");
                } else {
                    Trace.trace(this, "Message not suitable for delivery");
                }
            }
            if (bl && n != 0 && mQMessageReference2.getDataQuantity() != 2) {
                if (Trace.isOn) {
                    Trace.trace(this, "Browsing full message");
                }
                this.mqGMO.options &= 0xFFFFFF9E;
                this.mqGMO.options |= 0x10;
                this.mqGMO.matchOptions = 3;
                MQJMSMessage mQJMSMessage2 = mQMessageReference2.getMQJMSMessage();
                if (null == mQJMSMessage2) {
                    if (null != mQJMSMessage) {
                        mQJMSMessage2 = mQJMSMessage;
                    } else {
                        mQJMSMessage2 = new MQJMSMessage();
                        mQJMSMessage2.setMessageId(mQMessageReference2.getMessageId());
                        mQJMSMessage2.setCorrelationId(mQMessageReference2.getCorrelId());
                    }
                }
                n2 = this.mqQueue.getMsg2NoExc(mQJMSMessage2, this.mqGMO);
                this.mqGMO.matchOptions = 0;
                if (n2 == 0) {
                    mQMessageReference2.setMQJMSMessage(mQJMSMessage2, 2);
                } else if (n2 == 2033) {
                    if (Trace.isOn) {
                        Trace.trace(this, "MQRC_NO_MSG_AVAILABLE: message has been removed from queue");
                    }
                    mQMessageReference2 = null;
                } else {
                    throw new MQException(2, n2, this);
                }
            }
            MQMessageReference mQMessageReference6 = mQMessageReference2;
            return mQMessageReference6;
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.exception(this, "makeSuitableForDelivery passing on ", (Throwable)mQException);
            }
            throw mQException;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "makeSuitableForDelivery passing on ", (Throwable)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "makeSuitableForDelivery");
            }
        }
    }

    boolean updateConfig() throws JMSException {
        if (this.startSweep) {
            this.seenThisSweep.clear();
            return true;
        }
        return false;
    }

    void setEOQTimeout(long l) {
        if ((l < -2L || l > 30000L) && Trace.isOn) {
            Trace.trace(this, "timeout being set to possible invalid value: " + l);
        }
        EOQTimeout = l;
    }

    long getEOQTimeout() {
        return EOQTimeout;
    }
}

