/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQMessageSelector;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MessageReference;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.jms.JMSException;
import javax.jms.Message;

class MQMessageReference
implements MessageReference,
Cloneable {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#)  jms/com/ibm/mq/jms/MQMessageReference.java, jms, j600, j600-101-060328 1.26.1.1 05/05/25 15:45:24";
    private static final long prime1 = 2147483587L;
    private static final long prime2 = Integer.MAX_VALUE;
    private JMSMessage jmsMessage = null;
    private MQJMSMessage mqjmsMessage = null;
    private byte[] messageId = null;
    private byte[] correlId = null;
    private int hashcode = -1;
    private boolean wanted = true;
    private String referenceQueue = null;
    private int domain = 0;
    private int version = 1;
    private static final String FLATTENED_HEADER = "MQMR";
    protected static final int MSGREF_VERSION_1 = 1;
    protected static final int MSGREF_VERSION_2 = 2;
    private byte[] msgToken = null;
    private static final int MSGREF_DOMAIN_PTP = 0;
    private static final int MSGREF_DOMAIN_PS = 1;
    private int dataQuantity = 0;
    private long browseTime;
    private MQSession session = null;
    private int backoutCount = 0;

    MQMessageReference(MQSession mQSession) {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        this.session = mQSession;
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    private MQMessageReference() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    MQMessageReference(MQSession mQSession, byte[] byArray) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "constructor (from bytearray)");
            Trace.trace(this, sccsid);
        }
        this.session = mQSession;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            String string = null;
            this.messageId = new byte[24];
            this.correlId = new byte[24];
            this.msgToken = new byte[16];
            byte[] byArray2 = new byte[4];
            dataInputStream.readFully(byArray2);
            string = new String(byArray2, "ASCII");
            if (!FLATTENED_HEADER.equals(string)) {
                if (Trace.isOn) {
                    Trace.trace(this, "Invalid MessageReferenceHeader. Throwing exception");
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1096");
                if (!Trace.isOn) throw jMSException;
                Trace.exception(this, "recreateMessageReference", (Throwable)jMSException);
                throw jMSException;
            }
            this.version = dataInputStream.readInt();
            this.domain = dataInputStream.readInt();
            byte[] byArray3 = new byte[48];
            byteArrayInputStream.read(byArray3, 0, 48);
            this.referenceQueue = new String(byArray3, "ASCII");
            switch (this.version) {
                case 2: {
                    byteArrayInputStream.read(this.msgToken, 0, 16);
                }
                case 1: {
                    byteArrayInputStream.read(this.messageId, 0, 24);
                    byteArrayInputStream.read(this.correlId, 0, 24);
                    return;
                }
                default: {
                    if (Trace.isOn) {
                        Trace.trace(this, "Error. Unrecognised messageReference version.");
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1098");
                    if (!Trace.isOn) throw jMSException;
                    Trace.exception(this, "flatten", (Throwable)jMSException);
                    throw jMSException;
                }
            }
        }
        catch (IOException iOException) {
            if (Trace.isOn) {
                Trace.trace(this, "IOException thrown while recreating MessageReference");
                Trace.exception(this, "recreateMessageReference", (Throwable)iOException);
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1096");
            jMSException.setLinkedException((Exception)iOException);
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "constructor (from bytearray)");
            }
        }
    }

    MQJMSMessage getMQJMSMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "getMQJMSMessage");
            if (Trace.isOn) {
                Trace.exit(this, "getMQJMSMessage");
            }
        }
        return this.mqjmsMessage;
    }

    void setMQJMSMessage(MQJMSMessage mQJMSMessage, int n) {
        if (Trace.isOn) {
            Trace.entry(this, "setMQJMSMessage");
        }
        this.mqjmsMessage = mQJMSMessage;
        this.jmsMessage = null;
        this.dataQuantity = n;
        if (this.mqjmsMessage != null) {
            if (this.mqjmsMessage.getMessageId() != null) {
                this.messageId = this.mqjmsMessage.getMessageId();
                this.correlId = this.mqjmsMessage.getCorrelationId();
                this.hashcode = 0;
                byte[] byArray = new byte[8];
                int n2 = 0;
                while (n2 + 8 <= this.messageId.length) {
                    System.arraycopy(this.messageId, n2, byArray, 0, 8);
                    this.hashcode ^= this.hash8bytes(byArray);
                    n2 += 8;
                }
            }
            this.backoutCount = this.mqjmsMessage.getBackoutCount();
        } else {
            this.messageId = null;
            this.correlId = null;
            this.hashcode = -1;
            this.backoutCount = 0;
        }
        if (Trace.isOn) {
            Trace.exit(this, "setMQJMSMessage");
        }
    }

    private int hash8bytes(byte[] byArray) {
        int n = byArray[0] & 0xFF;
        int n2 = (byArray[1] & 0xFF) << 8;
        int n3 = (byArray[2] & 0xFF) << 16;
        long l = (long)(byArray[3] & 0xFF) << 24;
        long l2 = (long)(n + n2 + n3) + l | 0x40404040L;
        l2 *= 2147483587L;
        l2 = l2 >>> 32 ^ l2 & 0xFFFFFFFFL;
        n = byArray[4] & 0xFF;
        n2 = (byArray[5] & 0xFF) << 8;
        n3 = (byArray[6] & 0xFF) << 16;
        l = (long)(byArray[7] & 0xFF) << 24;
        long l3 = (long)(n + n2 + n3) + l | 0x40404040L;
        l3 *= Integer.MAX_VALUE;
        l3 = l3 >>> 32 ^ l3 & 0xFFFFFFFFL;
        l2 *= l3;
        l2 = l2 >>> 32 ^ l2 & 0xFFFFFFFFL;
        return (int)l2;
    }

    byte[] getMessageId() {
        byte[] byArray = null;
        if (Trace.isOn) {
            Trace.entry(this, "getMessageId");
        }
        if (this.messageId != null) {
            byArray = new byte[this.messageId.length];
            System.arraycopy(this.messageId, 0, byArray, 0, this.messageId.length);
        }
        if (Trace.isOn) {
            Trace.exit(this, "getMessageId");
        }
        return byArray;
    }

    byte[] getCorrelId() {
        byte[] byArray = null;
        if (Trace.isOn) {
            Trace.entry(this, "getCorrelId");
        }
        if (this.correlId != null) {
            byArray = new byte[this.correlId.length];
            System.arraycopy(this.correlId, 0, byArray, 0, this.correlId.length);
        }
        if (Trace.isOn) {
            Trace.exit(this, "getCorrelId");
        }
        return byArray;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof MQMessageReference) {
            MQMessageReference mQMessageReference = (MQMessageReference)object;
            if (mQMessageReference.messageId != null && this.messageId != null && mQMessageReference.hashcode == this.hashcode && mQMessageReference.messageId.length == this.messageId.length) {
                bl = Arrays.equals(mQMessageReference.messageId, this.messageId);
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean matches(MQMessageSelector mQMessageSelector) throws JMSException {
        boolean bl = false;
        if (Trace.isOn) {
            Trace.entry(this, "matches");
        }
        try {
            try {
                bl = mQMessageSelector.isSelected(this.getJMSMessage(), this.mqjmsMessage);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var5_3 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.trace(this, "Match result " + bl);
            Trace.exit(this, "matches");
            throw throwable;
        }
        Trace.trace(this, "Match result " + bl);
        Trace.exit(this, "matches");
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nmessageId=");
        stringBuffer.append(Utils.bytesToHex(this.messageId));
        stringBuffer.append("\ncorrelId =");
        stringBuffer.append(Utils.bytesToHex(this.correlId));
        stringBuffer.append("\njmsMessage=" + (this.jmsMessage == null ? "unset" : "set"));
        stringBuffer.append("\nmqjmsMessage=" + (this.mqjmsMessage == null ? "null" : this.mqjmsMessage.toString()));
        return stringBuffer.toString();
    }

    public int getDataQuantity() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getDataQuantity");
            Trace.trace(this, "dataQuantity = " + this.dataQuantity);
            Trace.exit(this, "getDataQuantity");
        }
        return this.dataQuantity;
    }

    JMSMessage getJMSMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getJMSMessage");
        }
        try {
            switch (this.dataQuantity) {
                case 0: {
                    if (Trace.isOn) {
                        Trace.trace(this, "dataQuantity is NO_DATA; returning null");
                    }
                    JMSMessage jMSMessage = null;
                    return jMSMessage;
                }
                case 1: {
                    if (Trace.isOn) {
                        Trace.trace(this, "dataQuantity is HEADER_DATA; NOT SUPPORTED");
                    }
                    throw new IllegalStateException("MQMessageReference has only HEADER_DATA");
                }
                case 2: {
                    if (this.jmsMessage != null) {
                        if (Trace.isOn) {
                            Trace.trace(this, "dataQuantity is FULL_DATA; returning existing message");
                        }
                        JMSMessage jMSMessage = this.jmsMessage;
                        return jMSMessage;
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "dataQuantity is FULL_DATA; returning new message");
                    }
                    JMSMessage jMSMessage = this.jmsMessage = this.mqjmsMessage.createJMSMessage(this.session);
                    return jMSMessage;
                }
            }
            try {
                if (Trace.isOn) {
                    Trace.trace(this, "Bad dataQuantity " + this.dataQuantity);
                }
                throw new IllegalStateException("MQMessageReference has bad data quantity" + this.dataQuantity);
            }
            catch (IOException iOException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS0006");
                jMSException.setLinkedException((Exception)iOException);
                throw jMSException;
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getJMSMessage");
            }
        }
    }

    public Message getMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getMessage");
        }
        try {
            switch (this.dataQuantity) {
                case 0: {
                    if (Trace.isOn) {
                        Trace.trace(this, "dataQuantity is NO_DATA; returning null");
                    }
                    Message message = null;
                    return message;
                }
                case 1: {
                    if (Trace.isOn) {
                        Trace.trace(this, "dataQuantity is HEADER_DATA; NOT SUPPORTED");
                    }
                    throw new IllegalStateException("MQMessageReference has only HEADER_DATA");
                }
                case 2: {
                    if (this.jmsMessage == null) {
                        if (Trace.isOn) {
                            Trace.trace(this, "dataQuantity is FULL_DATA but message not parsed yet; ERROR");
                        }
                        throw new IllegalStateException("MQMessageReference message not parsed yet");
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "dataQuantity is FULL_DATA; returning existing message");
                    }
                    JMSMessage jMSMessage = this.jmsMessage;
                    return jMSMessage;
                }
            }
            if (Trace.isOn) {
                Trace.trace(this, "Bad dataQuantity " + this.dataQuantity);
            }
            throw new IllegalStateException("MQMessageReference has bad data quantity" + this.dataQuantity);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getMessage");
            }
        }
    }

    public Object clone() {
        if (Trace.isOn) {
            Trace.entry(this, "clone");
        }
        MQMessageReference mQMessageReference = new MQMessageReference();
        mQMessageReference.session = this.session;
        mQMessageReference.messageId = this.messageId;
        mQMessageReference.correlId = this.correlId;
        mQMessageReference.hashcode = this.hashcode;
        mQMessageReference.referenceQueue = this.referenceQueue;
        mQMessageReference.domain = this.domain;
        mQMessageReference.version = this.version;
        mQMessageReference.dataQuantity = 0;
        mQMessageReference.jmsMessage = null;
        mQMessageReference.mqjmsMessage = null;
        mQMessageReference.wanted = this.wanted;
        mQMessageReference.backoutCount = this.backoutCount;
        mQMessageReference.browseTime = this.browseTime;
        if (Trace.isOn) {
            Trace.exit(this, "clone");
        }
        return mQMessageReference;
    }

    public byte[] flatten() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "flatten");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (Trace.isOn) {
                Trace.trace(this, "about to flatten a version " + Integer.toString(this.version) + " messageReference.");
            }
            byteArrayOutputStream.write(FLATTENED_HEADER.getBytes("ASCII"));
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(this.version);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(this.domain);
            if (Trace.isOn) {
                Trace.trace(this, "flattening queueName.");
            }
            String string = MQSESSION.setStringToLength(this.referenceQueue, 48);
            byteArrayOutputStream.write(string.getBytes("ASCII"));
            switch (this.version) {
                case 2: {
                    if (Trace.isOn) {
                        Trace.trace(this, "flattening msgToken as identifier.");
                    }
                    byteArrayOutputStream.write(this.msgToken);
                }
                case 1: {
                    if (Trace.isOn) {
                        Trace.trace(this, "flattening messageId and CorrelId as identifiers.");
                    }
                    byteArrayOutputStream.write(this.messageId);
                    byteArrayOutputStream.write(this.correlId);
                    break;
                }
                default: {
                    if (Trace.isOn) {
                        Trace.trace(this, "Error. Unrecognised messageReference version.");
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1098");
                    if (Trace.isOn) {
                        Trace.exception(this, "flatten", (Throwable)jMSException);
                    }
                    throw jMSException;
                }
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            if (Trace.isOn) {
                Trace.trace(this, "exception thrown while attempting to write to byte[]");
                Trace.exception(this, "flatten", (Throwable)iOException);
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1098");
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via exception");
            }
            throw jMSException;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "flatten");
            }
        }
    }

    public void setVersion(int n) {
        if (n != 1 && Trace.isOn) {
            Trace.trace(this, "Invalid MessageReference version being set! This is not fully implemented yet.");
        }
        this.version = n;
    }

    void setReferenceQueue(String string) {
        if (Trace.isOn) {
            Trace.trace(this, "Setting referenceQueue name to '" + (string == null ? "null" : string) + "'");
        }
        this.referenceQueue = string;
    }

    String getReferenceQueue() {
        if (Trace.isOn) {
            Trace.trace(this, "Returning referenceQueue = '" + (this.referenceQueue == null ? "null" : this.referenceQueue) + "'");
        }
        return this.referenceQueue;
    }

    boolean isWanted() {
        return this.wanted;
    }

    void setIsWanted(boolean bl) {
        this.wanted = bl;
    }

    int getDomain() {
        return this.domain;
    }

    void setDomain(int n) {
        this.domain = n;
    }

    void setBrowseTime(long l) {
        this.browseTime = l;
    }

    long getBrowseTime() {
        return this.browseTime;
    }

    void setBackoutCount(int n) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setBackoutCount");
        }
        try {
            this.backoutCount = n;
            if (this.mqjmsMessage != null) {
                this.mqjmsMessage.setBackoutCount(n);
            }
            if (this.jmsMessage != null) {
                this.jmsMessage.setJMSRedelivered(n != 0);
                this.jmsMessage._setJMSXDeliveryCountFromInt(n + 1);
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "setBackoutCount", (Throwable)jMSException);
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setBackoutCount");
            }
        }
    }

    int getBackoutCount() {
        if (Trace.isOn) {
            Trace.entry(this, "getBackoutCount");
            Trace.exit(this, "getBackoutCount");
        }
        return this.backoutCount;
    }

    public void setMsgToken(byte[] byArray) {
        if (this.msgToken == null) {
            this.msgToken = new byte[16];
        }
        for (int i = 0; i < 16; ++i) {
            this.msgToken[i] = byArray[i];
        }
    }

    public byte[] getMsgToken() {
        return this.msgToken;
    }

    public int getVersion() {
        return this.version;
    }
}

