/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.dev.module.tasks;

import ch.e2e.builder.base.error.BuilderWarning;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.error.TaskWarning;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.utils.JaxbUtils;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import ch.e2e.builder.compiler.serviceRepository.DevStackRemover;
import ch.e2e.builder.compiler.serviceRepository.ServiceRepositoryService;
import ch.e2e.builder.compiler.serviceRepository.stack.DevStackOptions;
import ch.e2e.builder.compiler.serviceRepository.stack.DevStackResponse;
import ch.e2e.builder.compiler.utils.EnvUtils;
import com.scheer.pas.compiler.dev.api.DevStartEnvironment;
import com.scheer.pas.compiler.dev.module.tasks.DevEnvironmentTask;
import com.scheer.pas.compiler.dev.module.tasks.xuml.DevXumlPortsTask;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;

public class DevStartEnvironmentTask
extends DevEnvironmentTask {
    private static final String PROJECT_ID_ENV_KEY = "PROJECT_ID";
    private static final String PROFILE_ID_ENV_KEY = "PROFILE_ID";
    private static final String OPENSEARCH_HOSTS_ENV_KEY = "OPENSEARCH_HOSTS";
    private static final String OPENSEARCH_HOSTS = EnvUtils.get("OPENSEARCH_HOSTS", "");
    private static final String OPENSEARCH_USER_ENV_KEY = "OPENSEARCH_USER";
    private static final String OPENSEARCH_USER = EnvUtils.get("OPENSEARCH_USER", "");
    private static final String OPENSEARCH_PASSWORD_ENV_KEY = "OPENSEARCH_PASSWORD";
    private static final String OPENSEARCH_PASSWORD = EnvUtils.get("OPENSEARCH_PASSWORD", "");
    public static final String KEYCLOAK_URI = EnvUtils.get("KEYCLOAK_URI", "http://pas-keycloak:8080/pas/keycloak");
    private static final String KEYCLOAK_REALM = EnvUtils.get("KEYCLOAK_REALM", "PAS");
    public static final String XUML_DEVCONTAINER_ENV_KEY_PREFIX = "XUML_DEVCONTAINER_";
    public static final String NG_DEVCONTAINER_ENV_KEY_PREFIX = "NG_DEVCONTAINER_";

    public static Boolean select(String id) {
        return id.equals("dev.start.environment");
    }

    public DevStartEnvironmentTask(SourceManager sourceManager, String id, ServiceRepositoryService repositoryService, Client client) {
        super(sourceManager, id, repositoryService, client);
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add("dev.xuml.ports.xml");
        result.add(Files.project_xml);
        return result;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        this.removeOldDevStacks();
        this.createNewDevStack();
    }

    private void removeOldDevStacks() {
        try {
            List stackRemovers = Arrays.stream(this.repositoryService.getDevStacksForProject(this.getProjectId())).map(devStack -> new DevStackRemover((DevStackResponse)devStack, this.repositoryService)).collect(Collectors.toList());
            for (DevStackRemover stackRemover : stackRemovers) {
                try {
                    Response response = stackRemover.getResponse();
                    Response.StatusType statusInfo = response.getStatusInfo();
                    if (statusInfo.getStatusCode() / 100 == 2 || statusInfo.getStatusCode() == 404) continue;
                    Logging.logger.warning(String.format("Failed to remove old dev stack '%s' (%d - %s)", stackRemover.getDevStackId(), statusInfo.getStatusCode(), statusInfo.getReasonPhrase()));
                }
                catch (Exception e) {
                    Logging.logger.warning(String.format("Failed to remove old dev stacks '%s' (%s)", stackRemover.getDevStackId(), e.getMessage()));
                }
            }
        }
        catch (Exception e) {
            Logging.logger.warning(String.format("Failed to remove old dev stacks for project '%s'", this.getProjectId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewDevStack() {
        DevStartEnvironment.Result result = new DevStartEnvironment.Result();
        try {
            XumlProject project = this.getProject();
            Map<String, String> env = System.getenv();
            DevStackOptions options = new DevStackOptions().setXumlPorts(this.getDevXumlPorts()).env("KEYCLOAK_URI", KEYCLOAK_URI).env("KEYCLOAK_REALM", KEYCLOAK_REALM).env(PROJECT_ID_ENV_KEY, project.getProjectId()).env(PROFILE_ID_ENV_KEY, project.getProfileId()).env(OPENSEARCH_HOSTS_ENV_KEY, OPENSEARCH_HOSTS).env(OPENSEARCH_USER_ENV_KEY, OPENSEARCH_USER).env(OPENSEARCH_PASSWORD_ENV_KEY, OPENSEARCH_PASSWORD).xumlEnv(EnvUtils.selectEnv(XUML_DEVCONTAINER_ENV_KEY_PREFIX, env)).angularEnv(EnvUtils.selectEnv(NG_DEVCONTAINER_ENV_KEY_PREFIX, env));
            result.setDevStackResponse(this.repositoryService.createDevStack(this.getProjectId(), options));
        }
        catch (ClientErrorException e) {
            if (e.getResponse().getStatus() == 429) {
                this.getErrorHandler().warning((BuilderWarning)new TaskWarning("DEVSTACK0003"));
            } else {
                this.getErrorHandler().warning((BuilderWarning)new TaskWarning("DEVSTACK0002"));
            }
            result.setError((Exception)((Object)e));
            Logging.logger.info(String.format("%s - Exception while creating new devstack: %s", this.getId(), e.getMessage()));
        }
        catch (Exception e) {
            this.getErrorHandler().warning((BuilderWarning)new TaskWarning("DEVSTACK0002"));
            result.setError(e);
            Logging.logger.info(String.format("%s - Exception while creating new devstack: %s", this.getId(), e.getMessage()));
        }
        finally {
            this.jsonDocument = result;
            JaxbUtils.marshalXml((Object)result, this.getDestinationFile());
        }
    }

    private List<Integer> getDevXumlPorts() {
        return ((DevXumlPortsTask)this.getSourceManager().getSource("dev.xuml.ports.xml")).getJsonDocument(DevXumlPortsTask.Result.class).getPorts();
    }

    private String getProjectId() {
        return this.getSourceManager().getProjectFolder().getName();
    }

    private XumlProject getProject() {
        return ((JsonDocumentSource)this.getSourceManager().getSource(Files.project_xml)).getJsonDocument(XumlProject.class);
    }

    @Override
    public boolean isUpToDate() {
        return super.isUpToDate() && !this.getErrorHandler().hasErrors() && this.checkHealth().healthy;
    }

    private DevEnvironmentTask.HealthCheckResult checkHealth() {
        try {
            String projectId = this.getProjectId();
            DevStackResponse[] devStacks = this.repositoryService.getDevStacksForProject(projectId);
            String message = null;
            if (devStacks.length == 0) {
                message = String.format("No dev stack found for project '%s'", projectId);
            } else if (devStacks.length > 1) {
                message = String.format("More than one dev stack found for project '%s'", projectId);
            }
            return new DevEnvironmentTask.HealthCheckResult(message);
        }
        catch (Exception e) {
            return new DevEnvironmentTask.HealthCheckResult(e);
        }
    }
}

