/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.models.EBMElement;
import ch.e2e.builder.compiler.models.EBMElementInterface;
import ch.e2e.builder.compiler.models.EBMHelper;
import ch.e2e.builder.compiler.models.EBMPackage;
import ch.e2e.builder.compiler.models.EBMStereotype;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.PackagesFactory;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.List;

public class DefaultPackagesFactory
extends PackagesFactory {
    private BridgePackage root;

    public DefaultPackagesFactory(Helpers helpers) {
        super(helpers);
    }

    @Override
    public List<BridgePackage> getRepositoryPackages() {
        return null;
    }

    @Override
    public List<BridgePackage> getInternalRootPackages() {
        return null;
    }

    @Override
    protected BridgePackage findPackage(String key, BridgeStereotype stereotype) {
        BridgePackage result;
        int index;
        if (!key.startsWith(this.getRootPackage().getName())) {
            key = this.getRootPackage().getName() + '/' + key;
        }
        if ((index = key.lastIndexOf(47)) == -1) {
            result = this.createPackage(key, this.getRootPackage(), stereotype);
        } else {
            String newKey = key.substring(0, index);
            BridgePackage parent = this.internalGetPackage(newKey);
            while (parent == null) {
                index = newKey.lastIndexOf(47, index);
                newKey = newKey.substring(0, index);
                parent = this.internalGetPackage(newKey);
            }
            result = this.createPackages(key.substring(index + 1), parent, stereotype);
        }
        return result;
    }

    @Override
    public BridgePackage getComponentDiagramPackage() {
        return this.getPackage("Component View", this.getHelpers().getStereotypeFactory().getStereotype("Repository"));
    }

    @Override
    public BridgePackage getDeploymentDiagramPackage() {
        return this.getPackage("File View", this.getHelpers().getStereotypeFactory().getStereotype("Repository"));
    }

    @Override
    public BridgePackage createRootPackage() {
        BridgePackage root = new BridgePackage(this.getRootPackage().getName(), null, this.getHelpers());
        root.setKey(this.getRootPackage().getKey());
        return root;
    }

    @Override
    protected BridgePackage createPackage(String name, BridgePackage parent, BridgeStereotype stereotype) {
        BridgePackage bridgePackage = super.createPackage(name, parent, stereotype);
        Object parentReference = parent.getReference();
        if (parent == this.getRootPackage()) {
            parentReference = EBMHelper.getModels();
        }
        if (parentReference instanceof EBMPackage) {
            EBMPackage ebmPackage = (EBMPackage)((EBMPackage)parentReference).find(EBMPackage.class, name);
            bridgePackage.setReference(ebmPackage);
        }
        return bridgePackage;
    }

    @Override
    public void createReference(BridgePackage newPackage) throws Exception {
    }

    @Override
    public void setElementPackage(UmlElement umlElement, Object aPackage) {
        if (aPackage != null) {
            String key = DefaultPackagesFactory.createPackageKey((EBMElement)((EBMPackage)aPackage));
            umlElement.setOwningPackage(this.getPackage(key));
        }
    }

    @Override
    public void setStereotypePackage(BridgeStereotype bridgeStereotype) {
        EBMStereotype stereotype = (EBMStereotype)bridgeStereotype.getReference();
        EBMElement owningPackage = stereotype.getParent();
        if (owningPackage != null) {
            BridgePackage bridgePackage = this.getPackage(DefaultPackagesFactory.createPackageKey(owningPackage));
            bridgeStereotype.setOwningPackage(bridgePackage);
        }
    }

    private static String createPackageKey(EBMElement ebmPackage) {
        String key = ebmPackage.getName();
        while (ebmPackage.getParent() != null && ebmPackage.getParent().getName() != null) {
            ebmPackage = ebmPackage.getParent();
            key = ebmPackage.getName() + '/' + key;
        }
        return key;
    }

    @Override
    public BridgePackage getRootPackage() {
        if (this.root == null) {
            this.root = new BridgePackage("Data", null, this.getHelpers());
            this.root.setKey("Data");
            this.addPackage(this.root);
        }
        return this.root;
    }

    public void setElementPackageFromPackageable(UmlElement umlElement, EBMElementInterface ebmElement) {
        if (ebmElement.getParent() != null) {
            this.setElementPackage(umlElement, ebmElement.getParent());
        }
    }
}

