/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.ClassifierElement;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BridgeComponent
extends ClassifierElement {
    public BridgeComponent(String name, Comment description, BridgeStereotype stereotype, Helpers helpers) {
        super(name, description, stereotype, helpers);
    }

    public BridgeComponent(String name, BridgeStereotype stereotype, Helpers helpers) {
        super(name, stereotype, helpers);
    }

    public BridgeComponent(BridgeStereotype stereotype, Helpers helpers) {
        super(stereotype, helpers);
    }

    @Override
    public void createReference() throws Exception {
        this.getHelpers().getElementHelper().createComponentReference(this);
    }

    @Override
    public Element toChildXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element element;
        if (this.getOwningPackage() == null) {
            element = ownerDocument.createElement("nestedClassifier");
            element.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:type", "uml:" + this.getBaseclass());
            element.setAttribute("visibility", "public");
            element.setAttribute("name", this.getName());
            element.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:id", this.getXmiID());
            if (this.getDescription() != null) {
                element.appendChild(this.getDescription().toXMI(ownerDocument, xmiIDFactory));
            }
            for (UmlElement umlElement : this.getChildren()) {
                element.appendChild(umlElement.toChildXMI(ownerDocument, xmiIDFactory));
            }
        } else {
            element = super.toChildXMI(ownerDocument, xmiIDFactory);
        }
        return element;
    }

    @Override
    public UmlElement createReferenceObject(HashMap<String, UmlElement> referenceObjects, UmlElement parent) {
        return new BridgeComponent(this.getName(), this.getDescription(), this.getStereotype(), this.getHelpers());
    }

    @Override
    protected String getRealizationType() {
        return "uml:ComponentRealization";
    }
}

