/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.ActionContext;
import ch.e2e.builder.compiler.uml.ActionContextProperty;
import ch.e2e.builder.compiler.uml.BridgeConstraint;
import ch.e2e.builder.compiler.uml.BridgeParameter;
import ch.e2e.builder.compiler.uml.BridgeParameterDefinition;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.Customization;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.InvalidPropertyValueException;
import ch.e2e.builder.compiler.uml.NoSuchPropertyException;
import ch.e2e.builder.compiler.uml.OperationDefinition;
import ch.e2e.builder.compiler.uml.Property;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionState
extends UmlElement {
    private Map<String, BridgeParameter> parameters;
    private ActionContext actionContext;
    private boolean editable;

    public ActionState(String name, String description, BridgeStereotype stereotype, boolean editable, Helpers helpers) {
        super(name, new Comment(description, helpers), stereotype, helpers);
        this.editable = editable;
        this.parameters = new HashMap<String, BridgeParameter>();
    }

    public ActionContext getActionContext() {
        return this.actionContext;
    }

    public void setActionContext(ActionContext actionContext) {
        this.actionContext = actionContext;
    }

    @Override
    public void setPropertyValueQuietly(String propertyName, Object value) {
        super.setPropertyValueQuietly(propertyName, value);
        this.checkContextProperty(this.getPropertyValueQuietly(propertyName));
    }

    @Override
    public void setPropertyValue(String propertyName, Object value) throws NoSuchPropertyException, InvalidPropertyValueException {
        super.setPropertyValue(propertyName, value);
        this.checkContextProperty(this.getPropertyValueQuietly(propertyName));
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public Collection<BridgeParameter> getParameters() {
        return this.parameters.values();
    }

    public BridgeParameter getParameter(String name) {
        return this.parameters.get(name);
    }

    public void addParameter(BridgeParameter parameter) {
        this.parameters.put(parameter.getName(), parameter);
        if (parameter.getDefinition() == null) {
            this.findDefintion(parameter);
        }
    }

    public boolean hasArbitraryParameters() {
        return this.getStereotype().hasArbitraryInputParams();
    }

    @Override
    void addProperty(Property property) {
        super.addProperty(property);
        if (property.getValue() instanceof ActionContextProperty) {
            ((ActionContextProperty)property.getValue()).setActionContext(this.actionContext);
        }
    }

    private void checkContextProperty(Object value) {
        if (value instanceof ActionContextProperty) {
            ((ActionContextProperty)value).setActionContext(this.actionContext);
        }
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public BridgeStereotype getGeneralizationStereotype() {
        return this.getHelpers().getStereotypeFactory().getStereotype("E2EAction");
    }

    private void findDefintion(BridgeParameter parameter) {
        Customization customization = this.getStereotype().getCustomization();
        Collection<Object> operationDefinitions = customization == null ? new ArrayList() : customization.getOperationDefinitions().values();
        for (OperationDefinition operationDefinition : operationDefinitions) {
            BridgeConstraint constraint = (BridgeConstraint)operationDefinition.getConstraint();
            if (constraint == null) {
                if (!this.setParameterDefinition(parameter, operationDefinition)) continue;
                break;
            }
            Object operationName = this.getPropertyValueQuietly(constraint.getName());
            if (!String.class.isInstance(operationName) || !operationName.equals(constraint.getSpecification().toString())) continue;
            this.setParameterDefinition(parameter, operationDefinition);
            break;
        }
    }

    private boolean setParameterDefinition(BridgeParameter parameter, OperationDefinition operationDefinition) {
        boolean result = false;
        List<BridgeParameterDefinition> parameterDefinitions = operationDefinition.getParamDefinitions();
        UmlElement typeLessDefinition = null;
        for (BridgeParameterDefinition definition : parameterDefinitions) {
            if (definition.getTypeClass() == null) {
                typeLessDefinition = definition;
                continue;
            }
            if (!definition.getTypeClass().getXmiID().equals(parameter.getTypeClass().getXmiID()) || !definition.getDirection().equals((Object)parameter.getDirection()) || !definition.getName().equals(parameter.getName())) continue;
            parameter.setDefinition(definition);
            result = true;
            break;
        }
        if (parameter.getDefinition() == null && typeLessDefinition != null && typeLessDefinition.getName().equals(parameter.getName())) {
            parameter.setDefinition((BridgeParameterDefinition)typeLessDefinition);
        }
        return result;
    }
}

