/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.uml1x;

import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.builder.compiler.document.importer.ImporterData;
import ch.e2e.builder.compiler.document.importer.ScriptImportTransaction;
import ch.e2e.builder.compiler.document.importer.uml1x.Logging;
import ch.e2e.io.ZipUtilities;
import java.io.File;
import org.w3c.dom.Document;

public class UML1xImportTransaction
extends ScriptImportTransaction {
    public static final String UML_DOCUMENT_FILE = "uml.document.file";
    private String script;

    public UML1xImportTransaction(String script) {
        this.script = script;
    }

    @Override
    protected String getScript() {
        return this.script;
    }

    @Override
    public void doTransaction(ImporterData importerData) {
        try {
            XSLTErrorHandler.getInstance().reset();
            File umlFile = (File)importerData.getSource(UML_DOCUMENT_FILE);
            Document umlSource = ZipUtilities.getZippedDocumentFromFile((File)umlFile);
            this.transform(umlSource, importerData);
        }
        catch (Exception e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(this.getClass().getName(), "doTransaction", e);
        }
    }
}

