/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.java;

import ch.e2e.bridge.server.XumlExclude;
import ch.e2e.builder.base.error.BuilderWarning;
import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.builder.compiler.document.importer.java.Attribute;
import ch.e2e.builder.compiler.document.importer.java.Completable;
import ch.e2e.builder.compiler.document.importer.java.ElementParent;
import ch.e2e.builder.compiler.document.importer.java.ImportClassLoader;
import ch.e2e.builder.compiler.document.importer.java.JavaTypeNotSupportedException;
import ch.e2e.builder.compiler.document.importer.java.Logging;
import ch.e2e.builder.compiler.document.importer.java.MapEntry;
import ch.e2e.builder.compiler.document.importer.java.Operation;
import ch.e2e.builder.compiler.document.importer.java.TypeInfo;
import ch.e2e.builder.compiler.document.importer.java.UserAbortedClassSearchException;
import ch.e2e.builder.compiler.error.JavaOperationImportWarning;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.jdp.ast.Parameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JavaClass
extends BridgeClass
implements ElementParent {
    public static final String PROPERTY_PACKAGE = "package";
    private Class<?> type;
    private final String fullName;
    private final List<Method> getter = new ArrayList<Method>();
    private final List<Method> setter = new ArrayList<Method>();
    private boolean importable = false;
    private boolean publicDefaultConstructor = false;
    private boolean initialized = false;

    public JavaClass(Class<?> clazz, Helpers helpers) {
        this(clazz, helpers.getStereotypeFactory().getStereotype("JavaClass"), helpers);
    }

    protected JavaClass(Class<?> clazz, BridgeStereotype stereotype, Helpers helpers) {
        super(stereotype, helpers);
        this.setAbstract(Modifier.isAbstract(clazz.getModifiers()));
        this.type = clazz;
        this.fullName = clazz.getName();
    }

    public JavaClass(String name, MapEntry mapEntry, ImportClassLoader classloader, Helpers helpers) throws ClassNotFoundException {
        super(helpers.getStereotypeFactory().getStereotype("MapEntry"), helpers);
        this.importable = true;
        this.fullName = "ch.e2e.bridge.map." + name;
        this.setPropertyValueQuietly(PROPERTY_PACKAGE, "ch.e2e.bridge.map");
        this.setOwningPackage(this.getHelpers().getPackagesFactory().getPackage("ch.e2e.bridge.map".replace('.', '/'), this.getHelpers().getStereotypeFactory().getStereotype("Repository")));
        this.setName(name);
        Class<?> keyClass = classloader.loadClass(mapEntry.getKey().getName());
        Attribute key = new Attribute("key", TypeInfo.getTypeInfo(keyClass, classloader), this, helpers);
        key.setGetterPrefix("get");
        this.addAttribute(key);
        Class<?> valueClass = classloader.loadClass(mapEntry.getValue().getName());
        Attribute value = new Attribute("value", TypeInfo.getTypeInfo(valueClass, classloader), this, helpers);
        value.setGetterPrefix("get");
        this.addAttribute(value);
    }

    public void initialize(ImportClassLoader classLoader) throws UserAbortedClassSearchException {
        if (!this.initialized) {
            this.initialized = true;
            this.importable = this.checkImportable(this.type, classLoader);
            String[] names = this.split(this.fullName);
            if (names[0] != null) {
                BridgePackage owningPackage;
                this.setPropertyValueQuietly(PROPERTY_PACKAGE, names[0]);
                for (BridgePackage parent = owningPackage = this.getHelpers().getPackagesFactory().getPackage(names[0].replace('.', '/'), this.getHelpers().getStereotypeFactory().getStereotype("Repository")); parent != null; parent = parent.getOwningPackage()) {
                    parent.setModule(null);
                }
                this.setOwningPackage(owningPackage);
            }
            this.setName(names[1]);
            this.setDescription(classLoader.getDescription(this.fullName));
            this.findAttributes(this.type, classLoader);
            this.findOperations(this.type, classLoader);
        }
    }

    public Class<?> getJavaType() {
        return this.type;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean isImportable() {
        return this.importable;
    }

    public boolean hasPublicDefaultConstructor() {
        return this.publicDefaultConstructor;
    }

    @Override
    public String toString() {
        return this.getFullName();
    }

    @Override
    protected boolean containsOperationDefinition(String name) {
        return true;
    }

    private boolean checkImportable(Class<?> clazz, ImportClassLoader classLoader) throws UserAbortedClassSearchException {
        this.publicDefaultConstructor = this.hasPublicDefaultConstructor(clazz, classLoader);
        return (this.publicDefaultConstructor || this.hasPublicStaticOperation(clazz, classLoader)) && !clazz.isEnum();
    }

    private boolean hasPublicDefaultConstructor(Class<?> clazz, ImportClassLoader classLoader) throws UserAbortedClassSearchException {
        boolean result = false;
        try {
            Constructor<?>[] constructors = clazz.getDeclaredConstructors();
            for (int i = 0; i < constructors.length && !result; ++i) {
                result = Modifier.isPublic(constructors[i].getModifiers()) && !Modifier.isAbstract(constructors[i].getModifiers());
            }
        }
        catch (Throwable e) {
            if (classLoader.getAbortException() == null) {
                Logging.logger.warning("Could not load one or more depending class of '" + this.getFullName() + "'.");
            }
            throw classLoader.getAbortException();
        }
        return result;
    }

    private boolean hasPublicStaticOperation(Class<?> clazz, ImportClassLoader classLoader) throws UserAbortedClassSearchException {
        boolean result = false;
        try {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length && !result; ++i) {
                result = Modifier.isPublic(methods[i].getModifiers()) && Modifier.isStatic(methods[i].getModifiers());
            }
        }
        catch (Throwable e) {
            if (classLoader.getAbortException() == null) {
                Logging.logger.warning("Could not load one or more depending class of '" + this.getFullName() + "'.");
            }
            throw classLoader.getAbortException();
        }
        return result;
    }

    private void setDescription(String description) {
        if (description != null && !description.isEmpty()) {
            this.setDescription(new Comment("<html>" + description + "</html>", this.getHelpers()));
        }
    }

    protected void findAttributes(Class<?> clazz, ImportClassLoader classLoader) throws UserAbortedClassSearchException {
        if (this.publicDefaultConstructor) {
            try {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    Class<?> type = field.getType();
                    String attribute = field.getName();
                    String methodPostfix = Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
                    try {
                        Method getter = this.findGetter(methodPostfix, type, clazz);
                        try {
                            if (getter == null || !this.findSetter(methodPostfix, field, clazz)) continue;
                            String name = getter.getName();
                            String getterPrefix = name.substring(0, name.length() - methodPostfix.length());
                            TypeInfo typeInfo = TypeInfo.getTypeInfo(type, classLoader);
                            if (typeInfo == null) {
                                this.getter.remove(getter);
                                continue;
                            }
                            Attribute attr = new Attribute(field.getName(), typeInfo, getterPrefix, this, this.getHelpers());
                            this.setAttributeDescription(attr, clazz.getName(), field.getName(), classLoader);
                            this.addAttribute(attr);
                        }
                        catch (NoSuchMethodException e) {
                            this.getter.remove(getter);
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable e) {
                if (classLoader.getAbortException() != null) {
                    throw classLoader.getAbortException();
                }
                Logging.logger.warning("Could not load one or more field class of '" + this.getFullName() + "'.");
            }
        }
    }

    private void setAttributeDescription(Attribute attr, String className, String fieldName, ImportClassLoader classLoader) {
        String description;
        Parameter property = classLoader.getProperty(className, fieldName);
        if (property != null && (description = property.getDescription()) != null && !description.isEmpty()) {
            attr.setDescription(new Comment("<html>" + description + "</html>", this.getHelpers()));
        }
    }

    private boolean findSetter(String methodPostfix, Field field, Class<?> clazz) throws NoSuchMethodException {
        Method setter = clazz.getMethod("set" + methodPostfix, field.getType());
        boolean isPublic = Modifier.isPublic(setter.getModifiers());
        if (isPublic) {
            this.setter.add(setter);
        }
        return isPublic;
    }

    private Method findGetter(String methodPostfix, Class<?> type, Class<?> clazz) throws NoSuchMethodException {
        boolean isPublic;
        Method getter;
        try {
            getter = clazz.getMethod("get" + methodPostfix, new Class[0]);
            isPublic = Modifier.isPublic(getter.getModifiers());
        }
        catch (NoSuchMethodException ex) {
            if (Boolean.class.isAssignableFrom(type) || type.isPrimitive() && type.getName().equals("boolean")) {
                getter = clazz.getMethod("is" + methodPostfix, new Class[0]);
                isPublic = Modifier.isPublic(getter.getModifiers());
            }
            throw ex;
        }
        if (isPublic) {
            this.getter.add(getter);
        }
        return getter;
    }

    protected void findOperations(Class<?> clazz, ImportClassLoader classLoader) throws UserAbortedClassSearchException {
        try {
            Method[] methods = clazz.getDeclaredMethods();
            if (this.publicDefaultConstructor) {
                for (Method method : methods) {
                    if (!Modifier.isPublic(method.getModifiers()) || Modifier.isVolatile(method.getModifiers()) || this.setter.contains(method) || this.getter.contains(method)) continue;
                    try {
                        this.addOperation(new Operation(method, this.getName(), classLoader, this.getHelpers()));
                    }
                    catch (JavaTypeNotSupportedException e) {
                        JavaOperationImportWarning warning = new JavaOperationImportWarning(method.toString());
                        XSLTErrorHandler.getInstance().warning((BuilderWarning)warning);
                        Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                    }
                }
            } else {
                for (Method method : methods) {
                    if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers()) || !JavaClass.isNotExcluded(method)) continue;
                    try {
                        this.addOperation(new Operation(method, this.getName(), classLoader, this.getHelpers()));
                    }
                    catch (JavaTypeNotSupportedException e) {
                        JavaOperationImportWarning warning = new JavaOperationImportWarning(method.toString());
                        XSLTErrorHandler.getInstance().warning((BuilderWarning)warning);
                        Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                    }
                }
            }
        }
        catch (NoClassDefFoundError e) {
            if (classLoader.getAbortException() != null) {
                throw classLoader.getAbortException();
            }
            Logging.logger.warning("Could not load one or more parameter class of a operation in class '" + this.getFullName() + "'.");
        }
        catch (Throwable e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public String getKey(Completable child) {
        return "class";
    }

    private String[] split(String className) {
        String[] names = new String[]{null, null};
        int idx = className.lastIndexOf(46);
        if (idx > 0) {
            names[0] = className.substring(0, idx);
            names[1] = className.substring(idx + 1);
        } else {
            names[1] = className;
        }
        return names;
    }

    protected static boolean isNotExcluded(Method method) {
        return Arrays.stream(method.getAnnotations()).map(Annotation::annotationType).noneMatch(annotation -> annotation.getName().equals(XumlExclude.class.getName()));
    }
}

