/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.descriptor;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.DescriptorElement;
import ch.e2e.builder.compiler.descriptor.RepositoryArchiveResource;
import ch.e2e.builder.compiler.descriptor.RepositoryResource;
import ch.e2e.builder.compiler.descriptor.ResourceList;
import ch.e2e.builder.compiler.document.IncludesFile;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.error.DefaultCompilerWarning;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import ch.e2e.swing.TreeObject;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class UIResource
extends RepositoryResource
implements TreeObject {
    private static HTMLFileFilter htmlFileFilter = new HTMLFileFilter();

    public UIResource(Element xmlElement, DescriptorElement parent) {
        super(xmlElement, parent);
        this.readResources(xmlElement, "Resource");
    }

    public Object getChild(int index) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public int getIndexOfChild(Object child) {
        return 0;
    }

    public boolean isLeaf() {
        return true;
    }

    public int getType() {
        return 7000;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Set<String> applyToTargetFiles(Consumer<Map.Entry<String, InputStream>> consumer, AbstractErrorHandler errorHandler) throws IOException {
        HashSet<String> result = new HashSet<String>();
        UmlDocument umlDocument = this.findUmlDocument();
        if (umlDocument != null) {
            this.applyToHTDOCSFiles(consumer, umlDocument, result, new ArrayList<String>(), errorHandler);
        }
        ResourceList resources = this.getResources();
        resources.sort((o1, o2) -> {
            if (o1 instanceof RepositoryArchiveResource) {
                return 1;
            }
            if (o2 instanceof RepositoryArchiveResource) {
                return -1;
            }
            return 0;
        });
        for (RepositoryResource resource : resources) {
            result.addAll(resource.applyToTargetFiles(consumer, errorHandler));
        }
        return result;
    }

    public void applyToHTDOCSFiles(Consumer<Map.Entry<String, InputStream>> consumer, UmlDocument umlDocument, Set<String> result, ArrayList<String> checkedDocuments, AbstractErrorHandler errorHandler) throws IOException {
        if (!checkedDocuments.contains(umlDocument.getUniqueId())) {
            checkedDocuments.add(umlDocument.getUniqueId());
            HashMap<String, IncludesFile> includesFiles = umlDocument.getDocumentInfo().getDependsFile().getIncludesFiles();
            for (IncludesFile includesFile : includesFiles.values()) {
                UmlDocument includeDocument = umlDocument.getUmlDocumentFactory().getUmlDocumentById(includesFile.getUmlFileID());
                this.applyToHTDOCSFiles(consumer, includeDocument, result, checkedDocuments, errorHandler);
            }
            File htdocsFolder = new File(umlDocument.getDocumentWorkingFolder(), "htdocs/");
            if (htdocsFolder.exists()) {
                File[] allFiles;
                for (File file : allFiles = FileUtilities.getAllFiles((File)htdocsFolder, (boolean)true)) {
                    String name = "htdocs/" + FileUtilities.getRelativePath((File)file, (File)htdocsFolder);
                    if (result.contains(name)) {
                        HashMap<String, String> parameter = new HashMap<String, String>();
                        parameter.put("resource.name", name);
                        DefaultCompilerWarning error = new DefaultCompilerWarning("warning.repository.duplicate.ui.resource", parameter);
                        errorHandler.error((AbstractBuilderError)error);
                    }
                    try (FileInputStream inputStream = new FileInputStream(file);){
                        consumer.accept(new AbstractMap.SimpleEntry<String, FileInputStream>(name, inputStream));
                        result.add(name);
                    }
                }
            }
        }
    }

    private UmlDocument findUmlDocument() {
        UmlDocument umlDocument = null;
        DescriptorElement parent = this.getParent();
        do {
            if (parent instanceof CompilableObject) {
                umlDocument = ((CompilableObject)parent).getUmlDocument();
                continue;
            }
            parent = parent instanceof RepositoryResource ? ((RepositoryResource)parent).getParent() : null;
        } while (umlDocument == null && parent != null);
        return umlDocument;
    }

    @Override
    protected RepositoryResource createResource(Element node) {
        RepositoryResource result = super.createResource(node);
        result.setTargetFolder(this.getTargetFolder());
        if (result instanceof RepositoryArchiveResource) {
            ((RepositoryArchiveResource)result).setExtractFolder(this.getTargetFolder());
        }
        return result;
    }

    protected void printSourceDocument(Document sourceDocument) {
        String development;
        if (sourceDocument != null && (development = System.getProperty("ch.e2e.builder.development")) != null && development.equalsIgnoreCase("true")) {
            String filename = "uiresource.html2dict";
            try {
                File developmentDir = new File(System.getProperty("ch.e2e.builder.development.dir"));
                if (!developmentDir.exists()) {
                    developmentDir.mkdirs();
                }
                File file = new File(developmentDir, filename);
                System.out.println("Writing " + file);
                DomUtilities.serialize((File)file, (Document)sourceDocument, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Document createHtmlSourceDocument() throws IOException, ParserConfigurationException, SAXException {
        File projectHome = this.getUmlDocument().getSettings().getProjectFolder();
        File templatesFolder = new File(projectHome, this.getTemplatesFolder());
        File[] allHtmlFiles = FileUtilities.getFileList((File)templatesFolder, (FileFilter)htmlFileFilter, (boolean)true);
        Document result = DomUtilities.newDocument((String)"HTMLSources");
        for (File file : allHtmlFiles) {
            Element html = result.createElement("HTMLSource");
            html.setAttribute("filename", FileUtilities.getAbsolutePath((File)file));
            Document htmlDoc = DomUtilities.parse((File)file, (boolean)false, (boolean)false, (boolean)false);
            Node importedHtml = result.importNode(htmlDoc.getDocumentElement(), true);
            html.appendChild(importedHtml);
            result.getDocumentElement().appendChild(html);
        }
        return result;
    }

    private static class HTMLFileFilter
    implements FileFilter {
        private HTMLFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(".html");
        }
    }
}

