/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.logger;

import ch.e2e.builder.compiler.build.types.logger.Filter;
import ch.e2e.builder.compiler.build.types.tabfile.RichElement;
import ch.e2e.dom.DomUtilities;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Filters
extends RichElement {
    public static final String ELEMENT_NAME = "filters";
    private Map<String, Filter> filters = new LinkedHashMap<String, Filter>();

    public Filters() {
    }

    public Filters(Element tabfileElement) {
        super(tabfileElement);
        Iterator it = DomUtilities.elementIterator((NodeList)tabfileElement.getElementsByTagName("filter"));
        while (it.hasNext()) {
            Filter incoming = new Filter((Element)it.next());
            if (!incoming.hasLevel()) continue;
            this.filters.putIfAbsent(incoming.getLevel(), incoming);
        }
    }

    public void merge(Filters other) {
        this.filters.putAll(other.filters);
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    protected void prepareChildren() {
        this.appendChildren(this.filters.values());
    }

    public JsonArrayBuilder buildJson() {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (Filter f : this.filters.values()) {
            builder.add(f.buildJson());
        }
        return builder;
    }
}

