/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.gui;

import ch.e2e.builder.compiler.build.types.SubstitutionsTabfile;
import ch.e2e.builder.compiler.build.types.XmlTabfile;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.dom.DomUtilities;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AjaxTabfile
extends XmlTabfile {
    private ArrayList<String> lines;

    public AjaxTabfile(String rootElementName, String name, String filename) {
        super(rootElementName, name, filename);
    }

    @Override
    public boolean appendTable(Element table, Element configurationElement, CompilableObject compilableObject, LibraryService libraryService) {
        Element parentNode = this.getDocument().createElement(table.getNodeName());
        parentNode.setAttribute("filename", table.getAttribute("filename"));
        this.getDocument().getDocumentElement().appendChild(parentNode);
        return super.appendTable(table, parentNode, configurationElement, compilableObject);
    }

    @Override
    public void doMergePostProcess(SubstitutionsTabfile substitutions, boolean library) throws XPathExpressionException {
        NodeList result = (NodeList)DomUtilities.evaluate((Node)this.getTabfileDocument(), (String)"//Line", (NamespaceContext)null, (QName)XPathConstants.NODESET);
        this.lines = new ArrayList();
        int length = result.getLength();
        for (int i = 0; i < length; ++i) {
            Element child = (Element)result.item(i);
            String line = DomUtilities.getTextValue((Element)child, null);
            if (line == null || this.lines.contains(line)) continue;
            this.lines.add(line);
        }
        super.doMergePostProcess(substitutions, library);
    }

    @Override
    public String getFullName(boolean library) {
        String result = library ? "tabfiles/" + this.getOriginalName() + this.getExtension(library) : "htdocs/" + this.getKey(library);
        return result;
    }

    @Override
    public void serialize(OutputStream outputStream, boolean indent, boolean library) throws Exception {
        if (library) {
            super.serialize(outputStream, indent, library);
        } else {
            PrintWriter writer = new PrintWriter(outputStream);
            for (String line : this.lines) {
                writer.println(line);
            }
            writer.flush();
        }
    }

    @Override
    public String getKey(boolean library) {
        return library ? this.getName() : super.getKey(library);
    }

    @Override
    protected Document getDocument() {
        Document result;
        if (this.getTabfileDocument() == null) {
            result = DomUtilities.newDocument((String)"AjaxEntries");
            result.getDocumentElement().setAttribute("multiTabfileDocument", "true");
            result.getDocumentElement().setAttribute("rootElementName", this.getRootElementName());
            this.setTabfileDocument(result);
        } else {
            result = this.getTabfileDocument();
        }
        return result;
    }
}

