/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.addons;

import ch.e2e.builder.compiler.build.types.SubstitutionsTabfile;
import ch.e2e.builder.compiler.build.types.XmlTabfile;
import ch.e2e.builder.compiler.build.types.addons.InputHeaderRoles;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.dom.DomUtilities;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipOutputStream;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class ServiceBase
extends XmlTabfile {
    private Set<String> badVariables = new HashSet<String>();
    private Set<String> portNumbers = new TreeSet<String>();
    private InputHeaderRoles headerRoles;
    private boolean hasMaxRqBodySize = false;
    private boolean hasMaxRqHeaderSize = false;

    public ServiceBase(String rootElementName, String name, String filename) {
        super(rootElementName, name, filename);
    }

    @Override
    public void doMergePostProcess(SubstitutionsTabfile substitutions, boolean library) throws XPathExpressionException {
        for (String badVariable : this.badVariables) {
            substitutions.removeVariableFromTemplate(badVariable, this.getName());
        }
        if (library) {
            for (String variableName : this.getKnownVariables()) {
                substitutions.removeVariableFromTemplate(variableName, this.getName());
            }
        }
        super.doMergePostProcess(substitutions, library);
    }

    private String extractVarName(String var) {
        return var.substring(2, var.length() - 1);
    }

    @Override
    public boolean appendTable(Element table, Element configurationElement, CompilableObject compilableObject, LibraryService libraryService) {
        Element replaced = (Element)this.doReplace(table, configurationElement, compilableObject);
        Iterator childIterator = DomUtilities.elementIterator((NodeList)replaced.getChildNodes());
        while (childIterator.hasNext()) {
            Element child = (Element)childIterator.next();
            if ("PortNumber".equals(child.getTagName())) {
                String value = child.getTextContent().trim();
                if ("".equals(value)) continue;
                this.portNumbers.add(child.getTextContent().trim());
                continue;
            }
            if ("incomingHttpHeaderRoles".equals(child.getTagName())) {
                if (this.headerRoles != null) continue;
                this.headerRoles = new InputHeaderRoles(child);
                continue;
            }
            if (child.getTextContent().length() < 4) continue;
            String variableName = this.extractVarName(child.getTextContent());
            if (!this.getKnownVariables().contains(variableName)) {
                this.badVariables.add(variableName);
                continue;
            }
            if (this.getMaxRqBodySizeVarName().equals(variableName)) {
                this.hasMaxRqBodySize = true;
                continue;
            }
            if (!this.getMaxRqHeaderSizeVarName().equals(variableName)) continue;
            this.hasMaxRqHeaderSize = true;
        }
        return true;
    }

    @Override
    public void beforeSerialize(ZipOutputStream zipOut, String fileName, Boolean library) throws Exception {
        if (!library.booleanValue()) {
            this.prepareDocument(library);
            super.beforeSerialize(zipOut, fileName, library);
        }
    }

    @Override
    public void serialize(OutputStream outputStream, boolean indent, boolean library) throws Exception {
        if (!library) {
            super.serialize(outputStream, indent, library);
        }
    }

    public void prepareDocument(boolean library) {
        this.setTabfileDocument(null);
        Element root = this.getDocument().getDocumentElement();
        root.removeAttribute("xmlns:xmi");
        this.addChild(root, "MaximumConnections", "${" + this.getMaxConnectionsVarName() + "}");
        this.addChild(root, "ResolveHostnames", "${" + this.getResolveHostnamesVarName() + "}");
        this.addChild(root, "TracingAllowed", "${" + this.getTracingAllowedVarName() + "}");
        if (this.hasMaxRqBodySize) {
            this.addChild(root, "maxRequestBodySize", "${" + this.getMaxRqBodySizeVarName() + "}");
        }
        if (this.hasMaxRqHeaderSize) {
            this.addChild(root, "maxRequestHeaderSize", "${" + this.getMaxRqHeaderSizeVarName() + "}");
        }
        for (String portNumber : this.portNumbers) {
            this.addChild(root, "PortNumber", portNumber);
        }
        if (this.headerRoles != null) {
            this.headerRoles.buildDom(root, library);
        }
    }

    protected void addChild(Element parent, String tagName, String content) {
        Element child = parent.getOwnerDocument().createElement(tagName);
        child.setTextContent(content);
        parent.appendChild(child);
    }

    public abstract List<String> getKnownVariables();

    public abstract String getMaxConnectionsVarName();

    public abstract String getMaxRqBodySizeVarName();

    public abstract String getMaxRqHeaderSizeVarName();

    public abstract String getResolveHostnamesVarName();

    public abstract String getTracingAllowedVarName();
}

