/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.AbstractTabfile;
import ch.e2e.dom.DomUtilities;
import ch.e2e.xuml.template.ResourceTemplate;
import ch.e2e.xuml.template.Template;
import ch.e2e.xuml.template.TemplateProcessingException;
import ch.e2e.xuml.template.TemplateProcessor;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LoggerTemplate
extends AbstractTabfile {
    public static final String LOGGER_JSON_TEMPLATE = "ch/e2e/builder/compiler/logger.json";
    private final File loggerJson;
    private String serverLogLevel;
    private String transactionLogLevel;

    public LoggerTemplate(File repositoryFolder) {
        super(repositoryFolder, "tabfiles/Base/logger.tab");
        this.loggerJson = new File(repositoryFolder.getParentFile(), "logger.json");
        this.serverLogLevel = "Info";
        this.transactionLogLevel = "None";
        File tabfile = new File(repositoryFolder, this.getTabfileName());
        if (tabfile.exists()) {
            try {
                Document loggerDoc = DomUtilities.parse((File)tabfile, (boolean)false, (boolean)false);
                this.serverLogLevel = (String)DomUtilities.evaluate((Node)loggerDoc.getDocumentElement(), (String)"LogFiles/LogFile/Level/text()", (QName)XPathConstants.STRING);
                this.transactionLogLevel = (String)DomUtilities.evaluate((Node)loggerDoc.getDocumentElement(), (String)"TransactionFiles/TransactionFile/Level/text()", (QName)XPathConstants.STRING);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public File getLoggerJson() {
        return this.loggerJson;
    }

    public void write() throws IOException, TransformerException, TemplateProcessingException {
        this.writeLoggerConf();
        this.writeTabFile();
    }

    private void writeLoggerConf() throws TemplateProcessingException {
        ResourceTemplate template = new ResourceTemplate(LOGGER_JSON_TEMPLATE, this.loggerJson, this.getClass().getClassLoader());
        TemplateProcessor processor = new TemplateProcessor((Template)template, null);
        processor.addSubstitution("LOGLEVEL", this.getServerLogLevel());
        processor.addSubstitution("TRANSACTION_LOGLEVEL", TransactionLogLevel.valueOfInternal(this.getTransactionLogLevel()).toString());
        processor.processAndWrite();
    }

    private void writeTabFile() throws IOException, TransformerException {
        Document document = DomUtilities.newDocument((String)"Logger");
        Element logFiles = document.createElement("LogFiles");
        Element logFile = document.createElement("LogFile");
        Element logFileName = document.createElement("Name");
        logFileName.appendChild(document.createTextNode("logs/bridgeserver_"));
        logFile.appendChild(logFileName);
        Element level = document.createElement("Level");
        level.appendChild(document.createTextNode(this.serverLogLevel));
        logFile.appendChild(level);
        Element zone = document.createElement("Zone");
        zone.appendChild(document.createTextNode("LOCAL"));
        logFile.appendChild(zone);
        logFiles.appendChild(logFile);
        Element stdErr = document.createElement("StdErr");
        level = document.createElement("Level");
        level.appendChild(document.createTextNode(this.serverLogLevel));
        stdErr.appendChild(level);
        zone = document.createElement("Zone");
        zone.appendChild(document.createTextNode("Local"));
        stdErr.appendChild(zone);
        Element format = document.createElement("Format");
        format.appendChild(document.createTextNode("%Time%:%Level%:%Category%:%Domain%:%Code%:%Description%"));
        stdErr.appendChild(format);
        logFiles.appendChild(stdErr);
        document.getDocumentElement().appendChild(logFiles);
        Element transactionFiles = document.createElement("TransactionFiles");
        Element transactionFile = document.createElement("TransactionFile");
        logFileName = document.createElement("Name");
        logFileName.appendChild(document.createTextNode("logs/transaction_"));
        transactionFile.appendChild(logFileName);
        level = document.createElement("Level");
        level.appendChild(document.createTextNode(this.transactionLogLevel));
        transactionFile.appendChild(level);
        transactionFiles.appendChild(transactionFile);
        document.getDocumentElement().appendChild(transactionFiles);
        this.write(document);
    }

    public String getServerLogLevel() {
        return this.serverLogLevel;
    }

    public void setServerLogLevel(String serverLogLevel) {
        this.serverLogLevel = serverLogLevel;
    }

    public String getTransactionLogLevel() {
        return this.transactionLogLevel;
    }

    public void setTransactionLogLevel(String transactionLogLevel) {
        this.transactionLogLevel = transactionLogLevel;
    }

    public static enum TransactionLogLevel {
        NONE("None"),
        CUSTOM("Custom"),
        SERVICE("Service"),
        IO_EXTERNAL("IOExternal"),
        IO_INTERNAL("IOInternal");

        private static final Map<String, TransactionLogLevel> VALUES;
        private final String internalName;

        private TransactionLogLevel(String internalName) {
            this.internalName = internalName;
        }

        private String getInternalName() {
            return this.internalName;
        }

        public static TransactionLogLevel valueOfInternal(String internalName) {
            return VALUES.getOrDefault(internalName, NONE);
        }

        static {
            VALUES = Stream.of(TransactionLogLevel.values()).collect(Collectors.toMap(TransactionLogLevel::getInternalName, Function.identity()));
        }
    }
}

