/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.ZipUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ImportDocument {
    private static final List<String> neverImportedChildren = new ArrayList<String>();
    private final UmlDocument umlDocument;
    private final String umlPrefix;
    private Map<String, Element> elementMap;
    private Map<String, Element> libraryElements;
    private Map<String, List<String>> subclasses;

    public ImportDocument(UmlDocument umlDocument) {
        this.umlDocument = umlDocument;
        this.umlPrefix = umlDocument.getUniqueId() + '|';
    }

    public String getUmlPrefix() {
        return this.umlPrefix;
    }

    public boolean exists() {
        return this.umlDocument.getBridgeXmiFile().exists();
    }

    public boolean isUsed() {
        return this.elementMap != null;
    }

    public Map<String, Element> getLibraryElements() throws IOException, ParserConfigurationException, SAXException {
        if (this.libraryElements == null) {
            this.createElementMap();
        }
        return this.libraryElements;
    }

    public String getXmiVersion() {
        return this.umlDocument.getDocumentInfo().getXmiVersion();
    }

    public Element getElement(String id) throws IOException, ParserConfigurationException, SAXException {
        if (this.elementMap == null) {
            this.createElementMap();
        }
        return this.elementMap.get(id);
    }

    public UmlDocument getUmlDocument() {
        return this.umlDocument;
    }

    public List<String> getSubclasses(String id) {
        return this.subclasses == null ? new ArrayList() : (this.subclasses.containsKey(id) ? this.subclasses.get(id) : new ArrayList());
    }

    private void addElement(Element parent) {
        if (parent.hasAttribute("xmi:id")) {
            this.elementMap.put(parent.getAttribute("xmi:id"), parent);
        }
        NodeList children = parent.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            this.addElement((Element)node);
        }
    }

    private void removeNeverImportedChildren(Element parent) {
        ArrayList<Node> elementsToRemove = new ArrayList<Node>();
        NodeList children = parent.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            if (neverImportedChildren.contains(node.getLocalName())) {
                elementsToRemove.add(node);
                continue;
            }
            if (!(node instanceof Element)) continue;
            if (node.getNodeName().equals("ownedBehavior") && !((Element)node).getAttribute("xmi:type").equals("uml:StateMachine")) {
                elementsToRemove.add(node);
            } else if (((Element)node).getAttribute("xmi:type").equals("uml:StateMachine")) {
                this.removeAllNotStateChildren(node);
            }
            if (((Element)node).getAttribute("xmi:type").equals("uml:Activity")) {
                this.removedUnusedActivityChildren((Element)node);
                continue;
            }
            this.removeNeverImportedChildren((Element)node);
        }
        for (Node node : elementsToRemove) {
            parent.removeChild(node);
        }
    }

    private void removeAllNotStateChildren(Node parent) {
        ArrayList<Node> elementsToRemove = new ArrayList<Node>();
        NodeList children = parent.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            if (children.item(i).getNodeName().equals("region")) {
                this.removeElementsNotEntryAndExitPoint((Element)children.item(i));
                if (children.item(i).getChildNodes().getLength() != 0) continue;
                elementsToRemove.add(children.item(i));
                continue;
            }
            elementsToRemove.add(children.item(i));
        }
        for (Node node : elementsToRemove) {
            parent.removeChild(node);
        }
    }

    private void removeElementsNotEntryAndExitPoint(Element region) {
        ArrayList<Node> elementsToRemove = new ArrayList<Node>();
        NodeList children = region.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            if (children.item(i).getNodeName().equals("subvertex")) {
                String kind = ((Element)children.item(i)).getAttribute("kind");
                if (kind.equals("entryPoint") || kind.equals("exitPoint")) continue;
                elementsToRemove.add(children.item(i));
                continue;
            }
            elementsToRemove.add(children.item(i));
        }
        for (Node node : elementsToRemove) {
            region.removeChild(node);
        }
    }

    private void removedUnusedActivityChildren(Element activity) {
        ArrayList<Node> nodesToRemove = new ArrayList<Node>();
        NodeList children = activity.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            if (node.getNodeName().equals("ownedParameter")) continue;
            nodesToRemove.add(node);
        }
        for (Node node : nodesToRemove) {
            activity.removeChild(node);
        }
    }

    private Document getDocument(File file) throws IOException, ParserConfigurationException, SAXException {
        Document result;
        try {
            result = ZipUtilities.getZippedDocumentFromFile((File)file);
        }
        catch (ZipException zipEx) {
            result = DomUtilities.parse((File)file, (boolean)false, (boolean)false);
        }
        return result;
    }

    private void createElementMap() throws IOException, ParserConfigurationException, SAXException {
        Element element;
        int i;
        int length;
        NodeList xPathResult2;
        Document document = this.getDocument(this.umlDocument.getBridgeXmiFile());
        Element documentElement = document.getDocumentElement();
        try {
            NodeList states = (NodeList)DomUtilities.evaluate((Node)documentElement, (String)"//subvertex", (QName)XPathConstants.NODESET);
            this.removeNeverImportedChildren(documentElement);
            this.createElementMap(documentElement, states);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        this.libraryElements = new HashMap<String, Element>();
        try {
            xPathResult2 = (NodeList)DomUtilities.evaluate((Node)document.getDocumentElement(), (String)"//ebp:E2ELibraryProxyDeployment/parent::*", (QName)XPathConstants.NODESET);
            length = xPathResult2.getLength();
            for (i = 0; i < length; ++i) {
                element = (Element)xPathResult2.item(i);
                this.libraryElements.put(element.getAttribute("xmi:id"), element);
            }
        }
        catch (XPathExpressionException xPathResult2) {
            // empty catch block
        }
        this.subclasses = new HashMap<String, List<String>>();
        try {
            NodeList subclassNodeList = (NodeList)DomUtilities.evaluate((Node)document.getDocumentElement(), (String)"//generalization", (QName)XPathConstants.NODESET);
            length = subclassNodeList.getLength();
            for (i = 0; i < length; ++i) {
                Element subclass = (Element)subclassNodeList.item(i);
                if (!subclass.hasAttribute("general")) continue;
                String general = subclass.getAttribute("general");
                List subclassList = this.subclasses.computeIfAbsent(general, key -> new ArrayList());
                subclassList.add(((Element)subclass.getParentNode()).getAttribute("xmi:id"));
            }
        }
        catch (XPathExpressionException subclassNodeList) {
            // empty catch block
        }
        try {
            xPathResult2 = (NodeList)DomUtilities.evaluate((Node)document.getDocumentElement(), (String)"//ebp:E2ELibraryProxy/parent::*", (QName)XPathConstants.NODESET);
            length = xPathResult2.getLength();
            for (i = 0; i < length; ++i) {
                element = (Element)xPathResult2.item(i);
                this.libraryElements.put(element.getAttribute("xmi:id"), element);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
    }

    private void createElementMap(Element root, NodeList states) {
        this.elementMap = new HashMap<String, Element>();
        if (states.getLength() > 0) {
            Element importedStates = root.getOwnerDocument().createElement("ImportedStates");
            int length = states.getLength();
            for (int i = 0; i < length; ++i) {
                Node state = states.item(i);
                Element stateElement = root.getOwnerDocument().createElement(state.getNodeName());
                DomUtilities.copyAttributes((Node)state, (Element)stateElement);
                importedStates.appendChild(stateElement);
            }
            root.appendChild(importedStates);
        }
        this.addElement(root);
    }

    static {
        neverImportedChildren.add("Documentation");
    }
}

