/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.libraries;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.source.FileSource;
import ch.e2e.builder.compiler.build.tasks.source.IDLSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.build.tasks.uml.UmlHelper;
import ch.e2e.builder.compiler.document.importer.IDLImportSource;
import ch.e2e.builder.compiler.library.Library;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class Library2LrepIdlTask
extends CacheAbleTask
implements IDLSource,
XSLTTransformSource {
    private Document idl;
    private IDLImportSource idlImportSource;

    public static Boolean select(String id) {
        return id.endsWith(Extensions._library_lrep_idl_xml);
    }

    public Library2LrepIdlTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getSourceId());
        return result;
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._library_lrep_idl_xml;
    }

    protected String getSourceId() {
        return Files.libs__LIBRARY_lrep(this.getDestinationFileNameWithoutExtension());
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            FileSource library = (FileSource)this.getSource(this.getSourceId());
            this.idl = Library.getLibraryInfo(library.getFile());
            this.getDestinationFile().getParentFile().mkdirs();
            DomUtilities.serialize((File)this.getDestinationFile(), (Document)this.idl, (boolean)true);
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    @Override
    public IDLImportSource getIDLImportSource() {
        if (this.idlImportSource == null) {
            if (this.idl == null && this.isUpToDate()) {
                try {
                    this.idl = DomUtilities.parse((File)this.getDestinationFile(), (boolean)false, (boolean)false, (boolean)true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.idl != null) {
                this.idlImportSource = new Library(this.idl.getDocumentElement(), UmlHelper.getWorkUmlImportsFolder(this.getSourceManager().getWorkFolder()), new Helpers());
                this.idlImportSource.getImportModel().setCreate(true);
            }
        }
        return this.idlImportSource;
    }

    @Override
    public Source getXSLTTransformSource() {
        try {
            return new StreamSource(this.getDestinationFile());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

