/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.libraries;

import ch.e2e.builder.compiler.document.importer.IDLImportSource;
import ch.e2e.builder.compiler.document.json.idl.Idl;
import ch.e2e.builder.compiler.document.json.idl.IdlAttribute;
import ch.e2e.builder.compiler.document.json.idl.IdlClass;
import ch.e2e.builder.compiler.document.json.idl.IdlPackage;
import ch.e2e.builder.compiler.document.json.idl.IdlTyped;
import ch.e2e.builder.compiler.document.json.xuml.XumlAppliedStereotype;
import ch.e2e.builder.compiler.document.json.xuml.value.XumlValue;
import ch.e2e.builder.compiler.document.json.xuml.value.XumlValueSimple;
import ch.e2e.builder.compiler.document.json.xuml.value.XumlValueSimpleArray;
import ch.e2e.builder.compiler.models.EBMClass;
import ch.e2e.builder.compiler.models.EBMElement;
import ch.e2e.builder.compiler.models.EBMHelper;
import ch.e2e.builder.compiler.uml.BridgeAttribute;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.DataModel;
import ch.e2e.builder.compiler.uml.Generalization;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Multiplicity;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.builder.compiler.utils.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JsonIdlImportSource
extends IDLImportSource {
    private Idl idl;

    public Idl getOriginalIdl() {
        return this.idl;
    }

    public static Idl getIdl(File file) {
        try {
            JAXBContext jaxbContext = JAXBContextFactory.createContext((Class[])new Class[]{Idl.class}, new HashMap());
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            jaxbUnmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            jaxbUnmarshaller.setProperty("eclipselink.json.include-root", (Object)false);
            return (Idl)jaxbUnmarshaller.unmarshal((Source)new StreamSource(file), Idl.class).getValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public JsonIdlImportSource(String libName, Idl idl, File importFolder, Helpers helpers) {
        super(libName, importFolder, helpers);
        this.idl = idl;
    }

    @Override
    protected BridgePackage fillDataModel(DataModel dataModel, IDLImportSource.ElementMaps elementMaps) {
        HashMap classes = new HashMap();
        BridgePackage rootPackage = this.getHelpers().getPackagesFactory().createPackages(dataModel.getName(), dataModel.getModel().getOrigin(), this.getHelpers().getStereotypeFactory().getStereotype("Repository"));
        dataModel.addPackage(rootPackage);
        rootPackage.setModule(dataModel.getModule());
        dataModel.addSharedPackage(rootPackage);
        this.idl.getPackages().forEach(idlPackage -> this.createPackage((IdlPackage)idlPackage, dataModel, rootPackage, classes, elementMaps));
        this.addClassesToDataModel(dataModel, elementMaps.allElements);
        return rootPackage;
    }

    private BridgePackage createPackage(IdlPackage idlPackage, DataModel dataModel, BridgePackage rootPackage, HashMap<String, BridgeClass> classes, IDLImportSource.ElementMaps elementMaps) {
        String name = this.removeNamespaceURN(idlPackage.getName());
        BridgePackage bridgePackage = this.getHelpers().getPackagesFactory().createPackages(name, rootPackage, this.getHelpers().getStereotypeFactory().getStereotype("Repository"));
        dataModel.addPackage(bridgePackage);
        elementMaps.allElements.put(idlPackage, bridgePackage);
        bridgePackage.setModule(dataModel.getModule());
        idlPackage.getClasses().forEach(idlClass -> this.addClass((IdlClass)idlClass, bridgePackage, dataModel, classes, elementMaps));
        idlPackage.getClasses().forEach(idlClass -> {
            if (idlClass.getGeneral() != null && idlClass.getGeneral().getType() != null) {
                this.addGeneral(elementMaps.allClasses.get(idlClass.getGeneral().getType()), elementMaps.allClasses.get(idlClass.getId()));
            }
        });
        BridgePackage returnBridgePackage = bridgePackage;
        while (returnBridgePackage.getOwningPackage() != null && !returnBridgePackage.getOwningPackage().equals(dataModel.getModel().getOrigin())) {
            returnBridgePackage = returnBridgePackage.getOwningPackage();
        }
        return returnBridgePackage;
    }

    private BridgeClass addClass(IdlClass idlClass, BridgePackage aPackage, DataModel dataModel, HashMap<String, BridgeClass> classes, IDLImportSource.ElementMaps elementMaps) {
        BridgeClass clazz = this.createBridgeClass(idlClass, aPackage, dataModel);
        this.initializeClass(clazz, idlClass, dataModel, classes, elementMaps);
        this.applyStereotypes(clazz, idlClass.getAppliedStereotypes());
        return clazz;
    }

    private void applyStereotypes(UmlElement umlElement, List<XumlAppliedStereotype> stereotypes) {
        if (stereotypes != null) {
            stereotypes.forEach(stereotype -> {
                umlElement.setStereotype(this.getHelpers().getStereotypeFactory().getStereotype(stereotype.getStereotype()));
                stereotype.getTagValues().forEach(tagValue -> umlElement.setPropertyValueQuietly(tagValue.getKey(), this.getStereotypeValue((XumlValue)tagValue)));
            });
        }
    }

    private Object getStereotypeValue(XumlValue tagValue) {
        if (tagValue instanceof XumlValueSimple) {
            return ((XumlValueSimple)tagValue).getValue();
        }
        if (tagValue instanceof XumlValueSimpleArray) {
            return ((XumlValueSimpleArray)tagValue).getItems().stream().map(item -> ((Node)item).getTextContent()).collect(Collectors.toList());
        }
        return null;
    }

    private void addGeneral(UmlElement general, UmlElement specific) {
        specific.addGeneral(new Generalization(general, specific, this.getHelpers()));
    }

    private BridgeClass createBridgeClass(IdlClass idlClass, BridgePackage aPackage, DataModel dataModel) {
        BridgeClass clazz = new BridgeClass(idlClass.getName(), new Comment("", this.getHelpers()), null, this.getHelpers());
        clazz.setOwningPackage(aPackage);
        clazz.setModule(dataModel.getModule());
        clazz.setAbstract(false);
        return clazz;
    }

    private void initializeClass(BridgeClass clazz, IdlClass idlClass, DataModel dataModel, HashMap<String, BridgeClass> classes, IDLImportSource.ElementMaps elementMaps) {
        idlClass.getAttributes().forEach(idlAttribute -> this.addAttribute((IdlAttribute)idlAttribute, clazz, elementMaps));
        classes.put(idlClass.getId(), clazz);
        elementMaps.allClasses.put(idlClass.getId(), clazz);
        elementMaps.allReferableElements.put(idlClass.getId(), clazz);
        elementMaps.allElements.put(idlClass, clazz);
    }

    private void addAttribute(IdlAttribute idlAttribute, BridgeClass clazz, IDLImportSource.ElementMaps elementMaps) {
        BridgeAttribute attribute = new BridgeAttribute(idlAttribute.getName(), new Comment("", this.getHelpers()), null, this.getHelpers());
        clazz.addAttribute(attribute);
        attribute.setModule(clazz.getModule());
        if (idlAttribute.getMultiplicity() != null) {
            switch (idlAttribute.getMultiplicity()) {
                case "1": 
                case "1..1": {
                    attribute.setMultiplicity(Multiplicity.createMultiplicity(0));
                    break;
                }
                case "0..1": {
                    attribute.setMultiplicity(Multiplicity.createMultiplicity(3));
                    break;
                }
                case "0..*": {
                    attribute.setMultiplicity(Multiplicity.createMultiplicity(4));
                }
            }
        }
        if (idlAttribute.getDefault() != null) {
            attribute.setDefaultValue(idlAttribute.getDefault(), "uml:Literal" + idlAttribute.getType().substring("E2E Bridge Base.xml#http://www.e2e.ch/bridge/types/".length()));
        }
        elementMaps.typedElements.put(idlAttribute, attribute);
        elementMaps.allElements.put(idlAttribute, attribute);
    }

    @Override
    protected UmlElement findType(Object element, HashMap<String, UmlElement> classes) {
        UmlElement type = null;
        if (element instanceof IdlTyped) {
            String typeString = ((IdlTyped)element).getType();
            if (typeString.contains("#")) {
                String xmiId = StringUtils.substringAfter(typeString, "#");
                EBMElement ebmElement = EBMHelper.getModels().findById(EBMClass.class, xmiId);
                if (ebmElement != null) {
                    type = this.getHelpers().getElementHelper().getBridgeClass(null, ebmElement, null);
                }
            }
            if (type == null) {
                type = classes.get(typeString);
            }
        }
        return type;
    }

    @Override
    public String getTypeFromOriginalObject(Object element) {
        if (element instanceof Element) {
            return ((Element)element).getAttribute("type");
        }
        return "";
    }
}

