/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model;

import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.model.BuildTask;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import java.io.File;
import java.util.Set;

public class BuildLibraryTask
extends BuildTask {
    public static String TASK_ID = "library.build";

    public static Boolean select(String id) {
        return id.equals(TASK_ID);
    }

    public BuildLibraryTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    private XumlProject getProjectDocument() {
        return ((JsonDocumentSource)this.getSourceManager().getSource(Files.project_xml)).getJsonDocument(XumlProject.class);
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add(Files.project_xml);
        return result;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add(Folders.uml_ + this.getProjectDocument().getName() + Extensions._lrep_uml_compile);
        return result;
    }

    @Override
    public File getDestinationFile() {
        return new File(this.sourceManager.getWorkFolder(), Files.repository__DOCUMENTNAME__PROJECTNAME_lrep(this.getProjectDocument().getName()));
    }
}

