/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.process;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.compiler.build.tasks.Task;
import ch.e2e.builder.compiler.event.SendErrorEvent;
import ch.e2e.builder.compiler.event.SendStatusEvent;
import ch.e2e.builder.compiler.event.SendSuccessEvent;
import ch.e2e.builder.compiler.event.SendWarningEvent;
import ch.e2e.builder.compiler.xsltinterface.XSLTInput;
import ch.e2e.builder.compiler.xsltinterface.XSLTOutput;
import ch.e2e.event.EventController;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;

public abstract class Process {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_ERROR = 1;
    private long startTime;
    private Object source;
    private int status = 0;

    public int getStatus() {
        return this.status;
    }

    public Object getSource() {
        return this.source != null ? this.source : this;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    protected Task getTask(String taskKey) {
        return null;
    }

    protected String getBuildTypeMessage(String taskKey) {
        return "Build";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractErrorHandler run(String taskKey) {
        Task task = this.getTask(taskKey);
        if (task != null) {
            try {
                XSLTInput.init();
                XSLTOutput.reset();
                this.doBuildStartup(taskKey);
                task.execute();
            }
            catch (Exception e) {
                this.status = 1;
                EventController.fire((EventObject)((Object)new SendErrorEvent(this.getSource(), e)));
            }
            finally {
                this.buildFinished(taskKey);
            }
            return task.getErrorHandler();
        }
        return new AbstractErrorHandler(){};
    }

    protected void doBuildStartup(String taskKey) {
        EventController.fire((EventObject)((Object)new SendStatusEvent(this.getSource(), "status.compiling")));
        this.startTime = new Date().getTime();
        this.sendStartInfoMessage(taskKey);
    }

    protected void buildFinished(String taskKey) {
        Object event;
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        replaceMap.put("build.type", this.getBuildTypeMessage(taskKey));
        long time = (new Date().getTime() - this.startTime) / 1000L;
        String timeStr = String.valueOf(time);
        replaceMap.put("build.time", timeStr);
        int errors = this.getErrorCount(taskKey);
        int warnings = this.getWarningCount(taskKey);
        replaceMap.put("error.count", String.valueOf(errors));
        replaceMap.put("warning.count", String.valueOf(warnings));
        if (errors > 0) {
            this.status = 1;
            event = warnings > 0 ? new SendErrorEvent(this.getSource(), "build.with.errors.and.warnings", replaceMap) : new SendErrorEvent(this.getSource(), "build.with.errors", replaceMap);
        } else {
            event = warnings > 0 ? new SendWarningEvent(this.getSource(), "build.with.warnings", replaceMap) : new SendSuccessEvent(this.getSource(), "build.successfull", replaceMap);
        }
        EventController.fire((EventObject)event);
    }

    protected abstract void sendStartInfoMessage(String var1);

    protected abstract int getErrorCount(String var1);

    protected abstract int getWarningCount(String var1);
}

