/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.hex.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.fife.ui.hex.swing.HexTable;

class HexEditorRowHeader
extends JList
implements TableModelListener {
    private static final long serialVersionUID = 1L;
    private HexTable table;
    private RowHeaderListModel model;
    private static final Border CELL_BORDER = BorderFactory.createEmptyBorder(0, 5, 0, 5);

    public HexEditorRowHeader(HexTable hexTable) {
        this.table = hexTable;
        this.model = new RowHeaderListModel();
        this.setModel(this.model);
        this.setFocusable(false);
        this.setFont(hexTable.getFont());
        this.setFixedCellHeight(hexTable.getRowHeight());
        this.setCellRenderer(new CellRenderer());
        this.setBorder(new RowHeaderBorder());
        this.setSelectionMode(1);
        this.syncRowCount();
        hexTable.getModel().addTableModelListener(this);
    }

    @Override
    public void addSelectionInterval(int n, int n2) {
        super.addSelectionInterval(n, n2);
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        this.table.setSelectedRows(n3, n4);
    }

    @Override
    public void removeSelectionInterval(int n, int n2) {
        super.removeSelectionInterval(n, n2);
        int n3 = this.getAnchorSelectionIndex();
        int n4 = this.getLeadSelectionIndex();
        this.table.setSelectedRows(Math.min(n3, n4), Math.max(n3, n4));
    }

    @Override
    public void setSelectionInterval(int n, int n2) {
        super.setSelectionInterval(n, n2);
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        this.table.setSelectedRows(n3, n4);
    }

    private void syncRowCount() {
        if (this.table.getRowCount() != this.model.getSize()) {
            this.model.setSize(this.table.getRowCount());
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.syncRowCount();
    }

    private class RowHeaderBorder
    extends EmptyBorder {
        private static final long serialVersionUID = 1L;

        public RowHeaderBorder() {
            super(0, 0, 0, 2);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            n = n + n3 - this.right;
            graphics.setColor(HexEditorRowHeader.this.table.getGridColor());
            graphics.drawLine(n, n2, n, n2 + n4);
        }
    }

    private static class RowHeaderListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;
        private int size;

        private RowHeaderListModel() {
        }

        @Override
        public Object getElementAt(int n) {
            return "0x" + Integer.toHexString(n * 16);
        }

        @Override
        public int getSize() {
            return this.size;
        }

        public void setSize(int n) {
            int n2 = this.size;
            this.size = n;
            int n3 = n - n2;
            if (n3 > 0) {
                this.fireIntervalAdded(this, n2, n - 1);
            } else if (n3 < 0) {
                this.fireIntervalRemoved(this, n + 1, n2 - 1);
            }
        }
    }

    private class CellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        public CellRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, false, bl2);
            this.setBorder(CELL_BORDER);
            return this;
        }
    }
}

